/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.DataSourceForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class SaveDataSourceAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List DataSources Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        DataSourceForm dataSourceForm = (DataSourceForm)form;
        String objectName = dataSourceForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{dataSourceForm.getJndiName(), "javax.sql.DataSource"};
            String encodedJndiName = URLEncoder.encode(params[0].toString(), "UTF-8");
            String resourcetype = dataSourceForm.getResourcetype();
            String path = dataSourceForm.getPath();
            String host = dataSourceForm.getHost();
            String domain = dataSourceForm.getDomain();
            ObjectName oname = null;
            ObjectName encodedOName = null;
            try {
                if (resourcetype.equals("Global")) {
                    oname = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global" + ",class=" + params[1] + ",name=" + params[0]);
                    encodedOName = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global" + ",class=" + params[1] + ",name=" + encodedJndiName);
                } else if (resourcetype.equals("Context")) {
                    oname = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context" + ",path=" + path + ",host=" + host + ",class=" + params[1] + ",name=" + params[0]);
                    encodedOName = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context" + ",path=" + path + ",host=" + host + ",class=" + params[1] + ",name=" + encodedJndiName);
                }
                if (this.mserver.isRegistered(oname) || this.mserver.isRegistered(encodedOName)) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("jndiName", new ActionMessage("resources.invalid.name"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                objectName = (String)this.mserver.invoke(oname, "addResource", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"addResource"), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"addResource"));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName oname = new ObjectName(objectName);
            attribute = "url";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getUrl()));
            attribute = "driverClassName";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getDriverClass()));
            attribute = "username";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getUsername()));
            attribute = "password";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getPassword()));
            attribute = "maxActive";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getActive()));
            attribute = "maxIdle";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getIdle()));
            attribute = "maxWait";
            this.mserver.setAttribute(oname, new Attribute(attribute, dataSourceForm.getWait()));
            attribute = "validationQuery";
            String validationQuery = dataSourceForm.getQuery();
            if (validationQuery != null && validationQuery.length() > 0) {
                this.mserver.setAttribute(oname, new Attribute(attribute, validationQuery));
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        return mapping.findForward("DataSources List Setup");
    }
}

