/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Substitutor;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.apache.naming.resources.ResourceAttributes;

public class HostConfig
implements LifecycleListener,
Runnable {
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    private Context context = null;
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected int debug = 0;
    protected ArrayList deployed = new ArrayList();
    private Digester digester = null;
    protected Host host = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private int checkInterval = 15;
    private boolean deployXML = false;
    private boolean liveDeploy = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "HostConfig";
    private boolean unpackWARs = false;
    private HashMap webXmlLastModified = new HashMap();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isLiveDeploy() {
        return this.liveDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.liveDeploy = liveDeploy;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                int hostDebug = ((StandardHost)this.host).getDebug();
                if (hostDebug > this.debug) {
                    this.debug = hostDebug;
                }
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setLiveDeploy(((StandardHost)this.host).getLiveDeploy());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected File appBase() {
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        return file;
    }

    protected void deployApps() {
        File appBase;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.deploying"));
        }
        if (!(appBase = this.appBase()).exists() || !appBase.isDirectory()) {
            return;
        }
        String[] files = appBase.list();
        this.checkDeployed();
        this.deployDescriptors(appBase, files);
        this.deployWARs(appBase, files);
        this.deployDirectories(appBase, files);
    }

    protected void checkDeployed() {
        ArrayList copy = (ArrayList)this.deployed.clone();
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            File file = new File(this.appBase(), filename);
            if (file.exists() || file.isDirectory()) continue;
            this.deployed.remove(filename);
        }
    }

    protected void deployDescriptors(File appBase, String[] files) {
        if (!this.deployXML) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i])) continue;
            File dir = new File(appBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".xml")) continue;
            this.deployed.add(files[i]);
            String file = files[i].substring(0, files[i].length() - 4);
            String contextPath = "/" + file;
            if (file.equals("ROOT")) {
                contextPath = "";
            } else {
                String path = this.getContextPath(dir);
                if (path != null) {
                    contextPath = path;
                }
            }
            if (this.host.findChild(contextPath) != null) continue;
            this.log(sm.getString("hostConfig.deployDescriptor", files[i]));
            try {
                URL config = new URL("file", null, dir.getCanonicalPath());
                ((Deployer)((Object)this.host)).install(config, null);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.deployDescriptor.error", files[i]), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized String getContextPath(File configFile) {
        String contextPath;
        block11: {
            InputStream stream;
            block10: {
                stream = null;
                contextPath = null;
                URL config = new URL("file", null, configFile.getCanonicalPath());
                stream = config.openStream();
                Digester digester = this.createDigester();
                digester.clear();
                digester.push((Object)this);
                digester.parse(stream);
                stream.close();
                stream = null;
                if (this.context == null) break block10;
                contextPath = this.context.getPath();
            }
            Object var7_8 = null;
            if (stream == null) break block11;
            try {
                stream.close();
                break block11;
            }
            catch (Throwable t) {
                // empty catch block
            }
            {
                break block11;
                catch (Exception e) {
                    this.log("Parse exception :", e);
                    String string = null;
                    Object var7_9 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    this.digester.push(null);
                    this.context = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.digester.push(null);
                this.context = null;
                throw throwable;
            }
        }
        this.digester.push(null);
        this.context = null;
        return contextPath;
    }

    protected void enableDigesterSubstitutor(Digester digester) {
        Properties systemProperties = System.getProperties();
        MultiVariableExpander expander = new MultiVariableExpander();
        expander.addSource("$", (Map)systemProperties);
        VariableSubstitutor substitutor = new VariableSubstitutor((VariableExpander)expander);
        digester.setSubstitutor((Substitutor)substitutor);
    }

    protected Digester createDigester() {
        if (this.digester == null) {
            this.digester = new Digester();
            this.digester.setValidating(false);
            this.enableDigesterSubstitutor(this.digester);
            this.digester.addRuleSet((RuleSet)new ContextRuleSet(""));
            this.digester.addRuleSet((RuleSet)new NamingRuleSet("Context/"));
        }
        return this.digester;
    }

    public void addChild(Container child) {
        this.context = (Context)child;
    }

    public ClassLoader getParentClassLoader() {
        return this.host.getParentClassLoader();
    }

    protected synchronized void deployWARs(File appBase, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            URL url;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i])) continue;
            File dir = new File(appBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".war")) continue;
            this.deployed.add(files[i]);
            String contextPath = "/" + files[i];
            int period = contextPath.lastIndexOf(".");
            if (period >= 0) {
                contextPath = contextPath.substring(0, period);
            }
            if (contextPath.equals("/ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild(contextPath) != null) continue;
            if (this.isUnpackWARs()) {
                this.log(sm.getString("hostConfig.expand", files[i]));
                try {
                    url = new URL("jar:file:" + dir.getCanonicalPath() + "!/");
                    String path = ExpandWar.expand(this.host, url);
                    url = new URL("file:" + path);
                    ((Deployer)((Object)this.host)).install(contextPath, url);
                }
                catch (Throwable t) {
                    this.log(sm.getString("hostConfig.expand.error", files[i]), t);
                }
                continue;
            }
            this.log(sm.getString("hostConfig.deployJar", files[i]));
            try {
                url = new URL("file", null, dir.getCanonicalPath());
                url = new URL("jar:" + url.toString() + "!/");
                ((Deployer)((Object)this.host)).install(contextPath, url);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.deployJar.error", files[i]), t);
            }
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File dir;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]) || !(dir = new File(appBase, files[i])).isDirectory()) continue;
            this.deployed.add(files[i]);
            File webInf = new File(dir, "/WEB-INF");
            if (!webInf.exists() || !webInf.isDirectory() || !webInf.canRead()) continue;
            String contextPath = "/" + files[i];
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild(contextPath) != null) continue;
            this.log(sm.getString("hostConfig.deployDir", files[i]));
            try {
                URL url = new URL("file", null, dir.getCanonicalPath());
                ((Deployer)((Object)this.host)).install(contextPath, url);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.deployDir.error", files[i]), t);
            }
        }
    }

    protected void checkWebXmlLastModified() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        Deployer deployer = (Deployer)((Object)this.host);
        String[] contextNames = deployer.findDeployedApps();
        for (int i = 0; i < contextNames.length; ++i) {
            String contextName = contextNames[i];
            Context context = deployer.findDeployedApp(contextName);
            if (!(context instanceof Lifecycle)) continue;
            try {
                DirContext resources = context.getResources();
                if (resources == null) continue;
                ResourceAttributes webXmlAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF/web.xml");
                long newLastModified = webXmlAttributes.getLastModified();
                Long lastModified = (Long)this.webXmlLastModified.get(contextName);
                if (lastModified == null) {
                    this.webXmlLastModified.put(contextName, new Long(newLastModified));
                    continue;
                }
                if (lastModified == newLastModified) continue;
                this.webXmlLastModified.remove(contextName);
                ((Lifecycle)((Object)context)).stop();
                ((Lifecycle)((Object)context)).start();
                continue;
            }
            catch (LifecycleException e) {
                continue;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }

    protected String expand(URL war) throws IOException {
        return ExpandWar.expand(this.host, war);
    }

    protected void expand(InputStream input, File docBase, String name) throws IOException {
        ExpandWar.expand(input, docBase, name);
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    protected void start() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.start"));
        }
        if (this.host.getAutoDeploy()) {
            this.deployApps();
        }
        if (this.isLiveDeploy()) {
            this.threadStart();
        }
    }

    protected void stop() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.stop"));
        }
        this.threadStop();
        this.undeployApps();
    }

    protected void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.undeploying"));
        }
        String[] contextPaths = ((Deployer)((Object)this.host)).findDeployedApps();
        for (int i = 0; i < contextPaths.length; ++i) {
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.undeploy", contextPaths[i]));
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPaths[i]);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.undeploy.error", contextPaths[i]), t);
            }
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "HostConfig[" + this.host.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        while (!this.threadDone) {
            this.threadSleep();
            this.deployApps();
            this.checkWebXmlLastModified();
        }
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }
}

