/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class Parser {
    private ParserController parserController;
    private JspCompilationContext ctxt;
    private JspReader reader;
    private String currentFile;
    private Mark start;
    private Hashtable taglibs;
    private ErrorDispatcher err;

    private Parser(ParserController pc, JspReader reader) {
        this.parserController = pc;
        this.ctxt = pc.getJspCompilationContext();
        this.taglibs = pc.getCompiler().getPageInfo().getTagLibraries();
        this.err = pc.getCompiler().getErrorDispatcher();
        this.reader = reader;
        this.currentFile = reader.mark().getFile();
        this.start = reader.mark();
    }

    public static Node.Nodes parse(ParserController pc, JspReader reader, Node parent) throws JasperException {
        Parser parser = new Parser(pc, reader);
        Node.Root root = new Node.Root(null, reader.mark(), parent);
        while (reader.hasMoreInput()) {
            parser.parseElements(root);
        }
        Node.Nodes page = new Node.Nodes(root);
        return page;
    }

    Attributes parseAttributes() throws JasperException {
        AttributesImpl attrs = new AttributesImpl();
        this.reader.skipSpaces();
        while (this.parseAttribute(attrs)) {
            this.reader.skipSpaces();
        }
        return attrs;
    }

    public static Attributes parseAttributes(ParserController pc, JspReader reader) throws JasperException {
        Parser tmpParser = new Parser(pc, reader);
        return tmpParser.parseAttributes();
    }

    private boolean parseAttribute(AttributesImpl attrs) throws JasperException {
        String name = this.parseName();
        if (name == null) {
            return false;
        }
        this.reader.skipSpaces();
        if (!this.reader.matches("=")) {
            this.err.jspError(this.reader.mark(), "jsp.error.attribute.noequal");
        }
        this.reader.skipSpaces();
        char quote = (char)this.reader.nextChar();
        if (quote != '\'' && quote != '\"') {
            this.err.jspError(this.reader.mark(), "jsp.error.attribute.noquote");
        }
        String watchString = "";
        if (this.reader.matches("<%=")) {
            watchString = "%>";
        }
        watchString = watchString + quote;
        String attr = this.parseAttributeValue(watchString);
        attrs.addAttribute("", name, name, "CDATA", attr);
        return true;
    }

    private String parseName() throws JasperException {
        char ch = (char)this.reader.peekChar();
        if (Character.isLetter(ch) || ch == '_' || ch == ':') {
            StringBuffer buf = new StringBuffer();
            buf.append(ch);
            this.reader.nextChar();
            ch = (char)this.reader.peekChar();
            while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '_' || ch == '-' || ch == ':') {
                buf.append(ch);
                this.reader.nextChar();
                ch = (char)this.reader.peekChar();
            }
            return buf.toString();
        }
        return null;
    }

    private String parseAttributeValue(String watch) throws JasperException {
        Mark start = this.reader.mark();
        Mark stop = this.reader.skipUntilIgnoreEsc(watch);
        if (stop == null) {
            this.err.jspError(start, "jsp.error.attribute.unterminated", watch);
        }
        String ret = this.parseQuoted(this.reader.getText(start, stop));
        if (watch.length() == 1) {
            return ret;
        }
        return "<%=" + ret + "%>";
    }

    private String parseQuoted(String tx) {
        StringBuffer buf = new StringBuffer();
        int size = tx.length();
        int i = 0;
        while (i < size) {
            char ch = tx.charAt(i);
            if (ch == '&') {
                if (i + 5 < size && tx.charAt(i + 1) == 'a' && tx.charAt(i + 2) == 'p' && tx.charAt(i + 3) == 'o' && tx.charAt(i + 4) == 's' && tx.charAt(i + 5) == ';') {
                    buf.append('\'');
                    i += 6;
                    continue;
                }
                if (i + 5 < size && tx.charAt(i + 1) == 'q' && tx.charAt(i + 2) == 'u' && tx.charAt(i + 3) == 'o' && tx.charAt(i + 4) == 't' && tx.charAt(i + 5) == ';') {
                    buf.append('\"');
                    i += 6;
                    continue;
                }
                buf.append(ch);
                ++i;
                continue;
            }
            if (ch == '\\' && i + 1 < size) {
                ch = tx.charAt(i + 1);
                if (ch == '\\' || ch == '\"' || ch == '\'' || ch == '>') {
                    buf.append(ch);
                    i += 2;
                    continue;
                }
                buf.append('\\');
                ++i;
                continue;
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    private String parseScriptText(String tx) {
        CharArrayWriter cw = new CharArrayWriter();
        int size = tx.length();
        int i = 0;
        while (i < size) {
            char ch = tx.charAt(i);
            if (i + 2 < size && ch == '%' && tx.charAt(i + 1) == '\\' && tx.charAt(i + 2) == '>') {
                cw.write(37);
                cw.write(62);
                i += 3;
                continue;
            }
            cw.write(ch);
            ++i;
        }
        cw.close();
        return cw.toString();
    }

    private void processIncludeDirective(String file, Node parent) throws JasperException {
        if (file == null) {
            return;
        }
        try {
            this.parserController.parse(file, parent);
        }
        catch (FileNotFoundException ex) {
            this.err.jspError(this.start, "jsp.error.file.not.found", file);
        }
        catch (Exception ex) {
            this.err.jspError(this.start, ex.getMessage());
        }
    }

    private void parsePageDirective(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        Node.PageDirective n = new Node.PageDirective(attrs, this.start, parent);
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (!"import".equals(attrs.getQName(i))) continue;
            n.addImport(attrs.getValue(i));
        }
    }

    private void parseIncludeDirective(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        Node.IncludeDirective includeNode = new Node.IncludeDirective(attrs, this.start, parent);
        this.processIncludeDirective(attrs.getValue("file"), includeNode);
    }

    private void parseTaglibDirective(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        String uri = attrs.getValue("uri");
        String prefix = attrs.getValue("prefix");
        if (uri != null && prefix != null) {
            String[] location = this.ctxt.getTldLocation(uri);
            TagLibraryInfoImpl tl = new TagLibraryInfoImpl(this.ctxt, prefix, uri, location, this.err);
            this.taglibs.put(prefix, tl);
        }
        new Node.TaglibDirective(attrs, this.start, parent);
    }

    private void parseDirective(Node parent) throws JasperException {
        this.reader.skipSpaces();
        String directive = null;
        if (this.reader.matches("page")) {
            directive = "<%@ page";
            this.parsePageDirective(parent);
        } else if (this.reader.matches("include")) {
            directive = "<%@ include";
            this.parseIncludeDirective(parent);
        } else if (this.reader.matches("taglib")) {
            directive = "<%@ taglib";
            this.parseTaglibDirective(parent);
        } else {
            this.err.jspError(this.reader.mark(), "jsp.error.invalid.directive");
        }
        this.reader.skipSpaces();
        if (!this.reader.matches("%>")) {
            this.err.jspError(this.start, "jsp.error.unterminated", directive);
        }
    }

    private void parseComment(Node parent) throws JasperException {
        this.start = this.reader.mark();
        Mark stop = this.reader.skipUntil("--%>");
        if (stop == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%--");
        }
        new Node.Comment(this.reader.getText(this.start, stop), this.start, parent);
    }

    private void parseDeclaration(Node parent) throws JasperException {
        this.start = this.reader.mark();
        Mark stop = this.reader.skipUntil("%>");
        if (stop == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%!");
        }
        new Node.Declaration(this.parseScriptText(this.reader.getText(this.start, stop)), this.start, parent);
    }

    private void parseExpression(Node parent) throws JasperException {
        this.start = this.reader.mark();
        Mark stop = this.reader.skipUntil("%>");
        if (stop == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%=");
        }
        new Node.Expression(this.parseScriptText(this.reader.getText(this.start, stop)), this.start, parent);
    }

    private void parseScriptlet(Node parent) throws JasperException {
        this.start = this.reader.mark();
        Mark stop = this.reader.skipUntil("%>");
        if (stop == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%");
        }
        new Node.Scriptlet(this.parseScriptText(this.reader.getText(this.start, stop)), this.start, parent);
    }

    private void parseParam(Node parent) throws JasperException {
        if (!this.reader.matches("<jsp:param")) {
            this.err.jspError(this.reader.mark(), "jsp.error.paramexpectedonly");
        }
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:param");
        }
        new Node.ParamAction(attrs, this.start, parent);
    }

    private void parseParams(Node parent, String tag) throws JasperException {
        Mark start = this.reader.mark();
        while (this.reader.hasMoreInput() && !this.reader.matchesETag(tag)) {
            this.parseParam(parent);
            this.reader.skipSpaces();
        }
    }

    private void parseInclude(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (this.reader.matches("/>")) {
            new Node.IncludeAction(attrs, this.start, parent);
            return;
        }
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:include");
        }
        this.reader.skipSpaces();
        Node.IncludeAction includeNode = new Node.IncludeAction(attrs, this.start, parent);
        this.parseParams(includeNode, "jsp:include");
    }

    private void parseForward(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (this.reader.matches("/>")) {
            new Node.ForwardAction(attrs, this.start, parent);
            return;
        }
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:forward");
        }
        this.reader.skipSpaces();
        Node.ForwardAction forwardNode = new Node.ForwardAction(attrs, this.start, parent);
        this.parseParams(forwardNode, "jsp:forward");
    }

    private void parseGetProperty(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:getProperty");
        }
        new Node.GetProperty(attrs, this.start, parent);
    }

    private void parseSetProperty(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:setProperty");
        }
        new Node.SetProperty(attrs, this.start, parent);
    }

    private void parseUseBean(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (this.reader.matches("/>")) {
            new Node.UseBean(attrs, this.start, parent);
            return;
        }
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;jsp:useBean");
        }
        Node.UseBean beanNode = new Node.UseBean(attrs, this.start, parent);
        this.parseBody(beanNode, "jsp:useBean");
    }

    private void parseJspParams(Node parent) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.params.notclosed");
        }
        this.reader.skipSpaces();
        Node.ParamsAction jspParamsNode = new Node.ParamsAction(this.start, parent);
        this.parseParams(jspParamsNode, "jsp:params");
    }

    private void parseFallBack(Node parent) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.fallback.notclosed");
        }
        Node.FallBackAction fallback = new Node.FallBackAction(this.start, parent);
        this.parseBodyText(fallback, "jsp:fallback");
    }

    private void parsePlugin(Node parent) throws JasperException {
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.plugin.notclosed");
        }
        this.reader.skipSpaces();
        Node.PlugIn pluginNode = new Node.PlugIn(attrs, this.start, parent);
        if (this.reader.matches("<jsp:params")) {
            this.parseJspParams(pluginNode);
            this.reader.skipSpaces();
        }
        if (this.reader.matches("<jsp:fallback")) {
            this.parseFallBack(pluginNode);
            this.reader.skipSpaces();
        }
        if (!this.reader.matchesETag("jsp:plugin")) {
            this.err.jspError(this.reader.mark(), "jsp.error.plugin.notclosed");
        }
    }

    private void parseAction(Node parent) throws JasperException {
        Mark start = this.reader.mark();
        if (this.reader.matches("include")) {
            this.parseInclude(parent);
        } else if (this.reader.matches("forward")) {
            this.parseForward(parent);
        } else if (this.reader.matches("getProperty")) {
            this.parseGetProperty(parent);
        } else if (this.reader.matches("setProperty")) {
            this.parseSetProperty(parent);
        } else if (this.reader.matches("useBean")) {
            this.parseUseBean(parent);
        } else if (this.reader.matches("plugin")) {
            this.parsePlugin(parent);
        } else {
            this.err.jspError(start, "jsp.error.badaction");
        }
    }

    private boolean parseCustomTag(Node parent) throws JasperException {
        if (this.reader.peekChar() != 60) {
            return false;
        }
        this.reader.nextChar();
        String tagName = this.reader.parseToken(false);
        int i = tagName.indexOf(58);
        if (i == -1) {
            this.reader.reset(this.start);
            return false;
        }
        String prefix = tagName.substring(0, i);
        String shortTagName = tagName.substring(i + 1);
        TagLibraryInfo tagLibInfo = (TagLibraryInfo)this.taglibs.get(prefix);
        if (tagLibInfo == null) {
            this.reader.reset(this.start);
            return false;
        }
        TagInfo tagInfo = tagLibInfo.getTag(shortTagName);
        if (tagInfo == null) {
            this.err.jspError(this.start, "jsp.error.bad_tag", shortTagName, prefix);
        }
        Class<?> tagHandlerClass = null;
        try {
            tagHandlerClass = this.ctxt.getClassLoader().loadClass(tagInfo.getTagClassName());
        }
        catch (Exception e) {
            this.err.jspError(this.start, "jsp.error.unable.loadclass", shortTagName, prefix);
        }
        Attributes attrs = this.parseAttributes();
        this.reader.skipSpaces();
        if (this.reader.matches("/>")) {
            new Node.CustomTag(attrs, this.start, tagName, prefix, shortTagName, tagInfo, tagHandlerClass, parent);
            return true;
        }
        if (!this.reader.matches(">")) {
            this.err.jspError(this.start, "jsp.error.unterminated.tag");
        }
        String bc = tagInfo.getBodyContent();
        Node.CustomTag tagNode = new Node.CustomTag(attrs, this.start, tagName, prefix, shortTagName, tagInfo, tagHandlerClass, parent);
        if (bc.equalsIgnoreCase("EMPTY")) {
            if (!this.reader.matchesETag(tagName)) {
                this.err.jspError(this.start, "jasper.error.emptybodycontent.nonempty", tagName);
            }
        } else if (bc.equalsIgnoreCase("TAGDEPENDENT")) {
            this.parseBodyText(tagNode, tagName);
        } else if (bc.equalsIgnoreCase("JSP")) {
            this.parseBody(tagNode, tagName);
        } else {
            this.err.jspError(this.start, "jasper.error.bad.bodycontent.type");
        }
        return true;
    }

    private void parseTemplateText(Node parent) throws JasperException {
        if (this.reader.matches("<\\%")) {
            String content = this.reader.nextContent();
            new Node.TemplateText("<%" + content, this.start, parent);
        } else {
            new Node.TemplateText(this.reader.nextContent(), this.start, parent);
        }
    }

    private void parseElements(Node parent) throws JasperException {
        this.start = this.reader.mark();
        if (this.reader.matches("<%--")) {
            this.parseComment(parent);
        } else if (this.reader.matches("<%@")) {
            this.parseDirective(parent);
        } else if (this.reader.matches("<%!")) {
            this.parseDeclaration(parent);
        } else if (this.reader.matches("<%=")) {
            this.parseExpression(parent);
        } else if (this.reader.matches("<%")) {
            this.parseScriptlet(parent);
        } else if (this.reader.matches("<jsp:")) {
            this.parseAction(parent);
        } else if (!this.parseCustomTag(parent)) {
            this.parseTemplateText(parent);
        }
    }

    private void parseBodyText(Node parent, String tag) throws JasperException {
        Mark bodyStart = this.reader.mark();
        Mark bodyEnd = this.reader.skipUntilETag(tag);
        if (bodyEnd == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + tag + "&gt;");
        }
        new Node.TemplateText(this.reader.getText(bodyStart, bodyEnd), bodyStart, parent);
    }

    private void parseBody(Node parent, String tag) throws JasperException {
        while (this.reader.hasMoreInput()) {
            if (this.reader.matchesETag(tag)) {
                return;
            }
            this.parseElements(parent);
        }
        this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + tag + "&gt;");
    }
}

