/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeLookup;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
extends FeatureDescriptor
implements Lookup.Provider,
HelpCtx.Provider {
    public static final Node EMPTY = new AbstractNode(Children.LEAF);
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_NAME = "name";
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_ICON = "icon";
    public static final String PROP_OPENED_ICON = "openedIcon";
    public static final String PROP_PARENT_NODE = "parentNode";
    public static final String PROP_PROPERTY_SETS = "propertySets";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_LEAF = "leaf";
    private static final Logger err = Logger.getLogger("org.openide.nodes.Node");
    private static Map<EventListenerList, Reference<Lookup>> lookups = new WeakHashMap<EventListenerList, Reference<Lookup>>(37);
    private static final Set<String> warnedBadProperties = new HashSet<String>(100);
    private static final Lookup.Template<Cookie> TEMPL_COOKIE = new Lookup.Template(Cookie.class);
    private static final Object INIT_LOCK = new Object();
    private Object parent;
    Children hierarchy;
    private transient EventListenerList listeners;

    protected Node(Children children) throws IllegalStateException {
        this(children, null);
    }

    protected Node(Children children, Lookup lookup) throws IllegalStateException {
        this.hierarchy = children;
        lookup = this.replaceProvidedLookup(lookup);
        this.listeners = lookup != null ? new LookupEventList(lookup) : new EventListenerList();
        children.attachTo(this);
    }

    Lookup replaceProvidedLookup(Lookup lookup) {
        return lookup;
    }

    final Lookup internalLookup(boolean bl) {
        if (this.listeners instanceof LookupEventList) {
            return ((LookupEventList)this.listeners).init(bl);
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        Children children = this.hierarchy instanceof Cloneable ? (Children)this.hierarchy.cloneHierarchy() : Children.LEAF;
        node.hierarchy = children;
        children.attachTo(node);
        node.parent = null;
        node.listeners = this.listeners instanceof LookupEventList ? new LookupEventList(this.internalLookup(false)) : new EventListenerList();
        return node;
    }

    public abstract Node cloneNode();

    private Children getParentChildren() {
        Object object = this.parent;
        return object instanceof ChildrenArray ? ((ChildrenArray)object).getChildren() : (Children)object;
    }

    final synchronized void assignTo(Children children, int n) {
        Children children2 = this.getParentChildren();
        if (children2 != null && children2 != children) {
            throw new IllegalStateException("Cannot initialize " + n + "th child of node " + children.getNode() + "; it already belongs to node " + children2.getNode());
        }
        if (!(this.parent instanceof ChildrenArray)) {
            this.parent = children;
        }
    }

    final synchronized void reassignTo(Children children, ChildrenArray childrenArray) {
        if (this.parent != children && this.parent != childrenArray) {
            throw new IllegalStateException("Unauthorized call to change parent: " + this.parent + " and should be: " + children);
        }
        this.parent = childrenArray;
    }

    final synchronized void deassignFrom(Children children) {
        Children children2 = this.getParentChildren();
        if (children != children2) {
            throw new IllegalArgumentException("Deassign from wrong parent. Old: " + children2 + " Caller: " + children);
        }
        this.parent = null;
    }

    @Override
    public void setName(String string) {
        String string2 = super.getName();
        if (string2 == null || !string2.equals(string)) {
            super.setName(string);
            this.fireNameChange(string2, string);
        }
    }

    @Override
    public void setDisplayName(String string) {
        String string2 = super.getDisplayName();
        if (string2 == null || !string2.equals(string)) {
            super.setDisplayName(string);
            this.fireDisplayNameChange(string2, string);
        }
    }

    @Override
    public void setShortDescription(String string) {
        String string2 = super.getShortDescription();
        if (string2 == null || !string2.equals(string)) {
            super.setShortDescription(string);
            this.fireShortDescriptionChange(string2, string);
        }
    }

    public abstract Image getIcon(int var1);

    public abstract Image getOpenedIcon(int var1);

    public abstract HelpCtx getHelpCtx();

    public final Children getChildren() {
        this.updateChildren();
        return this.hierarchy;
    }

    void updateChildren() {
    }

    protected final void setChildren(final Children children) {
        Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                Node[] nodeArray = null;
                if (Node.this.hierarchy.isInitialized()) {
                    nodeArray = Node.this.hierarchy.getNodes();
                }
                Node.this.hierarchy.detachFrom();
                boolean bl = Node.this.hierarchy == Children.LEAF;
                Node.this.hierarchy = children;
                Node.this.hierarchy.attachTo(Node.this);
                if (bl != (Node.this.hierarchy == Children.LEAF)) {
                    Node.this.fireOwnPropertyChange(Node.PROP_LEAF, bl, Node.this.hierarchy == Children.LEAF);
                }
                if (nodeArray != null && !bl) {
                    Node.this.fireSubNodesChange(false, nodeArray, nodeArray);
                    Node[] nodeArray2 = Node.this.hierarchy.getNodes();
                    if (nodeArray2.length > 0) {
                        Node.this.fireSubNodesChange(true, nodeArray2, null);
                    }
                }
            }
        });
    }

    public final boolean isLeaf() {
        this.updateChildren();
        return this.hierarchy == Children.LEAF;
    }

    public final Node getParentNode() {
        Children children = this.getParentChildren();
        return children == null ? null : children.getNode();
    }

    public abstract boolean canRename();

    public abstract boolean canDestroy();

    public void destroy() throws IOException {
        Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                Children children = Node.this.getParentChildren();
                if (children != null) {
                    children.remove(new Node[]{Node.this});
                }
                Node.this.fireNodeDestroyed();
            }
        });
    }

    public abstract PropertySet[] getPropertySets();

    public abstract Transferable clipboardCopy() throws IOException;

    public abstract Transferable clipboardCut() throws IOException;

    public abstract Transferable drag() throws IOException;

    public abstract boolean canCopy();

    public abstract boolean canCut();

    public abstract PasteType[] getPasteTypes(Transferable var1);

    public abstract PasteType getDropType(Transferable var1, int var2, int var3);

    public abstract NewType[] getNewTypes();

    public Action[] getActions(boolean bl) {
        return bl ? this.getContextActions() : this.getActions();
    }

    @Deprecated
    public SystemAction[] getActions() {
        return NodeOp.getDefaultActions();
    }

    @Deprecated
    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    @Deprecated
    public SystemAction getDefaultAction() {
        return null;
    }

    public Action getPreferredAction() {
        return this.getDefaultAction();
    }

    public final JPopupMenu getContextMenu() {
        return NodeOp.findContextMenuImpl(new Node[]{this}, null);
    }

    public abstract boolean hasCustomizer();

    public abstract Component getCustomizer();

    public <T extends Cookie> T getCookie(Class<T> clazz) {
        Lookup lookup = this.internalLookup(true);
        if (lookup != null) {
            Object object = lookup.lookup(clazz);
            if (Cookie.class.isInstance(object)) {
                return (T)((Cookie)clazz.cast(object));
            }
            CookieSet.enhancedQueryMode(lookup, clazz);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup getLookup() {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            Lookup lookup = this.internalLookup(true);
            if (lookup != null) {
                return lookup;
            }
            lookup = this.findDelegatingLookup();
            if (lookup != null) {
                return lookup;
            }
            NodeLookup nodeLookup = new NodeLookup(this);
            this.registerDelegatingLookup(nodeLookup);
            return nodeLookup;
        }
    }

    public String getHtmlDisplayName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerDelegatingLookup(NodeLookup nodeLookup) {
        Map<EventListenerList, Reference<Lookup>> map = lookups;
        synchronized (map) {
            lookups.put(this.listeners, new WeakReference<NodeLookup>(nodeLookup));
        }
    }

    final Lookup findDelegatingLookup() {
        Reference<Lookup> reference = lookups.get(this.listeners);
        return reference == null ? null : reference.get();
    }

    public abstract Handle getHandle();

    public final void addNodeListener(NodeListener nodeListener) {
        this.listeners.add(NodeListener.class, nodeListener);
        this.listenerAdded();
    }

    void listenerAdded() {
    }

    public final void removeNodeListener(NodeListener nodeListener) {
        this.listeners.remove(NodeListener.class, nodeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = -1;
        if (err.isLoggable(Level.FINE)) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "ADD - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerAdded(propertyChangeListener);
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
    }

    int getPropertyChangeListenersCount() {
        return this.listeners.getListenerCount(PropertyChangeListener.class);
    }

    protected final boolean hasPropertyChangeListener() {
        return this.getPropertyChangeListenersCount() > 0;
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = -1;
        if (err.isLoggable(Level.FINE)) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "RMV - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerRemoved(propertyChangeListener);
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String string, Object object, Object object2) {
        int n;
        Object object3;
        if (err.isLoggable(Level.WARNING) && string != null && this.propertySetsAreKnown()) {
            Object object4;
            object3 = this.getPropertySets();
            boolean bl = false;
            block3: for (n = 0; n < ((PropertySet[])object3).length; ++n) {
                object4 = object3[n].getProperties();
                for (int i = 0; i < ((Property<?>[])object4).length; ++i) {
                    if (!object4[i].getName().equals(string)) continue;
                    bl = true;
                    continue block3;
                }
            }
            if (!bl) {
                Set<String> set = warnedBadProperties;
                synchronized (set) {
                    object4 = this.getClass().getName();
                    if (warnedBadProperties.add(object4 + "." + string)) {
                        StringWriter stringWriter = new StringWriter();
                        IllegalStateException illegalStateException = new IllegalStateException("Warning - the node \"" + this.getDisplayName() + "\" [" + object4 + "] is trying to fire the property " + string + " which is not included in its property sets. This is illegal. See IZ #31413 for details.");
                        illegalStateException.printStackTrace(new PrintWriter(stringWriter));
                        Logger.getLogger(Node.class.getName()).warning(stringWriter.toString());
                    }
                }
            }
        }
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        object3 = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (n = objectArray.length - 2; n >= 0; n -= 2) {
            if (objectArray[n] != PropertyChangeListener.class) continue;
            if (object3 == null) {
                object3 = new PropertyChangeEvent(this, string, object, object2);
            }
            ((PropertyChangeListener)objectArray[n + 1]).propertyChange((PropertyChangeEvent)object3);
        }
    }

    boolean propertySetsAreKnown() {
        return false;
    }

    protected final void fireNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_NAME, string, string2);
    }

    protected final void fireDisplayNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_DISPLAY_NAME, string, string2);
    }

    protected final void fireShortDescriptionChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_SHORT_DESCRIPTION, string, string2);
    }

    protected final void fireIconChange() {
        this.fireOwnPropertyChange(PROP_ICON, null, null);
    }

    protected final void fireOpenedIconChange() {
        this.fireOwnPropertyChange(PROP_OPENED_ICON, null, null);
    }

    final void fireSubNodesChange(boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        NodeMemberEvent nodeMemberEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeListener.class) continue;
            if (nodeMemberEvent == null) {
                nodeMemberEvent = new NodeMemberEvent(this, bl, nodeArray, nodeArray2);
            }
            if (bl) {
                ((NodeListener)objectArray[i + 1]).childrenAdded(nodeMemberEvent);
                continue;
            }
            ((NodeListener)objectArray[i + 1]).childrenRemoved(nodeMemberEvent);
        }
    }

    final void fireReorderChange(int[] nArray) {
        NodeReorderEvent nodeReorderEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeListener.class) continue;
            if (nodeReorderEvent == null) {
                nodeReorderEvent = new NodeReorderEvent(this, nArray);
            }
            ((NodeListener)objectArray[i + 1]).childrenReordered(nodeReorderEvent);
        }
    }

    protected final void fireNodeDestroyed() {
        NodeEvent nodeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeListener.class) continue;
            if (nodeEvent == null) {
                nodeEvent = new NodeEvent(this);
            }
            ((NodeListener)objectArray[i + 1]).nodeDestroyed(nodeEvent);
        }
    }

    final void fireParentNodeChange(Node node, Node node2) {
        this.fireOwnPropertyChange(PROP_PARENT_NODE, node, node2);
    }

    protected final void firePropertySetsChange(PropertySet[] propertySetArray, PropertySet[] propertySetArray2) {
        this.fireOwnPropertyChange(PROP_PROPERTY_SETS, propertySetArray, propertySetArray2);
    }

    protected final void fireCookieChange() {
        Lookup lookup = this.findDelegatingLookup();
        if (lookup instanceof NodeLookup) {
            ((NodeLookup)lookup).updateLookupAsCookiesAreChanged(null);
        }
        this.fireOwnPropertyChange(PROP_COOKIE, null, null);
    }

    final void fireOwnPropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeListener.class) continue;
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            ((NodeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FilterNode) {
            return ((FilterNode)object).equals(this);
        }
        return this == object;
    }

    static String getString(String string) {
        return NbBundle.getBundle(Node.class).getString(string);
    }

    @Override
    public String toString() {
        return super.toString() + "[Name=" + this.getName() + ", displayName=" + this.getDisplayName() + "]";
    }

    public static interface Cookie {
    }

    public static interface Handle
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -4518262478987434353L;

        public Node getNode() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class IndexedProperty<T, E>
    extends Property<T> {
        private Class<E> elementType;

        public IndexedProperty(Class<T> clazz, Class<E> clazz2) {
            super(clazz);
            this.elementType = clazz2;
        }

        public abstract boolean canIndexedRead();

        public Class<E> getElementType() {
            return this.elementType;
        }

        public abstract E getIndexedValue(int var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public abstract boolean canIndexedWrite();

        public abstract void setIndexedValue(int var1, E var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public PropertyEditor getIndexedPropertyEditor() {
            return PropertyEditorManager.findEditor(this.elementType);
        }

        @Override
        public boolean equals(Object object) {
            try {
                if (!super.equals(object)) {
                    return false;
                }
                Class<E> clazz = ((IndexedProperty)object).getElementType();
                Class<E> clazz2 = this.getElementType();
                if (clazz == null && clazz2 != null || clazz != null && clazz2 == null) {
                    return false;
                }
                return clazz == null && clazz2 == null || clazz.equals(clazz2);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            Class<E> clazz = this.getElementType();
            return super.hashCode() * (this.elementType == null ? 1 : this.elementType.hashCode());
        }
    }

    private final class LookupEventList
    extends EventListenerList
    implements LookupListener {
        public final Lookup lookup;
        private Lookup.Result<Cookie> result;

        public LookupEventList(Lookup lookup) {
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup init(boolean bl) {
            boolean bl2 = false;
            Object object = INIT_LOCK;
            synchronized (object) {
                if (bl && this.result == null) {
                    this.result = this.lookup.lookup(TEMPL_COOKIE);
                    assert (this.result != null) : "Null lookup result from " + this.lookup + " in " + Node.this;
                    this.result.addLookupListener((LookupListener)this);
                    bl2 = true;
                }
            }
            if (bl2) {
                this.result.allItems();
            }
            return this.lookup;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            FilterNode filterNode;
            if (Node.this instanceof FilterNode && (filterNode = (FilterNode)Node.this).getOriginal() == NodeLookup.NO_COOKIE_CHANGE.get()) {
                return;
            }
            Node.this.fireCookieChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Property<T>
    extends FeatureDescriptor {
        private static final Set<String> warnedNames = new HashSet<String>();
        private Class<T> type;
        private Reference<PropertyEditor> edRef = null;

        public Property(Class<T> clazz) {
            this.type = clazz;
            super.setName("");
        }

        public Class<T> getValueType() {
            return this.type;
        }

        public abstract boolean canRead();

        public abstract T getValue() throws IllegalAccessException, InvocationTargetException;

        public abstract boolean canWrite();

        public abstract void setValue(T var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public boolean supportsDefaultValue() {
            return false;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        }

        public boolean isDefaultValue() {
            String string = this.getClass().getName();
            if (this.supportsDefaultValue() && warnedNames.add(string)) {
                Logger.getLogger(Property.class.getName()).log(Level.WARNING, "Class " + string + " must override isDefaultValue() since it " + "overrides supportsDefaultValue() to be true");
            }
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.type == null) {
                return null;
            }
            PropertyEditor propertyEditor = null;
            if (this.edRef != null) {
                propertyEditor = this.edRef.get();
            }
            if (propertyEditor == null) {
                propertyEditor = PropertyEditorManager.findEditor(this.type);
                this.edRef = new SoftReference<PropertyEditor>(propertyEditor);
            }
            return propertyEditor;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Property)) {
                return false;
            }
            Class<T> clazz = ((Property)object).getValueType();
            Class<T> clazz2 = this.getValueType();
            if (clazz == null && clazz2 != null || clazz != null && clazz2 == null) {
                return false;
            }
            return ((Property)object).getName().equals(this.getName()) && (clazz == null && clazz2 == null || clazz.equals(clazz2));
        }

        public int hashCode() {
            Class<T> clazz = this.getValueType();
            return this.getName().hashCode() * (clazz == null ? 1 : clazz.hashCode());
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PropertySet
    extends FeatureDescriptor {
        public PropertySet() {
        }

        public PropertySet(String string, String string2, String string3) {
            super.setName(string);
            super.setDisplayName(string2);
            super.setShortDescription(string3);
        }

        public abstract Property<?>[] getProperties();

        public boolean equals(Object object) {
            if (!(object instanceof PropertySet)) {
                return false;
            }
            return ((PropertySet)object).getName().equals(this.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }
}

