/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.time;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import tr.swing.time.SpinnerCycleNumberModel;

public class SpinnerCycleNumber
extends JSpinner {
    public final int min;
    public final int max;
    private final JFormattedTextField ftf;

    public SpinnerCycleNumber(int val, int min, int max, int step) {
        this.min = min;
        this.max = max;
        this.setModel(new SpinnerCycleNumberModel(val, min, max, step));
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "00"));
        this.ftf = this.getTextField(this);
        this.ftf.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SpinnerCycleNumber.this.ftf.selectAll();
                    }
                });
            }
        });
    }

    private JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    public boolean isValidValue(int value) {
        return value >= this.min && value <= this.max;
    }

    private int getLastValue() {
        return (Integer)super.getValue();
    }

    public void setVal(int value) {
        if (this.isValidValue(value)) {
            super.setValue(new Integer(value));
        }
    }

    public int getVal() {
        return this.getLastValue();
    }
}

