/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.extract.prefs.ExtractOptionsPanelController;
import tr.extract.prefs.ExtractPrefs;

final class ExtractPanel
extends JPanel {
    private final ExtractOptionsPanelController controller;
    private JComboBox encodingCombo;
    private JLabel encodingLabel;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderTextField;

    ExtractPanel(ExtractOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.folderTextField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.folderButton = new JButton();
        this.encodingLabel = new JLabel();
        this.encodingCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ExtractPanel.class, (String)"Output"));
        this.folderLabel.setMaximumSize(new Dimension(110, 23));
        this.folderLabel.setMinimumSize(new Dimension(110, 23));
        this.folderLabel.setPreferredSize(new Dimension(110, 23));
        this.folderTextField.setMaximumSize(new Dimension(1024, 23));
        this.folderTextField.setMinimumSize(new Dimension(128, 23));
        this.folderTextField.setPreferredSize(new Dimension(128, 23));
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)NbBundle.getMessage(ExtractPanel.class, (String)"Browse"));
        this.folderButton.setMaximumSize(new Dimension(90, 26));
        this.folderButton.setMinimumSize(new Dimension(90, 26));
        this.folderButton.setPreferredSize(new Dimension(90, 26));
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractPanel.this.browse(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ExtractPanel.class, (String)"Encoding"));
        this.encodingLabel.setMaximumSize(new Dimension(110, 23));
        this.encodingLabel.setMinimumSize(new Dimension(110, 23));
        this.encodingLabel.setPreferredSize(new Dimension(110, 23));
        this.encodingCombo.setEditable(true);
        this.encodingCombo.setModel(this.getEncodingModel());
        this.encodingCombo.setMaximumSize(new Dimension(1024, 23));
        this.encodingCombo.setMinimumSize(new Dimension(128, 23));
        this.encodingCombo.setPreferredSize(new Dimension(128, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.folderLabel, -2, 103, Short.MAX_VALUE).add(1, (Component)this.encodingLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.encodingCombo, 0, 154, Short.MAX_VALUE).add((Component)this.folderTextField, -1, 154, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.folderButton, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderLabel, -2, -1, -2).add((Component)this.folderButton, -2, -1, -2).add((Component)this.folderTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.encodingLabel, -2, -1, -2).add((Component)this.encodingCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderTextField.getText()));
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = fc.showOpenDialog(p);
        if (returnVal == 0) {
            try {
                this.folderTextField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderTextField.setText("");
            }
        }
    }

    private ComboBoxModel getEncodingModel() {
        Vector<String> encodings = new Vector<String>();
        encodings.add("");
        encodings.addAll(Charset.availableCharsets().keySet());
        return new DefaultComboBoxModel(encodings);
    }

    void load() {
        this.folderTextField.setText(ExtractPrefs.getPath());
        this.encodingCombo.setSelectedItem(ExtractPrefs.getEncoding());
    }

    void store() {
        if (this.isValidPath()) {
            ExtractPrefs.setPath(this.getPath());
        }
        if (this.isValidEncoding()) {
            ExtractPrefs.setEncoding(this.getEncoding());
        }
    }

    boolean valid() {
        return this.isValidPath() && this.isValidEncoding();
    }

    private boolean isValidEncoding() {
        String encoding = this.getEncoding();
        if (encoding.length() == 0) {
            return true;
        }
        try {
            return Charset.isSupported(encoding);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getEncoding() {
        String encoding = (String)this.encodingCombo.getSelectedItem();
        return encoding == null ? "" : encoding.trim();
    }

    private boolean isValidPath() {
        String path = this.getPath();
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String getPath() {
        String path = this.folderTextField.getText().trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }
    }
}

