/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects.actions;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.awt.Toolbar;
import org.openide.cookies.ViewCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import tr.appl.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.prefs.gui.GUIPrefs;
import tr.util.Utils;
import tr.view.ReprocessAction;
import tr.view.Window;
import tr.view.projects.ActionNode;
import tr.view.projects.AddActionAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ToggleShowDoneAction;
import tr.view.projects.actions.SingleActionsRootNode;

public class SingleActionsTopComponent
extends Window
implements ExplorerManager.Provider,
LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private static final String PREFERRED_ID = "SingleActionsTopComponent";
    private static SingleActionsTopComponent instance;
    private final transient ExplorerManager manager = new ExplorerManager();
    private transient boolean initialised;
    private transient Lookup.Result dataResult;
    private transient Lookup.Result itemResult;
    private transient JToolBar toolbar;
    private JScrollPane scrollPane;

    protected SingleActionsTopComponent() {
        this.setName(this.getText("CTL_SingleActionsTopComponent"));
        this.setToolTipText(this.getText("HINT_SingleActionsTopComponent"));
        this.setIcon(Icons.SingleActions.getImage());
        this.initComponents();
        this.initialise();
    }

    private void initialise() {
        Data data;
        if (this.initialised) {
            return;
        }
        this.add(this.getToolbar(), GUIPrefs.getBorderLayoutButtonsPosition());
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    SingleActionsTopComponent.this.initialised = false;
                }
            });
        }
        if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
            return;
        }
        this.manager.setRootContext((Node)new SingleActionsRootNode((Project)data.getRootActions(), false));
        this.manager.getRootContext().setDisplayName(this.getText("CTL_SingleActionsNode"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        try {
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.initialised = true;
    }

    private JToolBar getToolbar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(AddActionAction.class), null, SystemAction.get(ReprocessAction.class), null, SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ToggleShowDoneAction.class)};
        this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        this.toolbar.setUI(new Toolbar().getUI());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(GUIPrefs.getToolBarOrientation());
        Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.setPreferredSize(buttonSize);
            component.setMinimumSize(buttonSize);
            component.setMaximumSize(buttonSize);
            component.setSize(buttonSize);
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.initialise();
    }

    public void componentActivated() {
        super.componentActivated();
        this.initialise();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SingleActionsTopComponent.this.activate();
            }
        });
    }

    private void activate() {
        this.itemResult = this.getLookup().lookup(new Lookup.Template(Item.class));
        this.itemResult.addLookupListener((LookupListener)this);
        this.itemResult.allInstances();
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length == 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
            }
            catch (Exception ex) {}
        } else if (selectedNodes[0] instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)projectNode);
        } else if (selectedNodes[0] instanceof ActionNode) {
            ActionNode actionNode = (ActionNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)actionNode);
        }
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (this.itemResult != null) {
            this.itemResult.removeLookupListener((LookupListener)this);
            this.itemResult = null;
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Node[] nodes = SingleActionsTopComponent.this.manager.getSelectedNodes();
                Node node = nodes.length > 0 ? nodes[0] : null;
                EditorTopComponent.findInstance().view(node);
            }
        });
    }

    private String getText(String key) {
        return NbBundle.getMessage(SingleActionsTopComponent.class, (String)key);
    }

    public TreeView getTreeView() {
        return (TreeView)this.scrollPane;
    }

    private void initComponents() {
        this.scrollPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane, "Center");
    }

    public static synchronized SingleActionsTopComponent getDefault() {
        if (instance == null) {
            instance = new SingleActionsTopComponent();
        }
        return instance;
    }

    public static synchronized SingleActionsTopComponent findInstance() {
        return SingleActionsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects.actions");
    }

    public void setShowDone(boolean b) {
        SingleActionsRootNode rootNode = (SingleActionsRootNode)this.manager.getRootContext();
        rootNode.setShowDone(b);
    }

    public boolean isSelected(Action action) {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes != null && nodes.length > 0 && nodes[0] instanceof ActionNode) {
            return Utils.equal((Object)((ActionNode)nodes[0]).action, (Object)action);
        }
        return false;
    }

    public synchronized void select(Action action) {
        if (!this.isOpened()) {
            return;
        }
        if (!action.isSingleAction()) {
            return;
        }
        SingleActionsRootNode rootNode = (SingleActionsRootNode)this.manager.getRootContext();
        Node node = rootNode.find(action);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            ViewCookie cookie = (ViewCookie)node.getCookie(ViewCookie.class);
            if (cookie != null) {
                cookie.view();
            }
        }
        catch (Exception ex) {
            LOG.severe("Action node could not be selected in the tree.");
        }
    }

    public void clearSelection() {
        try {
            this.manager.setSelectedNodes(new Node[0]);
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
    }

    public void edit(Project project) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(project);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
            if (cookie != null) {
                cookie.edit();
            }
        }
        catch (Exception ex) {
            LOG.severe("Project node could not be selected in the tree.");
        }
    }

    public void edit(Action action) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(action);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            EditCookie cookie = (EditCookie)node.getCookie(EditCookie.class);
            if (cookie != null) {
                cookie.edit();
            }
        }
        catch (Exception ex) {
            LOG.severe("Action node could not be selected in the tree.");
        }
    }

    public void takeFocus() {
        this.getTreeView().requestFocusInWindow();
    }
}

