/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;

public class ContextChangeAction
extends CookieAction {
    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ChangeContextAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{ContextChangeCookie.class};
    }

    public int mode() {
        return 7;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        final JDialog jd = new JDialog((Frame)null, this.getName(), true);
        ContextsComboBox cb = new ContextsComboBox((ComboBoxModel)new ContextsComboBoxModel(false));
        cb.setSelectedIndex(0);
        JPanel panel = new JPanel();
        panel.add(new JLabel(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_NewContext")));
        panel.add(cb);
        JOptionPane op = new JOptionPane(panel, 1, 2, null, null, null);
        op.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                jd.dispose();
            }
        });
        jd.getContentPane().add((Component)op, "Center");
        jd.setDefaultCloseOperation(2);
        jd.pack();
        Rectangle r = Utilities.findCenterBounds((Dimension)jd.getSize());
        jd.setLocation(r.x, r.y);
        jd.setVisible(true);
        Object value = op.getValue();
        if (value instanceof Integer && (Integer)value == 0) {
            this.change((Context)cb.getSelectedItem(), nodes);
        }
    }

    private void change(Context context, Node[] nodes) {
        if (context == null) {
            return;
        }
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            ContextChangeCookie cookie = (ContextChangeCookie)node.getCookie(ContextChangeCookie.class);
            if (cookie == null) continue;
            cookie.setContext(context);
        }
    }
}

