/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.reports.actionsbycontext;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamContext;
import tr.extract.ParamFont;
import tr.extract.ParamList;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    public String getID() {
        return "report-actions-by-context";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(8);
        params.add((Param)new ParamContext("context", this.getString("param-context"), Extract.FormatType.XML));
        Vector<Param.Item> uptoItems = new Vector<Param.Item>(6);
        uptoItems.add(new Param.Item("Today", "today"));
        uptoItems.add(new Param.Item("Tomorrow", "tomorrow"));
        uptoItems.add(new Param.Item("One Week", "one-week"));
        uptoItems.add(new Param.Item("Two Weeks", "two-weeks"));
        uptoItems.add(new Param.Item("Three Weeks", "three-weeks"));
        uptoItems.add(new Param.Item("Four Weeks", "four-weeks"));
        params.add((Param)new ParamList("upto", this.getString("param-upto"), uptoItems));
        params.add((Param)new ParamBoolean("include-done", this.getString("param-include-done")));
        params.add((Param)new ParamBoolean("striked-done", this.getString("param-striked-done")));
        params.add((Param)new ParamBoolean("include-inactive", this.getString("param-include-inactive")));
        params.add((Param)new ParamBoolean("show-project", this.getString("param-show-project-thought")));
        params.add((Param)new ParamBoolean("show-notes", this.getString("param-show-notes")));
        params.add((Param)new ParamBoolean("colour", this.getString("param-use-colour")));
        params.add((Param)new ParamFont("font", this.getString("param-font")));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = ReportImpl.getTmpFile((String)"data.xml");
        this.extractData(data, xmlfile, Extract.FormatType.XML);
        URL xslfoURL = ((Object)((Object)this)).getClass().getResource("actions-by-context.fo.xml");
        File outfile = ReportImpl.getOutFile((String)(this.getID() + "-" + ReportImpl.getTimeStamp() + ".pdf"));
        this.transformXSLFO(xmlfile, xslfoURL, params, outfile);
        ReportImpl.openFile((File)outfile);
    }
}

