/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BalloonManager {
    private static Balloon currentBalloon;
    private static JLayeredPane currentPane;
    private static ComponentListener listener;
    private static RequestProcessor.Task hideToolTipTask;

    public static synchronized void show(JComponent jComponent, JComponent jComponent2, Action action, int n) {
        assert (null != jComponent);
        assert (null != jComponent2);
        BalloonManager.dismiss();
        currentBalloon = new Balloon(jComponent2, action, n);
        currentPane = JLayeredPane.getLayeredPaneAbove(jComponent);
        listener = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }
        };
        currentPane.addComponentListener(listener);
        BalloonManager.configureBalloon(currentBalloon, currentPane, jComponent);
        currentPane.add((Component)currentBalloon, new Integer(JLayeredPane.POPUP_LAYER - 1));
    }

    public static synchronized void dismiss() {
        if (null != currentBalloon) {
            currentBalloon.setVisible(false);
            currentBalloon.stopDismissTimer();
            currentPane.remove(currentBalloon);
            currentPane.repaint();
            currentPane.removeComponentListener(listener);
            currentBalloon = null;
            currentPane = null;
            listener = null;
        }
    }

    private static void configureBalloon(Balloon balloon, JLayeredPane jLayeredPane, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        rectangle = SwingUtilities.convertRectangle(jComponent.getParent(), rectangle, jLayeredPane);
        int n = jLayeredPane.getWidth();
        int n2 = jLayeredPane.getHeight();
        Dimension dimension = balloon.getPreferredSize();
        dimension.height += 15;
        if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(14);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y - dimension.height - 15 > 0) {
            balloon.setArrowLocation(12);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x - dimension.width > 0 && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(16);
            balloon.setBounds(rectangle.x - dimension.width + 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else {
            balloon.setArrowLocation(18);
            balloon.setBounds(rectangle.x - dimension.width + 7, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        }
    }

    static {
        hideToolTipTask = null;
    }

    private static class Balloon
    extends JPanel {
        private static final int Y_OFFSET = 16;
        private static final int ARC = 15;
        private static final int SHADOW_SIZE = 10;
        private JComponent content;
        private Action defaultAction;
        private JButton btnDismiss;
        private int arrowLocation = 14;
        private float currentAlpha = 1.0f;
        private Timer dismissTimer;
        private int timeoutMillis;
        private static final float ALPHA_DECREMENT = 0.03f;
        private static final int DISMISS_REPAINT_REPEAT = 100;

        public Balloon(final JComponent jComponent, final Action action, int n) {
            super(new GridBagLayout());
            this.content = jComponent;
            this.defaultAction = action;
            this.timeoutMillis = n;
            jComponent.setOpaque(false);
            this.btnDismiss = new DismissButton();
            this.btnDismiss.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonManager.dismiss();
                }
            });
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.btnDismiss, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 4, 4), 0, 0));
            this.setOpaque(false);
            if (null != action) {
                jComponent.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        BalloonManager.dismiss();
                        action.actionPerformed(new ActionEvent(Balloon.this, 0, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        jComponent.setCursor(Cursor.getPredefinedCursor(12));
                        Balloon.this.stopDismissTimer();
                        Balloon.this.repaint();
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        jComponent.setCursor(Cursor.getDefaultCursor());
                        if (Balloon.this.timeoutMillis > 0) {
                            Balloon.this.startDismissTimer();
                        }
                    }
                });
            }
            this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
            if (n > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Balloon.this.startDismissTimer();
                    }
                });
            }
        }

        synchronized void startDismissTimer() {
            this.stopDismissTimer();
            this.currentAlpha = 1.0f;
            this.dismissTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Balloon.this.currentAlpha -= 0.03f;
                    if (Balloon.this.currentAlpha <= 0.03f) {
                        Balloon.this.stopDismissTimer();
                        BalloonManager.dismiss();
                    }
                    Balloon.this.repaint();
                }
            });
            this.dismissTimer.setInitialDelay(this.timeoutMillis);
            this.dismissTimer.start();
        }

        synchronized void stopDismissTimer() {
            if (null != this.dismissTimer) {
                this.dismissTimer.stop();
                this.dismissTimer = null;
                this.currentAlpha = 1.0f;
            }
        }

        void setArrowLocation(int n) {
            this.arrowLocation = n;
            if (n == 12 || n == 18) {
                this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 10));
            }
        }

        private Shape getMask(int n, int n2) {
            --n;
            n -= 10;
            GeneralPath generalPath = new GeneralPath();
            Area area = null;
            switch (this.arrowLocation) {
                case 14: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 16.0f, n, n2 - 16 - 10, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, 0.0f);
                    generalPath.lineTo(15.0f, 16.0f);
                    generalPath.lineTo(31.0f, 16.0f);
                    break;
                }
                case 12: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 10.0f, n, n2 - 16 - 10, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, n2 - 1);
                    generalPath.lineTo(15.0f, n2 - 1 - 16);
                    generalPath.lineTo(31.0f, n2 - 1 - 16);
                    break;
                }
                case 16: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 16.0f, n, n2 - 16 - 10, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, 0.0f);
                    generalPath.lineTo(n - 7 - 8, 16.0f);
                    generalPath.lineTo(n - 7 - 8 - 16, 16.0f);
                    break;
                }
                case 18: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 10.0f, n, n2 - 16 - 10, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, n2 - 1);
                    generalPath.lineTo(n - 7 - 8, n2 - 1 - 16);
                    generalPath.lineTo(n - 7 - 8 - 16, n2 - 1 - 16);
                }
            }
            generalPath.closePath();
            area.add(new Area(generalPath));
            return area;
        }

        private Shape getShadowMask(Shape shape) {
            Area area = new Area(shape);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(10.0, 10.0);
            area.transform(affineTransform);
            area.subtract(new Area(shape));
            return area;
        }

        protected void paintBorder(Graphics graphics) {
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite composite = graphics2D.getComposite();
            Shape shape = this.getMask(this.getWidth(), this.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f * this.currentAlpha));
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.getShadowMask(shape));
            graphics2D.setColor(UIManager.getColor("ToolTip.background"));
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            graphics2D.fill(shape);
            graphics2D.setColor(Color.black);
            graphics2D.draw(shape);
            graphics2D.setComposite(composite);
        }

        protected void paintChildren(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            super.paintChildren(graphics);
            graphics2D.setComposite(composite);
        }
    }

    private static class DismissButton
    extends JButton {
        public DismissButton() {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_enabled.png");
            this.setIcon(new ImageIcon(image));
            image = Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_rollover.png");
            this.setRolloverIcon(new ImageIcon(image));
            image = Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/dismiss_pressed.png");
            this.setPressedIcon(new ImageIcon(image));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
        }

        public void paint(Graphics graphics) {
            Icon icon = null;
            icon = this.getModel().isArmed() && this.getModel().isPressed() ? this.getPressedIcon() : (this.getModel().isRollover() ? this.getRolloverIcon() : this.getIcon());
            icon.paintIcon(this, graphics, 0, 0);
        }
    }
}

