/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.openide.util.NbBundle;
import tr.model.action.Interval;
import tr.model.action.Period;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.prefs.recurrence.RecurrencePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodYear
extends Period {
    public static final byte ID = 5;
    public static final String BUNDLE_KEY = "period.year";
    public static final String[] MONTHS_TEXT = new String[]{NbBundle.getMessage(PeriodYear.class, (String)"month.jan"), NbBundle.getMessage(PeriodYear.class, (String)"month.feb"), NbBundle.getMessage(PeriodYear.class, (String)"month.mar"), NbBundle.getMessage(PeriodYear.class, (String)"month.apr"), NbBundle.getMessage(PeriodYear.class, (String)"month.may"), NbBundle.getMessage(PeriodYear.class, (String)"month.jun"), NbBundle.getMessage(PeriodYear.class, (String)"month.jul"), NbBundle.getMessage(PeriodYear.class, (String)"month.aug"), NbBundle.getMessage(PeriodYear.class, (String)"month.sep"), NbBundle.getMessage(PeriodYear.class, (String)"month.oct"), NbBundle.getMessage(PeriodYear.class, (String)"month.nov"), NbBundle.getMessage(PeriodYear.class, (String)"month.dec")};
    private List<Integer> selectedMonths;
    private boolean onTheSelected;
    private PeriodMonth.OnTheNth onTheNth;
    private PeriodMonth.OnTheDay onTheDay;

    public PeriodYear() {
        this.selectedMonths = new Vector<Integer>();
        this.onTheSelected = false;
        this.onTheNth = PeriodMonth.OnTheNth.First;
        this.onTheDay = PeriodMonth.OnTheDay.Monday;
    }

    public PeriodYear(List<Integer> months) {
        this.selectedMonths = months;
        this.onTheSelected = false;
        this.onTheNth = PeriodMonth.OnTheNth.First;
        this.onTheDay = PeriodMonth.OnTheDay.Monday;
    }

    public PeriodYear(List<Integer> months, PeriodMonth.OnTheNth nth, PeriodMonth.OnTheDay day) {
        this.selectedMonths = months;
        this.onTheSelected = true;
        this.onTheNth = nth;
        this.onTheDay = day;
    }

    @Override
    public Period clone() {
        PeriodYear clone = new PeriodYear();
        clone.selectedMonths = new Vector<Integer>(this.selectedMonths);
        clone.onTheSelected = this.onTheSelected;
        clone.onTheNth = this.onTheNth;
        clone.onTheDay = this.onTheDay;
        return clone;
    }

    @Override
    public final byte getID() {
        return 5;
    }

    @Override
    public final String getBundleKey() {
        return BUNDLE_KEY;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + (this.selectedMonths != null ? ((Object)this.selectedMonths).hashCode() : 0);
        hash = 43 * hash + (this.onTheSelected ? 1 : 0);
        hash = 43 * hash + (this.onTheNth != null ? this.onTheNth.hashCode() : 0);
        hash = 43 * hash + (this.onTheDay != null ? this.onTheDay.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PeriodYear) {
            PeriodYear other = (PeriodYear)object;
            if (!((Object)this.selectedMonths).equals(other.selectedMonths)) {
                return false;
            }
            if (this.onTheSelected != other.onTheSelected) {
                return false;
            }
            if (this.onTheSelected) {
                return this.onTheNth == other.onTheNth && this.onTheDay == other.onTheDay;
            }
            return true;
        }
        return false;
    }

    public List<Integer> getSelectedMonths() {
        Collections.sort(this.selectedMonths);
        return new Vector<Integer>(this.selectedMonths);
    }

    public String getSelectedMonthsText() {
        if (this.selectedMonths.size() == 0) {
            return "Months ...";
        }
        Collections.sort(this.selectedMonths);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectedMonths.size(); ++i) {
            sb.append((i > 0 ? "," : "") + MONTHS_TEXT[this.selectedMonths.get(i)]);
        }
        return sb.toString();
    }

    public void setSelectedMonths(List<Integer> months) {
        this.selectedMonths.clear();
        if (months != null) {
            for (Integer month : months) {
                this.select(month);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Integer month) {
        PeriodYear periodYear = this;
        synchronized (periodYear) {
            return this.selectedMonths.contains(month);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Integer month) {
        PeriodYear periodYear = this;
        synchronized (periodYear) {
            if (!this.isSelected(month)) {
                this.selectedMonths.add(month);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselected(Integer month) {
        PeriodYear periodYear = this;
        synchronized (periodYear) {
            this.selectedMonths.remove(month);
        }
    }

    public boolean isOnTheSelected() {
        return this.onTheSelected;
    }

    public void setOnTheSelected(boolean b) {
        this.onTheSelected = b;
    }

    public PeriodMonth.OnTheNth getOnTheNth() {
        return this.onTheNth;
    }

    public void setOnTheNth(PeriodMonth.OnTheNth onTheNth) {
        this.onTheNth = onTheNth;
    }

    public PeriodMonth.OnTheDay getOnTheDay() {
        return this.onTheDay;
    }

    public void setOnTheDay(PeriodMonth.OnTheDay onTheDay) {
        this.onTheDay = onTheDay;
    }

    private Date calculateStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(1, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    private Date addYears(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        return calendar.getTime();
    }

    @Override
    public List<Date> getSelectedDates(Date startDate, Date templateDate) {
        assert (startDate != null);
        assert (templateDate != null);
        Vector<Date> dates = new Vector<Date>();
        Calendar templateCal = Calendar.getInstance();
        templateCal.setTime(templateDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        for (int month : this.selectedMonths) {
            cal.set(2, month);
            if (this.onTheSelected) {
                if (this.onTheNth == PeriodMonth.OnTheNth.Last) {
                    cal.set(7, this.onTheDay.dayOfWeek);
                    cal.set(8, -1);
                    cal.set(11, templateCal.get(11));
                    cal.set(12, templateCal.get(12));
                    cal.set(13, templateCal.get(13));
                    cal.set(14, templateCal.get(14));
                    dates.add(cal.getTime());
                    continue;
                }
                if (this.onTheNth == null) continue;
                cal.set(7, this.onTheDay.dayOfWeek);
                cal.set(8, this.onTheNth.n);
                cal.set(11, templateCal.get(11));
                cal.set(12, templateCal.get(12));
                cal.set(13, templateCal.get(13));
                cal.set(14, templateCal.get(14));
                dates.add(cal.getTime());
                continue;
            }
            cal.set(5, templateCal.get(5));
            cal.set(11, templateCal.get(11));
            cal.set(12, templateCal.get(12));
            cal.set(13, templateCal.get(13));
            cal.set(14, templateCal.get(14));
            dates.add(cal.getTime());
        }
        return dates;
    }

    @Override
    public void initialise(Date startDate) {
        this.selectedMonths = new Vector<Integer>();
        if (startDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            this.selectedMonths.add(calendar.get(2));
        }
        this.onTheSelected = false;
        this.onTheNth = PeriodMonth.OnTheNth.First;
        this.onTheDay = PeriodMonth.OnTheDay.Monday;
    }

    @Override
    public int getDefaultAdvanceNbr() {
        return RecurrencePrefs.getNbrFutureYear();
    }

    @Override
    public PeriodType getType() {
        return PeriodType.YEAR;
    }

    @Override
    public Interval getPeriod(Date date) {
        return new Interval(this.calculateStartDate(date), this.calculateEndDate(date));
    }

    @Override
    public Interval addPeriods(Interval interval, int n) {
        return this.getPeriod(this.addYears(interval.start, n));
    }
}

