/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.model.action.Recurrence;

public final class NewRecurrenceVisualPanel2
extends JPanel {
    private final Recurrence recurrence;
    private ButtonGroup buttonGroup;
    private JLabel jLabel2;
    private JTextArea regularHelp;
    private JRadioButton regularRadioButton;
    private JTextArea subsequentHelp;
    private JRadioButton subsequentRadioButton;

    public NewRecurrenceVisualPanel2(Recurrence recurrence) {
        this.recurrence = recurrence;
        this.initComponents();
        this.initPanel();
    }

    public String getName() {
        return "Choose Recurrence Type";
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.buttonGroup = new ButtonGroup();
        this.subsequentRadioButton = new JRadioButton();
        this.subsequentHelp = new JTextArea();
        this.regularRadioButton = new JRadioButton();
        this.regularHelp = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"jLabel2");
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(420, 240));
        this.buttonGroup.add(this.subsequentRadioButton);
        this.subsequentRadioButton.setFont(this.subsequentRadioButton.getFont().deriveFont(this.subsequentRadioButton.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((AbstractButton)this.subsequentRadioButton, (String)"Subsequent");
        this.subsequentRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel2.this.subsequentRadioButtonActionPerformed(evt);
            }
        });
        this.subsequentHelp.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.subsequentHelp.setEditable(false);
        this.subsequentHelp.setFont(this.subsequentHelp.getFont().deriveFont(this.subsequentHelp.getFont().getStyle() | 2));
        this.subsequentHelp.setLineWrap(true);
        this.subsequentHelp.setRows(5);
        this.subsequentHelp.setText("When the current action is done, a subsequent action is created with\nthe scheduled date set to the done date plus a specified time period.");
        this.subsequentHelp.setWrapStyleWord(true);
        this.subsequentHelp.setBorder(null);
        this.buttonGroup.add(this.regularRadioButton);
        this.regularRadioButton.setFont(this.regularRadioButton.getFont().deriveFont(this.regularRadioButton.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((AbstractButton)this.regularRadioButton, (String)"Regular");
        this.regularRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel2.this.regularRadioButtonActionPerformed(evt);
            }
        });
        this.regularHelp.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.regularHelp.setEditable(false);
        this.regularHelp.setFont(this.regularHelp.getFont().deriveFont(this.regularHelp.getFont().getStyle() | 2));
        this.regularHelp.setLineWrap(true);
        this.regularHelp.setRows(5);
        this.regularHelp.setText("Recurrent actions are created in advance for regular intervals with\nscheduled dates calculated from the start date using period settings.");
        this.regularHelp.setWrapStyleWord(true);
        this.regularHelp.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.regularHelp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
        this.regularHelp.setMinimumSize(new Dimension(100, 80));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.subsequentRadioButton, -2, 154, -2)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(40, 40, 40).add((Component)this.subsequentHelp)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.regularRadioButton, -2, 145, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add(40, 40, 40).add((Component)this.regularHelp, -2, 481, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.regularHelp, this.subsequentHelp}, 1);
        layout.linkSize(new Component[]{this.regularRadioButton, this.subsequentRadioButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(30, 30, 30).add((Component)this.regularRadioButton).addPreferredGap(0).add((Component)this.regularHelp, -2, 44, -2).addPreferredGap(0).add((Component)this.subsequentRadioButton).addPreferredGap(0).add((Component)this.subsequentHelp, -2, 41, -2).addContainerGap(70, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.regularHelp, this.subsequentHelp}, 2);
        layout.linkSize(new Component[]{this.regularRadioButton, this.subsequentRadioButton}, 2);
    }

    private void subsequentRadioButtonActionPerformed(ActionEvent evt) {
        this.setValues();
    }

    private void regularRadioButtonActionPerformed(ActionEvent evt) {
        this.setValues();
    }

    private void setValues() {
        if (this.subsequentRadioButton.isSelected()) {
            this.recurrence.setBasis(Recurrence.Basis.DONE_DATE);
            this.putClientProperty("type", "subsequent");
        } else {
            this.recurrence.setBasis(Recurrence.Basis.START_DATE);
            this.putClientProperty("type", "regular");
        }
    }

    public void initPanel() {
        this.regularRadioButton.setSelected(this.recurrence.getBasis() == Recurrence.Basis.START_DATE);
        this.subsequentRadioButton.setSelected(this.recurrence.getBasis() == Recurrence.Basis.DONE_DATE);
        this.setValues();
    }
}

