/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ActionPrefs {
    private static final Logger LOG = Logger.getLogger("tr.view.action.prefs");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/action");
    private static final String KEY_NOTE_DELEGATE_EMAIL = "note.delegate.email";
    private static final boolean DEF_NOTE_DELEGATE_EMAIL = true;
    private static final String KEY_SHOW_DUE = "show.due";
    private static final boolean DEF_SHOW_DUE = false;
    private static final String KEY_SHOW_START = "show.start";
    private static final boolean DEF_SHOW_START = false;
    private static final String KEY_SHOW_SUCCESS = "show.success";
    private static final boolean DEF_SHOW_SUCCESS = true;
    private static final String KEY_EDIT_CREATE_DATE = "edit.create-date";
    private static final boolean DEF_EDIT_CREATE_DATE = false;

    public static final boolean isNoteDelegateEmail() {
        return prefs.getBoolean(KEY_NOTE_DELEGATE_EMAIL, true);
    }

    public static final void setNoteDelegateEmail(boolean value) {
        prefs.putBoolean(KEY_NOTE_DELEGATE_EMAIL, value);
        ActionPrefs.flush();
    }

    public static final boolean isShowDueDate() {
        return prefs.getBoolean(KEY_SHOW_DUE, false);
    }

    public static final void setShowDueDate(boolean value) {
        prefs.putBoolean(KEY_SHOW_DUE, value);
        ActionPrefs.flush();
    }

    public static final boolean isShowStartDate() {
        return prefs.getBoolean(KEY_SHOW_START, false);
    }

    public static final void setShowStartDate(boolean value) {
        prefs.putBoolean(KEY_SHOW_START, value);
        ActionPrefs.flush();
    }

    public static final boolean isShowSuccess() {
        return prefs.getBoolean(KEY_SHOW_SUCCESS, true);
    }

    public static final void setShowSuccess(boolean value) {
        prefs.putBoolean(KEY_SHOW_SUCCESS, value);
        ActionPrefs.flush();
    }

    public static final boolean isEditCreateDate() {
        return prefs.getBoolean(KEY_EDIT_CREATE_DATE, false);
    }

    public static final void setEditCreateDate(boolean value) {
        prefs.putBoolean(KEY_EDIT_CREATE_DATE, value);
        ActionPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Delegation preferences error. " + ex.getMessage());
        }
    }
}

