/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.appl.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.thought.Thought;
import tr.runtime.Email;
import tr.runtime.Open;
import tr.swing.date.field.DateField;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.action.StatusComboBoxModel;
import tr.view.action.StatusEnum;
import tr.view.action.prefs.ActionPrefs;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;
import tr.view.criteria.CriterionComboBoxModel;

public class PanelAction
extends JPanel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private DocumentListener descriptionDocListener;
    private FocusAdapter descriptionFocusAdapter;
    private ActionListener contextActionListener;
    private ActionListener statusComboActionListener;
    private ActionListener priorityComboActionListener;
    private ActionListener energyComboActionListener;
    private ActionListener timeComboActionListener;
    private ChangeListener scheduledHourChangeListener;
    private ChangeListener scheduledMinuteChangeListener;
    private ChangeListener scheduledDurationHourChangeListener;
    private ChangeListener scheduledDurationMinuteChangeListener;
    private DocumentListener delegatedToDocListener;
    private ActionListener delegatedEmailActionListener;
    private DocumentListener notesDocListener;
    private ActionListener doneCheckBoxActionListener;
    private HyperlinkListener notesHyperlinkListener;
    private Observer observerCriterion;
    private PropertyChangeListener scheduledDatePropertyChangeListener;
    private PropertyChangeListener followupDatePropertyChangeListener;
    private PropertyChangeListener startDatePropertyChangeListener;
    private PropertyChangeListener dueDatePropertyChangeListener;
    private PropertyChangeListener createdDatePropertyChangeListener;
    private PropertyChangeListener doneDatePropertyChangeListener;
    private JLabel contextLabel;
    private JComboBox contextsCombo;
    private DateField createdDateField;
    private JLabel createdDateLabel;
    private JPanel criterionPanel;
    private JPanel delegatedPanel;
    private JLabel delegatedToLabel;
    private JTextField delegatedToText;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private JCheckBox doneCheckBox;
    private DateField doneDateField;
    private DateField dueDateField;
    private JLabel dueDateLabel;
    private HourSpinner durationHourSpinner;
    private JLabel durationLabel;
    private MinuteSpinner durationMinuteSpinner;
    private JButton emailButton;
    private JComboBox energyCombo;
    private JLabel energyLabel;
    private DateField followupDateField;
    private JLabel followupLabel;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JButton recurrenceButton;
    private JLabel recurrenceLabel;
    private DateField scheduledDateField;
    private HourSpinner scheduledHourSpinner;
    private JLabel scheduledLabel;
    private MinuteSpinner scheduledMinuteSpinner;
    private JPanel scheduledPanel;
    private DateField startDateField;
    private JLabel startDateLabel;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JComboBox timeCombo;
    private JLabel timeLabel;
    private Data data = (Data)DataLookup.instance().lookup(Data.class);
    private Action action;
    private ActionStateInactive stateInactive;
    private ActionStateASAP stateASAP;
    private ActionStateDelegated stateDelegated;
    private ActionStateScheduled stateScheduled;
    private ComboBoxModel contextsModel;
    private boolean updating;

    public PanelAction() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    public void initModel(Action action) {
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        if (this.action != null) {
            this.action.removeObserver((Observer)this);
        }
        this.action = action;
        this.stateInactive = null;
        this.stateASAP = null;
        this.stateScheduled = null;
        this.stateDelegated = null;
        this.storeActionState();
        if (this.action != null) {
            this.action.addObserver((Observer)this);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.action == null) {
            this.descriptionText.setText("");
            this.createdDateField.setDate(null);
            this.startDateField.setDate(null);
            this.dueDateField.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.contextsCombo.setSelectedItem(null);
            this.statusCombo.setSelectedItem(null);
            this.followupDateField.setDate(null);
            this.scheduledDateField.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.timeCombo.setSelectedItem(null);
            this.energyCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.notesEditorPane.setText("");
            this.setEnabled(false);
        } else {
            ActionStateASAP state;
            this.descriptionText.setText(this.action.getDescription());
            Thought thought = this.action.getThought();
            this.contextsCombo.setSelectedItem(this.action.getContext());
            this.statusCombo.setSelectedItem(null);
            if (this.action.isStateInactive()) {
                this.statusCombo.setSelectedItem(StatusEnum.INACTIVE);
            } else if (this.action.isStateASAP()) {
                this.statusCombo.setSelectedItem(StatusEnum.DO_ASAP);
                state = (ActionStateASAP)this.action.getState();
            }
            if (this.action.isStateDelegated()) {
                this.statusCombo.setSelectedItem(StatusEnum.DELEGATED);
                state = (ActionStateDelegated)this.action.getState();
                this.delegatedToText.setText(state.getTo());
                this.followupDateField.setDate(state.getDate());
            } else {
                this.delegatedToText.setText("");
                this.followupDateField.setDate(null);
            }
            if (this.action.isStateScheduled()) {
                this.statusCombo.setSelectedItem(StatusEnum.SCHEDULED);
                state = (ActionStateScheduled)this.action.getState();
                this.scheduledDateField.setDate(state.getDate());
                if (state.getDate() == null) {
                    this.scheduledHourSpinner.setValue((Object)new Integer(0));
                    this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                    this.durationHourSpinner.setValue((Object)new Integer(0));
                    this.durationMinuteSpinner.setValue((Object)new Integer(0));
                } else {
                    Calendar c = Calendar.getInstance();
                    c.setTime(state.getDate());
                    this.scheduledHourSpinner.setVal(c.get(11));
                    this.scheduledMinuteSpinner.setVal(c.get(12));
                    this.durationHourSpinner.setVal(state.getDurationHours());
                    this.durationMinuteSpinner.setVal(state.getDurationMinutes());
                }
            } else {
                this.scheduledDateField.setDate(null);
                this.scheduledHourSpinner.setValue((Object)new Integer(0));
                this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                this.durationHourSpinner.setValue((Object)new Integer(0));
                this.durationMinuteSpinner.setValue((Object)new Integer(0));
            }
            this.timeCombo.setSelectedItem(this.action.getTime());
            this.energyCombo.setSelectedItem(this.action.getEnergy());
            this.priorityCombo.setSelectedItem(this.action.getPriority());
            this.notesEditorPane.setText(this.action.getNotes());
            this.createdDateField.setDate(this.action.getCreated());
            this.startDateField.setDate(this.action.getStartDate());
            this.dueDateField.setDate(this.action.getDueDate());
            this.doneCheckBox.setSelected(this.action.isDone());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.contextsCombo.setEnabled(enabled);
        this.contextLabel.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.statusCombo.setEnabled(enabled);
        this.delegatedPanel.setVisible(enabled && this.action.isStateDelegated());
        this.delegatedPanel.setEnabled(enabled);
        this.delegatedToLabel.setEnabled(enabled);
        this.delegatedToText.setEnabled(enabled);
        this.emailButton.setEnabled(enabled);
        this.followupDateField.setEnabled(enabled);
        this.followupLabel.setEnabled(enabled);
        this.scheduledLabel.setEnabled(enabled);
        this.scheduledDateField.setEnabled(enabled);
        this.scheduledHourSpinner.setEnabled(enabled);
        this.scheduledMinuteSpinner.setEnabled(enabled);
        this.durationLabel.setEnabled(enabled);
        this.durationHourSpinner.setEnabled(enabled);
        this.durationMinuteSpinner.setEnabled(enabled);
        this.scheduledPanel.setEnabled(enabled);
        this.scheduledPanel.setVisible(enabled && this.action.isStateScheduled());
        if (this.scheduledPanel.isVisible()) {
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
            this.recurrenceLabel.setVisible(false);
            this.recurrenceButton.setVisible(false);
            ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
            if (state.getRecurrence() == null) {
                this.recurrenceButton.setText(PanelAction.getText("recurrence.create"));
            } else {
                this.recurrenceButton.setText(PanelAction.getText("recurrence.modify"));
            }
            this.startDateLabel.setVisible(false);
            this.startDateField.setVisible(false);
            this.dueDateLabel.setVisible(false);
            this.dueDateField.setVisible(false);
        } else {
            this.startDateLabel.setVisible(ActionPrefs.isShowStartDate());
            this.startDateField.setVisible(ActionPrefs.isShowStartDate());
            this.dueDateLabel.setVisible(ActionPrefs.isShowDueDate());
            this.dueDateField.setVisible(ActionPrefs.isShowDueDate());
        }
        this.timeLabel.setEnabled(enabled);
        this.timeCombo.setEnabled(enabled);
        this.energyLabel.setEnabled(enabled);
        this.energyCombo.setEnabled(enabled);
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateField.setEnabled(enabled && ActionPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateField.setEnabled(enabled);
        this.doneCheckBox.setEnabled(enabled);
        this.doneDateField.setEnabled(enabled && this.action.canSetDone(true));
        this.showHideCriteria();
    }

    private void showHideCriteria() {
        this.criterionPanel.setVisible(this.data.getTimeCriterion().use || this.data.getEnergyCriterion().use || this.data.getPriorityCriterion().use);
        if (this.criterionPanel.isVisible()) {
            this.timeLabel.setEnabled(this.data.getTimeCriterion().use);
            this.timeCombo.setEnabled(this.data.getTimeCriterion().use);
            this.energyLabel.setEnabled(this.data.getEnergyCriterion().use);
            this.energyCombo.setEnabled(this.data.getEnergyCriterion().use);
            this.priorityLabel.setEnabled(this.data.getPriorityCriterion().use);
            this.priorityCombo.setEnabled(this.data.getPriorityCriterion().use);
        }
    }

    public void focus() {
        this.descriptionText.requestFocusInWindow();
    }

    public void refresh() {
        this.setEnabled(this.action != null);
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.contextLabel = new JLabel();
        this.contextsModel = new ContextsComboBoxModel(false);
        this.contextsCombo = new ContextsComboBox(this.contextsModel);
        this.statusLabel = new JLabel();
        this.scheduledPanel = new JPanel();
        this.scheduledLabel = new JLabel();
        this.scheduledHourSpinner = new HourSpinner();
        this.scheduledMinuteSpinner = new MinuteSpinner();
        this.durationLabel = new JLabel();
        this.durationHourSpinner = new HourSpinner();
        this.durationMinuteSpinner = new MinuteSpinner();
        this.recurrenceLabel = new JLabel();
        this.recurrenceButton = new JButton();
        this.scheduledDateField = new DateField();
        this.delegatedPanel = new JPanel();
        this.delegatedToLabel = new JLabel();
        this.delegatedToText = new JTextField();
        this.emailButton = new JButton();
        this.followupLabel = new JLabel();
        this.followupDateField = new DateField();
        this.notesLabel = new JLabel();
        this.createdDateLabel = new JLabel();
        this.doneCheckBox = new JCheckBox();
        this.statusCombo = new JComboBox();
        this.criterionPanel = new JPanel();
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.energyLabel = new JLabel();
        this.energyCombo = new JComboBox();
        this.timeLabel = new JLabel();
        this.timeCombo = new JComboBox();
        this.startDateLabel = new JLabel();
        this.dueDateLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.createdDateField = new DateField();
        this.startDateField = new DateField();
        this.dueDateField = new DateField();
        this.doneDateField = new DateField();
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.description"));
        this.descriptionLabel.setMaximumSize(new Dimension(94, 23));
        this.descriptionLabel.setMinimumSize(new Dimension(94, 23));
        this.descriptionLabel.setPreferredSize(new Dimension(94, 23));
        this.descriptionText.setBorder(BorderFactory.createEtchedBorder());
        this.descriptionText.setMinimumSize(new Dimension(14, 22));
        this.descriptionText.setPreferredSize(new Dimension(14, 22));
        this.contextLabel.setHorizontalAlignment(11);
        this.contextLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.context"));
        this.contextLabel.setMaximumSize(new Dimension(94, 23));
        this.contextLabel.setMinimumSize(new Dimension(94, 23));
        this.contextLabel.setPreferredSize(new Dimension(94, 23));
        this.contextsCombo.setMaximumRowCount(30);
        this.statusLabel.setHorizontalAlignment(11);
        this.statusLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.status"));
        this.statusLabel.setMaximumSize(new Dimension(94, 23));
        this.statusLabel.setMinimumSize(new Dimension(94, 23));
        this.statusLabel.setPreferredSize(new Dimension(94, 23));
        this.scheduledPanel.setMaximumSize(new Dimension(720, 28));
        this.scheduledPanel.setMinimumSize(new Dimension(720, 28));
        this.scheduledPanel.setPreferredSize(new Dimension(720, 28));
        this.scheduledLabel.setHorizontalAlignment(11);
        this.scheduledLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.scheduledFor"));
        this.scheduledLabel.setMaximumSize(new Dimension(94, 23));
        this.scheduledLabel.setMinimumSize(new Dimension(94, 23));
        this.scheduledLabel.setPreferredSize(new Dimension(94, 23));
        this.scheduledHourSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationLabel.setHorizontalAlignment(11);
        this.durationLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.duration"));
        this.durationLabel.setMaximumSize(new Dimension(55, 23));
        this.durationLabel.setMinimumSize(new Dimension(55, 23));
        this.durationLabel.setPreferredSize(new Dimension(55, 23));
        this.durationHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.recurrenceLabel.setHorizontalAlignment(11);
        this.recurrenceLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.recurrence"));
        this.recurrenceLabel.setPreferredSize(new Dimension(69, 23));
        this.recurrenceButton.setMaximumSize(new Dimension(75, 26));
        this.recurrenceButton.setMinimumSize(new Dimension(75, 26));
        this.recurrenceButton.setPreferredSize(new Dimension(75, 26));
        this.scheduledDateField.setMaximumSize(new Dimension(110, 23));
        this.scheduledDateField.setMinimumSize(new Dimension(110, 23));
        this.scheduledDateField.setPreferredSize(new Dimension(110, 23));
        GroupLayout scheduledPanelLayout = new GroupLayout((Container)this.scheduledPanel);
        this.scheduledPanel.setLayout((LayoutManager)scheduledPanelLayout);
        scheduledPanelLayout.setHorizontalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add((Component)this.scheduledLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.scheduledDateField, -2, -1, -2).add(2, 2, 2).add((Component)this.scheduledHourSpinner, -2, -1, -2).add(0, 0, 0).add((Component)this.scheduledMinuteSpinner, -2, -1, -2).add(20, 20, 20).add((Component)this.durationLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.durationHourSpinner, -2, -1, -2).add(1, 1, 1).add((Component)this.durationMinuteSpinner, -2, -1, -2).add(20, 20, 20).add((Component)this.recurrenceLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.recurrenceButton, -2, -1, -2).add(63, 63, 63)));
        scheduledPanelLayout.setVerticalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.recurrenceLabel, -2, -1, -2)).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.durationMinuteSpinner, -2, -1, -2)).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.durationHourSpinner, -2, -1, -2)).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add(2, (Component)this.scheduledLabel, -2, -1, -2).add(2, (Component)this.scheduledHourSpinner, -2, -1, -2).add(2, (Component)this.scheduledMinuteSpinner, -2, -1, -2).add(2, (Component)this.scheduledDateField, -2, -1, -2)).add((Component)this.durationLabel, -2, -1, -2))).add((Component)this.recurrenceButton, -2, -1, -2)).addContainerGap()));
        scheduledPanelLayout.linkSize(new Component[]{this.durationHourSpinner, this.durationLabel, this.durationMinuteSpinner, this.scheduledDateField, this.scheduledHourSpinner, this.scheduledLabel, this.scheduledMinuteSpinner}, 2);
        this.delegatedPanel.setMaximumSize(new Dimension(720, 28));
        this.delegatedPanel.setMinimumSize(new Dimension(720, 28));
        this.delegatedPanel.setPreferredSize(new Dimension(720, 28));
        this.delegatedToLabel.setHorizontalAlignment(11);
        this.delegatedToLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.delegatedTo"));
        this.delegatedToLabel.setMaximumSize(new Dimension(94, 23));
        this.delegatedToLabel.setMinimumSize(new Dimension(94, 23));
        this.delegatedToLabel.setPreferredSize(new Dimension(94, 23));
        this.delegatedToText.setMaximumSize(new Dimension(210, 23));
        this.delegatedToText.setMinimumSize(new Dimension(210, 23));
        this.delegatedToText.setPreferredSize(new Dimension(210, 23));
        this.emailButton.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.email"));
        this.emailButton.setMaximumSize(new Dimension(75, 26));
        this.emailButton.setMinimumSize(new Dimension(75, 26));
        this.emailButton.setPreferredSize(new Dimension(75, 26));
        this.followupLabel.setHorizontalAlignment(11);
        this.followupLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.followUp"));
        this.followupLabel.setMaximumSize(new Dimension(65, 23));
        this.followupLabel.setMinimumSize(new Dimension(65, 23));
        this.followupLabel.setPreferredSize(new Dimension(65, 23));
        this.followupDateField.setMaximumSize(new Dimension(120, 23));
        this.followupDateField.setMinimumSize(new Dimension(120, 23));
        this.followupDateField.setPreferredSize(new Dimension(120, 23));
        GroupLayout delegatedPanelLayout = new GroupLayout((Container)this.delegatedPanel);
        this.delegatedPanel.setLayout((LayoutManager)delegatedPanelLayout);
        delegatedPanelLayout.setHorizontalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createSequentialGroup().add((Component)this.delegatedToLabel, -2, -1, -2).add(8, 8, 8).add((Component)this.delegatedToText, -2, -1, -2).addPreferredGap(0).add((Component)this.emailButton, -2, -1, -2).addPreferredGap(0).add((Component)this.followupLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.followupDateField, -2, -1, -2).addContainerGap(122, Short.MAX_VALUE)));
        delegatedPanelLayout.setVerticalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((Component)this.followupLabel, -2, -1, -2).add((Component)this.followupDateField, -2, -1, -2).add((Component)this.delegatedToLabel, -2, -1, -2).add((Component)this.delegatedToText, -2, -1, -2).add((Component)this.emailButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.notes"));
        this.notesLabel.setMaximumSize(new Dimension(94, 23));
        this.notesLabel.setMinimumSize(new Dimension(94, 23));
        this.notesLabel.setPreferredSize(new Dimension(94, 23));
        this.createdDateLabel.setHorizontalAlignment(11);
        this.createdDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.created"));
        this.createdDateLabel.setMaximumSize(new Dimension(94, 23));
        this.createdDateLabel.setMinimumSize(new Dimension(94, 23));
        this.createdDateLabel.setPreferredSize(new Dimension(94, 23));
        this.doneCheckBox.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.done"));
        this.doneCheckBox.setHorizontalAlignment(11);
        this.doneCheckBox.setHorizontalTextPosition(10);
        this.doneCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.doneCheckBox.setMaximumSize(new Dimension(60, 23));
        this.doneCheckBox.setMinimumSize(new Dimension(60, 23));
        this.doneCheckBox.setPreferredSize(new Dimension(60, 23));
        this.statusCombo.setModel(new StatusComboBoxModel());
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.priority"));
        this.priorityLabel.setFocusable(false);
        this.priorityLabel.setPreferredSize(new Dimension(96, 16));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.energyLabel.setHorizontalAlignment(11);
        this.energyLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.energy"));
        this.energyLabel.setFocusable(false);
        this.energyLabel.setPreferredSize(new Dimension(96, 16));
        this.energyCombo.setModel(this.getEnergyComboBoxModel());
        this.timeLabel.setHorizontalAlignment(11);
        this.timeLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.time"));
        this.timeLabel.setFocusable(false);
        this.timeLabel.setMaximumSize(new Dimension(94, 23));
        this.timeLabel.setMinimumSize(new Dimension(94, 23));
        this.timeLabel.setPreferredSize(new Dimension(94, 23));
        this.timeCombo.setModel(this.getTimeComboBoxModel());
        GroupLayout criterionPanelLayout = new GroupLayout((Container)this.criterionPanel);
        this.criterionPanel.setLayout((LayoutManager)criterionPanelLayout);
        criterionPanelLayout.setHorizontalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)criterionPanelLayout.createSequentialGroup().add((Component)this.timeLabel, -2, -1, -2).addPreferredGap(1).add((Component)this.timeCombo, -2, 150, -2).addPreferredGap(0).add((Component)this.energyLabel, -2, 54, -2).addPreferredGap(0).add((Component)this.energyCombo, -2, 150, -2).addPreferredGap(0).add((Component)this.priorityLabel, -2, 62, -2).addPreferredGap(0).add((Component)this.priorityCombo, 0, 143, Short.MAX_VALUE).addContainerGap()));
        criterionPanelLayout.linkSize(new Component[]{this.energyCombo, this.timeCombo}, 1);
        criterionPanelLayout.setVerticalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)criterionPanelLayout.createParallelGroup(3).add((Component)this.timeCombo, -2, -1, -2).add((Component)this.timeLabel, -2, -1, -2).add((Component)this.energyLabel, -2, 24, -2).add((Component)this.energyCombo, -2, -1, -2).add((Component)this.priorityLabel, -2, 24, -2).add((Component)this.priorityCombo, -2, -1, -2)));
        this.startDateLabel.setHorizontalAlignment(11);
        this.startDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.startDateLabel.text"));
        this.startDateLabel.setMaximumSize(new Dimension(35, 23));
        this.startDateLabel.setMinimumSize(new Dimension(35, 23));
        this.startDateLabel.setPreferredSize(new Dimension(35, 23));
        this.dueDateLabel.setHorizontalAlignment(11);
        this.dueDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.dueDateLabel.text"));
        this.dueDateLabel.setMaximumSize(new Dimension(30, 23));
        this.dueDateLabel.setMinimumSize(new Dimension(30, 23));
        this.dueDateLabel.setPreferredSize(new Dimension(30, 23));
        this.createdDateField.setMinimumSize(new Dimension(32, 23));
        this.createdDateField.setPreferredSize(new Dimension(120, 23));
        this.startDateField.setMinimumSize(new Dimension(32, 23));
        this.startDateField.setPreferredSize(new Dimension(120, 23));
        this.dueDateField.setMinimumSize(new Dimension(32, 23));
        this.dueDateField.setPreferredSize(new Dimension(120, 23));
        this.doneDateField.setMinimumSize(new Dimension(32, 23));
        this.doneDateField.setPreferredSize(new Dimension(120, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE).add((Component)this.contextLabel, -1, -1, Short.MAX_VALUE).add((Component)this.descriptionLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.notesEditorPane, -1, 640, Short.MAX_VALUE).add((Component)this.descriptionText, -1, 640, Short.MAX_VALUE).add((Component)this.contextsCombo, -2, 250, -2).add((Component)this.statusCombo, -2, 150, -2))).add((Component)this.delegatedPanel, -2, -1, -2).add((Component)this.criterionPanel, -2, -1, -2).add((Component)this.scheduledPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.notesLabel, 0, 0, Short.MAX_VALUE).add((Component)this.createdDateLabel, -2, -1, -2)).addPreferredGap(0).add((Component)this.createdDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.startDateLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.startDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.dueDateLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.dueDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.doneCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.doneDateField, -2, -1, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.createdDateLabel, this.notesLabel}, 1);
        layout.linkSize(new Component[]{this.contextLabel, this.descriptionLabel, this.statusLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel, -2, -1, -2).add((Component)this.descriptionText, -1, 23, Short.MAX_VALUE)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.contextLabel, -2, -1, -2).add((Component)this.contextsCombo, -2, -1, -2)).add(3, 3, 3).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.statusLabel, -2, -1, -2).add((Component)this.statusCombo, -2, -1, -2)).add(3, 3, 3).add((Component)this.scheduledPanel, -2, -1, -2).add(0, 0, 0).add((Component)this.delegatedPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.criterionPanel, -2, -1, -2).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.notesEditorPane, -1, 52, Short.MAX_VALUE).add((Component)this.notesLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdDateLabel, -2, -1, -2).add((Component)this.startDateLabel, -2, -1, -2).add((Component)this.dueDateLabel, -2, -1, -2).add((Component)this.doneCheckBox, -2, -1, -2)).add((Component)this.startDateField, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.doneDateField, -2, -1, -2).add((Component)this.dueDateField, -2, -1, -2))).add((Component)this.createdDateField, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.contextLabel, this.contextsCombo, this.descriptionLabel, this.statusCombo, this.statusLabel}, 2);
        layout.linkSize(new Component[]{this.createdDateLabel, this.notesLabel}, 2);
    }

    private void addToNotes(String text) {
        String notes = this.notesEditorPane.getText().trim();
        if (notes.contains(text)) {
            return;
        }
        if (notes.length() == 0) {
            this.notesEditorPane.setText(text);
        } else {
            this.notesEditorPane.setText(notes + "\n" + text);
        }
    }

    private void storeActionState() {
        if (this.action == null) {
            return;
        }
        if (this.action.isStateInactive()) {
            this.stateInactive = (ActionStateInactive)this.action.getState();
        } else if (this.action.isStateASAP()) {
            this.stateASAP = (ActionStateASAP)this.action.getState();
        } else if (this.action.isStateScheduled()) {
            this.stateScheduled = (ActionStateScheduled)this.action.getState();
        } else if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void durationMinutesStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationMinuteSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationMins(this.durationMinuteSpinner.getVal());
        }
    }

    private void durationHoursStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationHourSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationHours(this.durationHourSpinner.getVal());
        }
    }

    private void changedScheduledDate() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        this.stateScheduled.setDate(this.scheduledDateField.getDate());
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
        } else {
            this.scheduledHourSpinner.setEnabled(true);
            this.scheduledMinuteSpinner.setEnabled(true);
            this.durationHourSpinner.setEnabled(true);
            this.durationMinuteSpinner.setEnabled(true);
            this.durationLabel.setEnabled(true);
        }
    }

    private void changedScheduledHour() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(11, this.scheduledHourSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedScheduledMinute() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledMinuteSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(12, this.scheduledMinuteSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedFollowupDate() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setDate(this.followupDateField.getDate());
        }
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void timeComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setTime((Value)this.timeCombo.getSelectedItem());
    }

    private void energyComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
    }

    private void statusComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        StatusEnum status = (StatusEnum)this.statusCombo.getSelectedItem();
        switch (status) {
            case INACTIVE: {
                this.action.setState((ActionState)this.getStateInactive());
                break;
            }
            case DO_ASAP: {
                this.action.setState((ActionState)this.getStateASAP());
                break;
            }
            case SCHEDULED: {
                this.action.setState((ActionState)this.getStateScheduled());
                break;
            }
            case DELEGATED: {
                this.action.setState((ActionState)this.getStateDelegated());
            }
        }
        this.setEnabled(true);
    }

    private void emailActionPerformed(ActionEvent evt) {
        String to = this.delegatedToText.getText();
        if (Utilities.getOperatingSystem() == 16 && to.indexOf("@") == -1) {
            JOptionPane.showMessageDialog(null, PanelAction.getText("ERR_EmailRequired"), "", 1);
            return;
        }
        String subject = this.descriptionText.getText();
        String body = this.notesEditorPane.getText();
        Email.email((String)to, (String)subject, (String)body);
        Date today = Calendar.getInstance().getTime();
        if (ActionPrefs.isNoteDelegateEmail()) {
            this.addToNotes(PanelAction.getText("MSG_EmailSent") + " " + Constants.DATE_FORMAT_FIXED.format(today));
        }
    }

    private void changedDoneDate() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDoneDate(this.doneDateField.getDate());
        this.doneCheckBox.setSelected(this.action.getDoneDate() != null);
    }

    private void doneCheckBoxChanged() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.canSetDone(this.doneCheckBox.isSelected())) {
            this.action.setDone(this.doneCheckBox.isSelected());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.doneDateField.setEnabled(this.action.canSetDone(true));
        }
    }

    private void changedCreatedDate() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setCreated(this.createdDateField.getDate());
    }

    private void changedStartDate() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setStartDate(this.startDateField.getDate());
    }

    private void changedDueDate() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDueDate(this.dueDateField.getDate());
    }

    private void contextsComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.action.setContext((Context)combo.getSelectedItem());
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        this.descriptionText.selectAll();
    }

    private ActionStateInactive getStateInactive() {
        if (this.stateInactive == null) {
            this.stateInactive = this.action.isStateInactive() ? (ActionStateInactive)this.action.getState() : new ActionStateInactive();
        }
        return this.stateInactive;
    }

    private ActionStateASAP getStateASAP() {
        if (this.stateASAP == null) {
            this.stateASAP = this.action.isStateASAP() ? (ActionStateASAP)this.action.getState() : new ActionStateASAP();
        }
        return this.stateASAP;
    }

    private ActionStateDelegated getStateDelegated() {
        if (this.stateDelegated == null) {
            this.stateDelegated = this.action.isStateDelegated() ? (ActionStateDelegated)this.action.getState() : new ActionStateDelegated();
        }
        return this.stateDelegated;
    }

    private ActionStateScheduled getStateScheduled() {
        if (this.stateScheduled == null) {
            this.stateScheduled = this.action.isStateScheduled() ? (ActionStateScheduled)this.action.getState() : new ActionStateScheduled();
        }
        return this.stateScheduled;
    }

    private void changedDescription() {
        LOG.fine("Start");
        if (this.updating || this.action == null) {
            return;
        }
        LOG.fine("Changing");
        this.action.setDescription(this.descriptionText.getText());
    }

    private void changedDelegatedTo() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setTo(this.delegatedToText.getText());
        }
    }

    private void changedNotes() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setNotes(this.notesEditorPane.getText());
    }

    private static String getText(String key) {
        return NbBundle.getMessage(PanelAction.class, (String)key);
    }

    private ComboBoxModel getTimeComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getTimeCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getEnergyCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getPriorityCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    public void update(Observable observable, Object arg) {
        if (this.action == null) {
            return;
        }
        if (!this.descriptionText.getText().equals(this.action.getDescription())) {
            this.descriptionText.setText(this.action.getDescription());
        }
        if (!Utils.equal((Object)this.action.getContext(), (Object)this.contextsCombo.getSelectedItem())) {
            this.contextsCombo.setSelectedItem(this.action.getContext());
        }
    }

    private void addListeners() {
        this.descriptionDocListener = new LazyDocumentListener(){

            public void update() {
                PanelAction.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.descriptionDocListener);
        this.descriptionFocusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PanelAction.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener(this.descriptionFocusAdapter);
        this.notesDocListener = new LazyDocumentListener(){

            public void update() {
                PanelAction.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.notesDocListener);
        this.notesHyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                PanelAction.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.notesHyperlinkListener);
        this.contextActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.contextsComboActionPerformed(evt);
            }
        };
        this.contextsCombo.addActionListener(this.contextActionListener);
        this.scheduledDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedScheduledDate();
            }
        };
        this.scheduledDateField.addPropertyChangeListener("value", this.scheduledDatePropertyChangeListener);
        this.scheduledHourChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.changedScheduledHour();
            }
        };
        this.scheduledHourSpinner.addChangeListener(this.scheduledHourChangeListener);
        this.scheduledMinuteChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.changedScheduledMinute();
            }
        };
        this.scheduledMinuteSpinner.addChangeListener(this.scheduledMinuteChangeListener);
        this.scheduledDurationHourChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.durationHoursStateChanged(evt);
            }
        };
        this.durationHourSpinner.addChangeListener(this.scheduledDurationHourChangeListener);
        this.scheduledDurationMinuteChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.durationMinutesStateChanged(evt);
            }
        };
        this.durationMinuteSpinner.addChangeListener(this.scheduledDurationMinuteChangeListener);
        this.delegatedToDocListener = new LazyDocumentListener(){

            public void update() {
                PanelAction.this.changedDelegatedTo();
            }
        };
        this.delegatedToText.getDocument().addDocumentListener(this.delegatedToDocListener);
        this.delegatedEmailActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.emailActionPerformed(evt);
            }
        };
        this.emailButton.addActionListener(this.delegatedEmailActionListener);
        this.followupDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedFollowupDate();
            }
        };
        this.followupDateField.addPropertyChangeListener("value", this.followupDatePropertyChangeListener);
        this.statusComboActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.statusComboActionPerformed(evt);
            }
        };
        this.statusCombo.addActionListener(this.statusComboActionListener);
        this.createdDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedCreatedDate();
            }
        };
        this.createdDateField.addPropertyChangeListener("value", this.createdDatePropertyChangeListener);
        this.startDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedStartDate();
            }
        };
        this.startDateField.addPropertyChangeListener("value", this.startDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedDueDate();
            }
        };
        this.dueDateField.addPropertyChangeListener("value", this.dueDatePropertyChangeListener);
        this.doneCheckBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.doneCheckBoxChanged();
            }
        };
        this.doneCheckBox.addActionListener(this.doneCheckBoxActionListener);
        this.doneDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PanelAction.this.changedDoneDate();
            }
        };
        this.doneDateField.addPropertyChangeListener("value", this.doneDatePropertyChangeListener);
        this.observerCriterion = new Observer(){

            public void update(Observable observable, Object arguement) {
                PanelAction.this.showHideCriteria();
            }
        };
        this.data.getTimeCriterion().addObserver(this.observerCriterion);
        this.data.getEnergyCriterion().addObserver(this.observerCriterion);
        this.data.getPriorityCriterion().addObserver(this.observerCriterion);
        this.priorityComboActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.priorityComboActionPerformed(evt);
            }
        };
        this.priorityCombo.addActionListener(this.priorityComboActionListener);
        this.energyComboActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.energyComboActionPerformed(evt);
            }
        };
        this.energyCombo.addActionListener(this.energyComboActionListener);
        this.timeComboActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.timeComboActionPerformed(evt);
            }
        };
        this.timeCombo.addActionListener(this.timeComboActionListener);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.descriptionDocListener);
        this.descriptionDocListener = null;
        this.descriptionText.removeFocusListener(this.descriptionFocusAdapter);
        this.descriptionFocusAdapter = null;
        this.contextsCombo.removeActionListener(this.contextActionListener);
        this.contextActionListener = null;
        this.statusCombo.removeActionListener(this.statusComboActionListener);
        this.statusComboActionListener = null;
        this.scheduledDateField.removePropertyChangeListener(this.scheduledDatePropertyChangeListener);
        this.scheduledDatePropertyChangeListener = null;
        this.scheduledHourSpinner.removeChangeListener(this.scheduledHourChangeListener);
        this.scheduledHourChangeListener = null;
        this.scheduledMinuteSpinner.removeChangeListener(this.scheduledMinuteChangeListener);
        this.scheduledMinuteChangeListener = null;
        this.durationHourSpinner.removeChangeListener(this.scheduledDurationHourChangeListener);
        this.scheduledDurationHourChangeListener = null;
        this.durationMinuteSpinner.removeChangeListener(this.scheduledDurationMinuteChangeListener);
        this.scheduledDurationMinuteChangeListener = null;
        this.delegatedToText.getDocument().removeDocumentListener(this.delegatedToDocListener);
        this.delegatedToDocListener = null;
        this.emailButton.removeActionListener(this.delegatedEmailActionListener);
        this.delegatedEmailActionListener = null;
        this.followupDateField.removePropertyChangeListener(this.followupDatePropertyChangeListener);
        this.followupDatePropertyChangeListener = null;
        this.createdDateField.removePropertyChangeListener(this.createdDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = null;
        this.startDateField.removePropertyChangeListener(this.startDatePropertyChangeListener);
        this.startDatePropertyChangeListener = null;
        this.dueDateField.removePropertyChangeListener(this.dueDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = null;
        this.doneCheckBox.removeActionListener(this.doneCheckBoxActionListener);
        this.doneCheckBoxActionListener = null;
        this.doneDateField.removePropertyChangeListener(this.doneDatePropertyChangeListener);
        this.doneDatePropertyChangeListener = null;
        this.notesEditorPane.removeDocumentListener(this.notesDocListener);
        this.notesDocListener = null;
        this.notesEditorPane.removeHyperlinkListener(this.notesHyperlinkListener);
        this.notesHyperlinkListener = null;
        this.priorityCombo.removeActionListener(this.priorityComboActionListener);
        this.priorityComboActionListener = null;
        this.energyCombo.removeActionListener(this.energyComboActionListener);
        this.energyComboActionListener = null;
        this.timeCombo.removeActionListener(this.timeComboActionListener);
        this.timeComboActionListener = null;
        this.data.getTimeCriterion().removeObserver(this.observerCriterion);
        this.data.getEnergyCriterion().removeObserver(this.observerCriterion);
        this.data.getPriorityCriterion().removeObserver(this.observerCriterion);
        this.observerCriterion = null;
    }
}

