/*
 * Decompiled with CFR 0.152.
 */
package tr.imports.thoughts.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.imports.thoughts.prefs.ImportThoughtsPrefs;
import tr.imports.thoughts.prefs.ImportThoughtsPrefsPanelController;

final class ImportThoughtsPrefsPanel
extends JPanel {
    private final ImportThoughtsPrefsPanelController controller;
    private JComboBox encodingCombo;
    private JLabel encodingLabel;

    ImportThoughtsPrefsPanel(ImportThoughtsPrefsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.encodingLabel = new JLabel();
        this.encodingCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ImportThoughtsPrefsPanel.class, (String)"Encoding"));
        this.encodingLabel.setMaximumSize(new Dimension(126, 23));
        this.encodingLabel.setMinimumSize(new Dimension(126, 23));
        this.encodingLabel.setPreferredSize(new Dimension(126, 23));
        this.encodingCombo.setEditable(true);
        this.encodingCombo.setModel(this.getEncodingModel());
        this.encodingCombo.setMaximumSize(new Dimension(1024, 23));
        this.encodingCombo.setMinimumSize(new Dimension(128, 23));
        this.encodingCombo.setPreferredSize(new Dimension(128, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.encodingLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.encodingCombo, -2, 160, -2).addContainerGap(30, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.encodingLabel, -2, -1, -2).add((Component)this.encodingCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private ComboBoxModel getEncodingModel() {
        Vector<String> encodings = new Vector<String>();
        encodings.add("");
        encodings.addAll(Charset.availableCharsets().keySet());
        return new DefaultComboBoxModel(encodings);
    }

    void load() {
        this.encodingCombo.setSelectedItem(ImportThoughtsPrefs.getEncoding());
    }

    void store() {
        if (this.isValidEncoding()) {
            ImportThoughtsPrefs.setEncoding(this.getEncoding());
        }
    }

    boolean valid() {
        return this.isValidEncoding();
    }

    private boolean isValidEncoding() {
        String encoding = this.getEncoding();
        return encoding.length() == 0 || Charset.isSupported(encoding);
    }

    private String getEncoding() {
        String encoding = (String)this.encodingCombo.getSelectedItem();
        return encoding == null ? "" : encoding;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ImportThoughtsPrefsPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            ImportThoughtsPrefsPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            ImportThoughtsPrefsPanel.this.controller.changed();
        }
    }
}

