/*
 * Decompiled with CFR 0.152.
 */
package tr.imports.thoughts;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openide.windows.WindowManager;
import tr.data.FileFilterImpl;
import tr.imports.thoughts.prefs.ImportThoughtsPrefs;
import tr.model.Data;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;

public class ImportThoughts {
    private static Manager<Thought> thoughts;
    private static Manager<Topic> topics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean doImport(Data data) throws Exception {
        assert (data != null);
        thoughts = data.getThoughtManager();
        topics = data.getTopicManager();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("ThinkingRock: Import Thoughts File");
        String[] extns = new String[]{"txt"};
        FileFilterImpl filter = new FileFilterImpl("Text Files", extns, true);
        chooser.setFileFilter((FileFilter)filter);
        File def = new File(ImportThoughtsPrefs.getDefaultFilePath());
        chooser.ensureFileIsVisible(def);
        chooser.setSelectedFile(def);
        Frame p = WindowManager.getDefault().getMainWindow();
        int option = chooser.showOpenDialog(p);
        if (option != 0) {
            return false;
        }
        String path = chooser.getSelectedFile().getPath();
        File file = new File(path);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new Exception("The file could not be opened and read.");
        }
        System.out.println("Importing thoughts from " + path);
        if (file.length() > (long)ImportThoughtsPrefs.getWarningFileSize()) {
            Object[] options;
            String t = "Import Thoughts Confirmation";
            String m = "The file you are importing is large and will result in approximately " + file.length() / 80L + " new thoughts.    \n " + "Are you sure that you want to continue?";
            int n = JOptionPane.showOptionDialog(p, m, t, 0, 3, null, options = new Object[]{"Yes", "No"}, options[1]);
            if (n != 0) {
                return false;
            }
        }
        int count = 0;
        BufferedReader input = null;
        try {
            input = ImportThoughts.getReader(file);
            String line = null;
            while ((line = input.readLine()) != null) {
                String topicName;
                Topic topic;
                if (line.trim().equals("")) continue;
                System.out.println("Importing line: " + line);
                Thought thought = new Thought();
                thought.setDescription(line);
                int i = line.lastIndexOf(9);
                if (i > -1 && (topic = ImportThoughts.getTopic(topicName = line.substring(i + 1))) != null) {
                    thought.setDescription(line.substring(0, i));
                    thought.setTopic(ImportThoughts.getTopic(topicName));
                }
                thoughts.add((Observable)thought);
                ++count;
            }
            ImportThoughtsPrefs.setDefaultFilePath(file.getPath());
            ImportThoughts.notifySuccess(count);
        }
        catch (Exception ex) {
            ImportThoughts.notifyFailure(ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {}
        }
        return true;
    }

    private static Topic getTopic(String name) {
        for (Topic topic : topics.list()) {
            if (!topic.getName().equalsIgnoreCase(name)) continue;
            return topic;
        }
        return null;
    }

    private static BufferedReader getReader(File file) throws Exception {
        String encoding = ImportThoughtsPrefs.getEncoding().trim();
        if (encoding == null || encoding.length() == 0 || !Charset.isSupported(encoding)) {
            return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    private static void notifySuccess(final int count) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String t = "Import Thoughts";
                String m = "Completed importing " + count + " thoughts.      ";
                Frame p = WindowManager.getDefault().getMainWindow();
                JOptionPane.showMessageDialog(p, m, t, 1);
            }
        });
    }

    private static void notifyFailure(final Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String t = "Import Thoughts";
                String m = "There was an error processing the file. \n" + ex.getMessage();
                Frame p = WindowManager.getDefault().getMainWindow();
                JOptionPane.showMessageDialog(p, m, t, 0);
            }
        });
    }
}

