/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.recurrence;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class RecurrencePrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.recurrence");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/prefs/recurrence");
    private static final String KEY_NBR_FUTURE_WEEKDAY = "nbr.future.weekday";
    private static final String KEY_NBR_FUTURE_DAY = "nbr.future.day";
    private static final String KEY_NBR_FUTURE_WEEK = "nbr.future.week";
    private static final String KEY_NBR_FUTURE_MONTH = "nbr.future.month";
    private static final String KEY_NBR_FUTURE_YEAR = "nbr.future.year";
    private static final int DEF_NBR_FUTURE_WEEKDAY = 5;
    private static final int DEF_NBR_FUTURE_DAY = 7;
    private static final int DEF_NBR_FUTURE_WEEK = 4;
    private static final int DEF_NBR_FUTURE_MONTH = 1;
    private static final int DEF_NBR_FUTURE_YEAR = 1;

    public static final int getNbrFutureWeekday() {
        return prefs.getInt(KEY_NBR_FUTURE_WEEKDAY, 5);
    }

    public static final int getNbrFutureDay() {
        return prefs.getInt(KEY_NBR_FUTURE_DAY, 7);
    }

    public static final int getNbrFutureWeek() {
        return prefs.getInt(KEY_NBR_FUTURE_WEEK, 4);
    }

    public static final int getNbrFutureMonth() {
        return prefs.getInt(KEY_NBR_FUTURE_MONTH, 1);
    }

    public static final int getNbrFutureYear() {
        return prefs.getInt(KEY_NBR_FUTURE_YEAR, 1);
    }

    public static final void setNbrFutureWeekday(int value) {
        prefs.putInt(KEY_NBR_FUTURE_WEEKDAY, value);
        RecurrencePrefs.flush();
    }

    public static final void setNbrFutureDay(int value) {
        prefs.putInt(KEY_NBR_FUTURE_DAY, value);
        RecurrencePrefs.flush();
    }

    public static final void setNbrFutureWeek(int value) {
        prefs.putInt(KEY_NBR_FUTURE_WEEK, value);
        RecurrencePrefs.flush();
    }

    public static final void setNbrFutureMonth(int value) {
        prefs.putInt(KEY_NBR_FUTURE_MONTH, value);
        RecurrencePrefs.flush();
    }

    public static final void setNbrFutureYear(int value) {
        prefs.putInt(KEY_NBR_FUTURE_YEAR, value);
        RecurrencePrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Projects preferences error. " + ex.getMessage());
        }
    }
}

