/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.screen;

import au.com.thinkingrock.tr.resource.Icons;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.Constants;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.reference.ReferenceDeleteAction;
import tr.view.reference.ReferenceEditAction;
import tr.view.reference.ReferenceReprocessAction;
import tr.view.reference.screen.ReferenceNode;
import tr.view.reference.screen.ReferenceNodeProvider;
import tr.view.reference.screen.ReferencesFilters;
import tr.view.reference.screen.ReferencesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferencesTopComponent
extends Window
implements ReferenceNodeProvider {
    public static final String PREFERRED_ID = "ReferencesTopComponent";
    private static final long serialVersionUID = 1L;
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/references");
    private static final String PREFS_KEY_SHOW_FILTERS = "show.filters";
    private static final boolean PREFS_DEF_SHOW_FILTERS = true;
    private static ReferencesTopComponent instance;
    private ReferencesPanel.Preferences panelPrefs;
    private transient ReferencesFilters filters;
    private transient ReferencesPanel panel;
    private transient InstanceContent content;
    private transient Lookup lookup;
    private transient JToolBar toolbar;
    private transient JPanel bodyPanel;
    private transient JToggleButton filtersButton;

    private ReferencesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ReferencesTopComponent.class, (String)"CTL_ReferencesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ReferencesTopComponent.class, (String)"TTT_ReferencesTopComponent"));
        this.setIcon(Icons.References.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ReferencesTopComponent getDefault() {
        if (instance == null) {
            instance = new ReferencesTopComponent();
        }
        return instance;
    }

    public static synchronized ReferencesTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find collect thoughts component. It will not be located properly in the window system.");
            return ReferencesTopComponent.getDefault();
        }
        if (win instanceof ReferencesTopComponent) {
            return (ReferencesTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ReferencesTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ReferencesTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            SystemAction[] actions = new SystemAction[]{SystemAction.get(ReferenceEditAction.class), SystemAction.get(ReferenceDeleteAction.class), SystemAction.get(ReferenceReprocessAction.class)};
            this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            this.filtersButton = new JToggleButton(new FiltersAction());
            this.toolbar.add((Component)this.filtersButton, 0);
            this.toolbar.setUI(new Toolbar().getUI());
            this.toolbar.setFloatable(false);
            Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
            for (Component component : this.toolbar.getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                component.setPreferredSize(buttonSize);
                component.setMinimumSize(buttonSize);
                component.setMaximumSize(buttonSize);
                component.setSize(buttonSize);
            }
        }
        return this.toolbar;
    }

    private ReferencesFilters getFilters() {
        if (this.filters == null) {
            this.filters = new ReferencesFilters();
        }
        return this.filters;
    }

    private MatcherEditor getMatcherEditor() {
        return this.getFilters().getMatcherEditor();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.provide(null);
        this.removeAll();
        this.getToolBar();
        String position = GUIPrefs.getButtonsPosition();
        if (position.equals("top")) {
            this.toolbar.setOrientation(0);
            this.add(this.toolbar, "North");
        } else if (position.equals("bottom")) {
            this.toolbar.setOrientation(0);
            this.add(this.toolbar, "South");
        } else if (position.equals("left")) {
            this.toolbar.setOrientation(1);
            this.add(this.toolbar, "West");
        } else if (position.equals("right")) {
            this.toolbar.setOrientation(1);
            this.add(this.toolbar, "East");
        }
        this.panel = new ReferencesPanel(this, this.getMatcherEditor());
        this.panel.setPreferences(this.panelPrefs);
        this.bodyPanel = new JPanel(new BorderLayout());
        this.bodyPanel.add((Component)this.panel, "Center");
        this.add(this.bodyPanel, "Center");
        boolean b = prefs.getBoolean(PREFS_KEY_SHOW_FILTERS, true);
        this.filtersButton.setSelected(b);
        this.filtersButton.getAction().actionPerformed(null);
    }

    protected void componentClosed() {
        this.panelPrefs = this.panel.getPreferences();
        prefs.putBoolean(PREFS_KEY_SHOW_FILTERS, this.filtersButton.isSelected());
        super.componentClosed();
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    @Override
    public void provide(final Collection<ReferenceNode> nodes) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (ReferencesTopComponent.this.panel == null || nodes == null) {
                    ReferencesTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    ReferencesTopComponent.this.getInstanceContent().set(nodes, null);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.reference");
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.panel.getPreferences(), this.getFilters().getSerializable());
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ReferencesPanel.Preferences prefs;
        private final Serializable rmes;

        public ResolvableHelper(ReferencesPanel.Preferences prefs, Serializable rmes) {
            this.prefs = prefs;
            this.rmes = rmes;
        }

        public Object readResolve() {
            ReferencesTopComponent result = ReferencesTopComponent.getDefault();
            result.panelPrefs = this.prefs;
            result.filters = new ReferencesFilters();
            result.filters.setSerializable(this.rmes);
            return result;
        }
    }

    private class FiltersAction
    extends AbstractAction {
        public FiltersAction() {
            super("", Icons.FiltersView);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_FiltersAction"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ReferencesTopComponent.this.filtersButton.isSelected()) {
                ReferencesTopComponent.this.bodyPanel.add(ReferencesTopComponent.this.getFilters().getComponent(), "North");
            } else {
                ReferencesTopComponent.this.bodyPanel.remove(ReferencesTopComponent.this.getFilters().getComponent());
            }
            ReferencesTopComponent.this.validate();
        }
    }
}

