/***************************************************************************
 *   Copyright (C) 2006 by Vladimir Kuznetsov                              *
 *   vovanec@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _WATCHVIEW
#define _WATCHVIEW

#include <QDialog>
#include <QMap>
#include <QHash>
#include <QEvent>

class QListWidget;
class QTreeWidget;
class QListWidgetItem;

class msgwatch : public QObject
{
    protected:
        QHash<QString,int> events;
        QObject* _watched;
    public:
        msgwatch(QObject* watched);
        virtual ~msgwatch();

        virtual bool eventFilter(QObject * , QEvent * event );
};


class EventsView : public QDialog ,public msgwatch
{
Q_OBJECT
    QMap<int,QWidget*> boxes;
    QMap<int,QString> keys;
    QListWidget* output;
    QTreeWidget* event_tree;

public:
    EventsView(QWidget* parent);
protected:
    virtual bool eventFilter(QObject * , QEvent * event );
protected slots:
    void handleCheckAll();
    void handleUncheckAll();
    void handleListItemClicked(QListWidgetItem*);
};


#endif
