/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.net.URL;
import java.util.Hashtable;
import org.mozilla.javascript.Scriptable;

public class OfficeScriptInfo {
    private Hashtable loadedSFScripts = new Hashtable();

    public void addScript(URL url, Scriptable scope, Runnable closeCallback) {
        this.addScript(url.toString(), url, scope, closeCallback);
    }

    public void addScript(String key, URL url, Scriptable scope, Runnable closeCallback) {
        SFScriptInfo si = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (si == null) {
            si = new SFScriptInfo();
            si.url = url;
            si.scope = scope;
            si.closeCallback = closeCallback;
            this.loadedSFScripts.put(key, si);
        }
    }

    public void deleteScript(String key) {
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.remove(key);
        if (info != null && info.closeCallback != null) {
            System.out.println("** In removeSFScriptInfo  have callback for " + key);
            info.closeCallback.run();
        }
    }

    public Scriptable getScriptScope(String key) {
        Scriptable result = null;
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (info != null) {
            result = info.scope;
        }
        return result;
    }

    public URL getScriptUrl(String key) {
        URL result = null;
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (info != null) {
            result = info.url;
        }
        return result;
    }

    public boolean hasScript(String key) {
        boolean result = true;
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (info == null) {
            result = false;
        }
        return result;
    }

    public void setScriptRunning(String key, boolean running) {
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (info != null) {
            info.isExecuting = running;
        }
    }

    public boolean isScriptRunning(String key) {
        boolean result = false;
        SFScriptInfo info = (SFScriptInfo)this.loadedSFScripts.get(key);
        if (info != null) {
            result = info.isExecuting;
        }
        return result;
    }

    class SFScriptInfo {
        Scriptable scope;
        boolean isExecuting;
        URL url;
        Runnable closeCallback;

        SFScriptInfo() {
        }
    }
}

