/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ShapeGradientContext
implements PaintContext {
    protected Color shadowColor;
    protected Color bgColor;
    protected Rectangle r;
    int cornerRadius = 6;
    int shadowWidth = 21;
    private WritableRaster raster = null;
    int[] last = new int[]{-1, -1, -1, -1};
    private static int[] data = new int[4];
    private static Point2D.Double POINT = new Point2D.Double();

    public ShapeGradientContext(Rectangle r, Color c1, Color c2) {
        this.shadowColor = c1;
        this.bgColor = c2;
        this.r = r;
        r.height -= this.cornerRadius * 2;
        r.width -= this.cornerRadius * 4;
        r.x += this.cornerRadius * 2 + 1;
        r.y += this.cornerRadius;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int x, int y, int w, int h) {
        if (this.raster != null && x == this.last[0] && y == this.last[1] && w == this.last[2] && h == this.last[3]) {
            return this.raster;
        }
        this.last[0] = x;
        this.last[1] = y;
        this.last[2] = w;
        this.last[3] = h;
        this.raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (j < this.r.y + this.r.height - (this.shadowWidth + this.cornerRadius)) {
                    int rightStart = w - (this.r.x + this.r.width + this.shadowWidth + this.cornerRadius);
                    if (i > this.shadowWidth + this.cornerRadius && w < rightStart) {
                        i = rightStart;
                    }
                }
                double ratio = 1.0;
                Point2D.Double nearest = POINT;
                nearest.setLocation(i > this.r.x + this.r.width ? (double)(this.r.x + this.r.width) : (i < this.r.x ? (double)this.r.x : (double)i), Math.min(j, y + this.r.y + this.r.height));
                double dist = nearest.distance(x + i, y + j) + 1.0;
                dist *= dist / (double)(this.shadowWidth - x + this.cornerRadius);
                if (j <= this.cornerRadius * 2) {
                    double factor = (double)(this.cornerRadius * 2) / (double)j;
                    dist *= factor;
                }
                if ((ratio = dist / (double)(this.shadowWidth - x)) > 1.0) {
                    ratio = 1.0;
                }
                int base = 0;
                ShapeGradientContext.data[base + 0] = (int)((double)this.shadowColor.getRed() + ratio * (double)(this.bgColor.getRed() - this.shadowColor.getRed()));
                ShapeGradientContext.data[base + 1] = (int)((double)this.shadowColor.getGreen() + ratio * (double)(this.bgColor.getGreen() - this.shadowColor.getGreen()));
                ShapeGradientContext.data[base + 2] = (int)((double)this.shadowColor.getBlue() + ratio * (double)(this.bgColor.getBlue() - this.shadowColor.getBlue()));
                ShapeGradientContext.data[base + 3] = (int)((double)this.shadowColor.getAlpha() + ratio * (double)(this.bgColor.getAlpha() - this.shadowColor.getAlpha()));
                this.raster.setPixels(i, j, 1, 1, data);
            }
        }
        return this.raster;
    }
}

