/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.GroupByNode;
import oracle.toplink.essentials.internal.parsing.MajorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class HavingNode
extends MajorNode {
    private Node having = null;

    public void validate(ParseTreeContext context, GroupByNode groupbyNode) {
        if (this.having != null) {
            this.having.validate(context);
            if (groupbyNode != null && !groupbyNode.isValidHavingExpr(this.having)) {
                throw EJBQLException.invalidHavingExpression(this.having.getAsString(), groupbyNode.getAsString());
            }
        }
    }

    public void addHavingToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            Expression havingExpression = this.getHaving().generateExpression(context);
            ((ReportQuery)theQuery).setHavingExpression(havingExpression);
        }
    }

    public Node getHaving() {
        return this.having;
    }

    public void setHaving(Node having) {
        this.having = having;
    }
}

