/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.core.syntax.completion.ResultItem;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class JspCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int type = ((JspSyntaxSupport)Utilities.getDocument((JTextComponent)component).getSyntaxSupport()).checkCompletion(component, typedText, false);
        if (type == 0) {
            return 3;
        }
        return 0;
    }

    public CompletionTask createTask(int type, JTextComponent component) {
        if (type == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(component.getCaret().getDot()), component);
        }
        if (type == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        return null;
    }

    static CompletionQuery.Result queryImpl(JTextComponent component, int offset) {
        Class kitClass = Utilities.getKitClass((JTextComponent)component);
        if (kitClass != null) {
            JspSyntaxSupport support = (JspSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)component);
            return new JspCompletionQuery((CompletionQuery)HTMLCompletionQuery.getDefault()).query(component, offset, (SyntaxSupport)support);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        JspSyntaxSupport sup = (JspSyntaxSupport)doc.getSyntaxSupport().get(JspSyntaxSupport.class);
        try {
            TokenItem ti = sup.getTokenChain(caretOffset <= 0 ? 0 : caretOffset - 1, caretOffset);
            if (ti != null && ti.getTokenID() == HTMLTokenContext.TEXT && !ti.getImage().startsWith("<") && !ti.getImage().startsWith("&")) {
                JspCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            JspCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (doc != null) {
                JspCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
            }
            this.doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    static class DocItem
    implements CompletionDocumentation {
        private ResultItem ri;

        public DocItem(ResultItem ri) {
            this.ri = ri;
        }

        public String getText() {
            return this.ri.getHelp();
        }

        public URL getURL() {
            return this.ri.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private ResultItem item;

        public DocQuery(ResultItem item) {
            this.item = item;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            List result;
            CompletionQuery.Result res = JspCompletionProvider.queryImpl(this.component, caretOffset);
            if (this.item == null && res != null && (result = res.getData()) != null && result.size() > 0) {
                HTMLCompletionQuery.HTMLResultItem htmlItem;
                Object resultObj = result.get(0);
                if (resultObj instanceof ResultItem) {
                    this.item = (ResultItem)resultObj;
                } else if (resultObj instanceof HTMLCompletionQuery.HTMLResultItem && (htmlItem = (HTMLCompletionQuery.HTMLResultItem)resultObj) != null && htmlItem.getHelpID() != null) {
                    resultSet.setDocumentation((CompletionDocumentation)new HTMLCompletionQuery.DocItem(htmlItem));
                    resultSet.setTitle(res.getTitle());
                    return;
                }
            }
            if (!(this.item == null || this.item instanceof JspCompletionItem.ELItem || this.item.getHelp() == null && this.item.getHelpURL() == null)) {
                resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
                if (res != null) {
                    resultSet.setTitle(res.getTitle());
                }
            }
        }
    }

    static final class Query
    extends AbstractQuery {
        private JTextComponent component;
        private int creationCaretOffset;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionQuery.Result res = JspCompletionProvider.queryImpl(this.component, caretOffset);
            if (res != null) {
                List results = res.getData();
                resultSet.addAllItems((Collection)results);
                resultSet.setTitle(res.getTitle());
                resultSet.setAnchorOffset(((JspCompletionQuery.SubstituteOffsetProvider)res).getSubstituteOffset());
            }
        }
    }
}

