/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private String expression;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            StyledDocument doc = ec.openDocument();
            JEditorPane ep = ToolTipAnnotation.getCurrentEditor();
            if (ep == null) {
                return null;
            }
            ToolTipAnnotation toolTipAnnotation = this;
            synchronized (toolTipAnnotation) {
                this.expression = ToolTipAnnotation.getIdentifier(doc, ep, NbDocument.findLineOffset((StyledDocument)doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
                if (this.expression == null) {
                    return null;
                }
            }
            RequestProcessor.getDefault().post((Runnable)this);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String expression;
        ToolTipAnnotation toolTipAnnotation = this;
        synchronized (toolTipAnnotation) {
            expression = this.expression;
        }
        if (expression == null) {
            return;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return;
        }
        JPDAThread t = d.getCurrentThread();
        if (t == null || !t.isSuspended()) {
            return;
        }
        String toolTipText = null;
        try {
            Variable v = d.evaluate(expression);
            String type = v.getType();
            String value = v.getValue();
            if (v instanceof ObjectVariable) {
                try {
                    toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + ((ObjectVariable)v).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + value;
                }
            } else {
                toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + value;
            }
        }
        catch (InvalidExpressionException e) {
            toolTipText = expression + " = >" + e.getMessage() + "<";
        }
        this.firePropertyChange("shortDescription", null, toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    static JEditorPane getCurrentEditor() {
        EditorCookie e = ToolTipAnnotation.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node n = nodes[0];
        return (EditorCookie)n.getCookie(EditorCookie.class);
    }
}

