/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public abstract class ObjectSerializerBase
extends SerializerBase {
    protected ObjectSerializerBase(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type, encodeType, isNullable, encodingStyle);
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected abstract void doSerializeInstance(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected void serializeNull(QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        writer.startElement(name != null ? name : this.type);
        boolean pushedEncodingStyle = false;
        if (this.encodingStyle != null) {
            pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        }
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
    }

    protected abstract Object doDeserialize(SOAPDeserializationState var1, XMLReader var2, SOAPDeserializationContext var3) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        SOAPDeserializationState state;
        boolean pushedEncodingStyle;
        block18: {
            Object object;
            block17: {
                pushedEncodingStyle = false;
                try {
                    try {
                        pushedEncodingStyle = context.processEncodingStyle(reader);
                        if (this.encodingStyle != null) {
                            context.verifyEncodingStyle(this.encodingStyle);
                        }
                        if (name != null) {
                            this.verifyName(reader, name);
                        }
                        String id = this.getID(reader);
                        boolean isNull = SerializerBase.getNullStatus(reader);
                        if (!isNull) {
                            Object instance;
                            this.verifyType(reader);
                            SOAPDeserializationState state2 = null;
                            if (id != null) {
                                state2 = context.getStateFor(id);
                                state2.setDeserializer(this);
                            }
                            if ((instance = this.doDeserialize(state2, reader, context)) instanceof SOAPDeserializationState) {
                                state2 = (SOAPDeserializationState)instance;
                            } else if (state2 != null) {
                                state2.setInstance(instance);
                            }
                            if (state2 != null) {
                                state2.doneReading();
                                SOAPDeserializationState sOAPDeserializationState = state2;
                                Object var11_15 = null;
                                if (!pushedEncodingStyle) return sOAPDeserializationState;
                                context.popEncodingStyle();
                                return sOAPDeserializationState;
                            }
                            object = instance;
                            break block17;
                        }
                        if (!this.isNullable) {
                            throw new DeserializationException("soap.unexpectedNull");
                        }
                        this.skipEmptyContent(reader);
                        if (id != null) {
                            state = context.getStateFor(id);
                            state.setDeserializer(this);
                            state.setInstance(null);
                            state.doneReading();
                        }
                        state = null;
                        break block18;
                    }
                    catch (DeserializationException e) {
                        throw e;
                    }
                    catch (JAXRPCExceptionBase e) {
                        throw new DeserializationException(e);
                    }
                    catch (Exception e) {
                        throw new DeserializationException(new LocalizableExceptionAdapter(e));
                    }
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    if (!pushedEncodingStyle) throw throwable;
                    context.popEncodingStyle();
                    throw throwable;
                }
            }
            Object var11_16 = null;
            if (!pushedEncodingStyle) return object;
            context.popEncodingStyle();
            return object;
        }
        Object var11_17 = null;
        if (!pushedEncodingStyle) return state;
        context.popEncodingStyle();
        return state;
    }

    public static SOAPDeserializationState registerWithMemberState(Object instance, SOAPDeserializationState state, Object member, int memberIndex, SOAPInstanceBuilder builder) {
        try {
            SOAPDeserializationState deserializationState = state == null ? new SOAPDeserializationState() : state;
            deserializationState.setInstance(instance);
            if (deserializationState.getBuilder() == null) {
                if (builder == null) {
                    throw new IllegalArgumentException();
                }
                deserializationState.setBuilder(builder);
            }
            SOAPDeserializationState memberState = (SOAPDeserializationState)member;
            memberState.registerListener(deserializationState, memberIndex);
            return deserializationState;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        boolean pushedEncodingStyle = false;
        try {
            block13: {
                try {
                    if (obj == null) {
                        if (!this.isNullable) {
                            throw new SerializationException("soap.unexpectedNull");
                        }
                        this.serializeNull(name, writer, context);
                        break block13;
                    }
                    writer.startElement(name != null ? name : this.type);
                    if (callback != null) {
                        callback.onStartTag(obj, name, writer, context);
                    }
                    if (this.encodingStyle != null) {
                        pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
                    }
                    if (this.encodeType) {
                        String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
                        writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
                    }
                    this.doSerializeAttributes(obj, writer, context);
                    this.doSerializeInstance(obj, writer, context);
                    writer.endElement();
                }
                catch (SerializationException e) {
                    throw e;
                }
                catch (JAXRPCExceptionBase e) {
                    throw new SerializationException(e);
                }
                catch (Exception e) {
                    throw new SerializationException(new LocalizableExceptionAdapter(e));
                }
            }
            Object var11_9 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }
}

