/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.BaseAction;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

class SelectCodeElementAction
extends BaseAction {
    private boolean selectNext;

    public SelectCodeElementAction(String name, boolean selectNext) {
        super(name);
        this.selectNext = selectNext;
        String desc = this.getShortDescription();
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        }
    }

    public String getShortDescription() {
        String shortDesc;
        String name = (String)this.getValue("Name");
        if (name == null) {
            return null;
        }
        try {
            shortDesc = NbBundle.getBundle((Class)JavaKit.class).getString(name);
        }
        catch (MissingResourceException mre) {
            shortDesc = name;
        }
        return shortDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            int selectionStartOffset = target.getSelectionStart();
            int selectionEndOffset = target.getSelectionEnd();
            if (selectionEndOffset > selectionStartOffset || this.selectNext) {
                SelectionHandler handler = (SelectionHandler)target.getClientProperty(SelectionHandler.class);
                if (handler == null) {
                    handler = new SelectionHandler(target);
                    target.addCaretListener(handler);
                    target.putClientProperty(SelectionHandler.class, handler);
                }
                if (!this.selectNext) {
                    if (!handler.isEmpty()) {
                        handler.popSelectionInfo();
                        handler.selectTop();
                    }
                } else {
                    DataObject dob = NbEditorUtilities.getDataObject((Document)target.getDocument());
                    if (dob != null) {
                        JMManager manager = (JMManager)JMManager.getManager();
                        MDRepository repository = JavaModel.getJavaRepository();
                        repository.beginTrans(true);
                        try {
                            Element elem;
                            if (handler.isEmpty()) {
                                handler.pushSelectionInfo(new SelectionInfo(selectionStartOffset, selectionEndOffset, null));
                            }
                            if (!((elem = handler.peekSelectionInfo().getElement()) instanceof Resource) && (elem = elem != null ? (Element)elem.refImmediateComposite() : manager.getElementByOffset(dob.getPrimaryFile(), selectionStartOffset)) != null) {
                                PositionBounds bounds = manager.getElementPosition(elem);
                                selectionStartOffset = bounds.getBegin().getOffset();
                                selectionEndOffset = bounds.getEnd().getOffset();
                                if (elem instanceof Resource) {
                                    selectionStartOffset = 0;
                                    selectionEndOffset = target.getDocument().getLength();
                                }
                                handler.pushSelectionInfo(new SelectionInfo(selectionStartOffset, selectionEndOffset, elem));
                                handler.selectTop();
                            }
                        }
                        finally {
                            repository.endTrans();
                        }
                    }
                }
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;
        private Element element;

        SelectionInfo(int startOffset, int endOffset, Element element) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.element = element;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public Element getElement() {
            return this.element;
        }
    }

    private static final class SelectionHandler
    implements CaretListener {
        private JTextComponent target;
        private Stack selectionInfoStack;
        private boolean ignoreNextCaretUpdate;

        SelectionHandler(JTextComponent target) {
            this.target = target;
            this.selectionInfoStack = new Stack();
        }

        public void pushSelectionInfo(SelectionInfo selectionInfo) {
            this.selectionInfoStack.push(selectionInfo);
        }

        public SelectionInfo popSelectionInfo() {
            return (SelectionInfo)this.selectionInfoStack.pop();
        }

        public SelectionInfo peekSelectionInfo() {
            return (SelectionInfo)this.selectionInfoStack.peek();
        }

        public boolean isEmpty() {
            return this.selectionInfoStack.empty();
        }

        public void selectTop() {
            if (!this.selectionInfoStack.empty()) {
                SelectionInfo top = this.peekSelectionInfo();
                Caret caret = this.target.getCaret();
                this.markIgnoreNextCaretUpdate();
                caret.setDot(top.getStartOffset());
                this.markIgnoreNextCaretUpdate();
                caret.moveDot(top.getEndOffset());
            }
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        public void caretUpdate(CaretEvent e) {
            if (!this.ignoreNextCaretUpdate) {
                this.selectionInfoStack.clear();
            }
            this.ignoreNextCaretUpdate = false;
        }
    }
}

