/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbMainExplorer
extends CloneableTopComponent {
    static final long serialVersionUID = 6021472310669753679L;
    private List prevRoots;
    private Map rootsToTCs;
    private transient RootsListener rootsListener = new RootsListener();
    public static final int MIN_HEIGHT = 150;
    public static final int DEFAULT_WIDTH = 350;
    private static Map moduleTabs;
    private static NbMainExplorer explorer;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$core$EnvironmentNode;

    public NbMainExplorer() {
        NbPlaces p = NbPlaces.getDefault();
        p.addChangeListener(WeakListeners.change((ChangeListener)this.rootsListener, (Object)p));
        this.refreshRoots();
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.getActivatedNodes(), (HelpCtx)new HelpCtx(NbMainExplorer.class));
    }

    private static synchronized ModuleTab findModuleTab(Node root, ModuleTab tc) {
        ModuleTab tab;
        if (moduleTabs == null) {
            moduleTabs = new WeakHashMap(5);
        }
        if ((tab = (ModuleTab)((Object)moduleTabs.get(root))) != null) {
            return tab;
        }
        if (tc != null) {
            moduleTabs.put(root, tc);
            return tc;
        }
        ModuleTab newTC = new ModuleTab();
        moduleTabs.put(root, newTC);
        return newTC;
    }

    public void open(Workspace workspace) {
        this.doOpen(workspace);
    }

    private void doOpen(Workspace workspace) {
        if (workspace == null) {
            this.refreshRoots();
        } else {
            super.open(workspace);
            this.close(workspace);
            NbMainExplorer singleton = NbMainExplorer.getExplorer();
            singleton.openRoots(workspace);
        }
    }

    public void openRoots() {
        this.openRoots(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void openRoots(Workspace workspace) {
        ExplorerTab toBeActivated = MainTab.lastActivated;
        this.refreshRoots();
        Node[] rootsArray = NbMainExplorer.getRoots().toArray(new Node[0]);
        ExplorerTab tc = null;
        for (int i = 0; i < rootsArray.length; ++i) {
            tc = this.getRootPanel(rootsArray[i]);
            if (tc == null) continue;
            tc.open(workspace);
        }
        if (toBeActivated == null) {
            toBeActivated = this.getRootPanel(rootsArray[0]);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mode mode;
            if (toBeActivated != null && (mode = workspace.findMode((TopComponent)toBeActivated)) != null) {
                toBeActivated.requestActive();
            }
        } else if (toBeActivated != null) {
            final MainTab localActivated = toBeActivated;
            final Workspace localWorkspace = workspace;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Mode mode = localWorkspace.findMode((TopComponent)localActivated);
                    if (mode != null) {
                        localActivated.requestActive();
                    }
                }
            });
        }
    }

    final void refreshRoots() {
        List curRoots = NbMainExplorer.getRoots();
        if (this.prevRoots != null) {
            HashSet toRemove = new HashSet(this.prevRoots);
            toRemove.removeAll(curRoots);
            Iterator it = this.rootsToTCs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Node r = (Node)me.getKey();
                if (!toRemove.contains(r)) continue;
                NbMainExplorer.closeEverywhere((TopComponent)me.getValue());
            }
        } else {
            this.prevRoots();
        }
        List workspaces = NbMainExplorer.whereOpened(this.rootsToTCs().values().toArray(new TopComponent[0]));
        Iterator iter = curRoots.iterator();
        while (iter.hasNext()) {
            Node r = (Node)iter.next();
            ExplorerTab tc = this.getRootPanel(r);
            if (tc != null) continue;
            tc = this.createTC(r, false);
            Iterator iter2 = workspaces.iterator();
            while (iter2.hasNext()) {
                tc.open((Workspace)iter2.next());
            }
        }
        this.prevRoots = curRoots;
    }

    private static void closeEverywhere(TopComponent tc) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        for (int i = 0; i < workspaces.length; ++i) {
            if (!tc.isOpened(workspaces[i])) continue;
            tc.close(workspaces[i]);
        }
    }

    private static List whereOpened(TopComponent[] tcs) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        ArrayList<Workspace> result = new ArrayList<Workspace>(workspaces.length);
        block0: for (int i = 0; i < workspaces.length; ++i) {
            for (int j = 0; j < tcs.length; ++j) {
                if (!tcs[j].isOpened(workspaces[i])) continue;
                result.add(workspaces[i]);
                continue block0;
            }
        }
        return result;
    }

    public static List getRoots() {
        NbPlaces places = NbPlaces.getDefault();
        LinkedList<Node> result = new LinkedList<Node>();
        result.addAll(Arrays.asList(places.roots()));
        result.add(places.environment());
        return result;
    }

    private ExplorerTab createTC(Node rc, boolean deserialize) {
        MainTab panel = null;
        NbPlaces places = NbPlaces.getDefault();
        if (rc.equals((Object)places.environment())) {
            if (deserialize) {
                TopComponent tc = WindowManager.getDefault().findTopComponent("runtime");
                if (tc != null) {
                    if (tc instanceof MainTab) {
                        panel = (MainTab)tc;
                    } else {
                        IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + MainTab.class.getName() + " Returned:" + tc.getClass().getName());
                        ErrorManager.getDefault().notify(1, (Throwable)exc);
                        panel = MainTab.getDefaultMainTab();
                    }
                } else {
                    panel = MainTab.getDefaultMainTab();
                }
            } else {
                panel = MainTab.getDefaultMainTab();
            }
            panel.setRootContext(rc, false);
        } else {
            panel = NbMainExplorer.findModuleTab(rc, null);
            panel.setRootContext(rc);
        }
        this.rootsToTCs().put(rc, panel);
        return panel;
    }

    private Map rootsToTCs() {
        if (this.rootsToTCs == null) {
            this.rootsToTCs = new HashMap(7);
        }
        return this.rootsToTCs;
    }

    private List prevRoots() {
        if (this.prevRoots == null) {
            this.prevRoots = new LinkedList();
        }
        return this.prevRoots;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int cnt = in.readInt();
        for (int i = 0; i < cnt; ++i) {
            in.readObject();
        }
        in.readObject();
        in.readBoolean();
        in.readBoolean();
        in.readInt();
        in.readInt();
    }

    public final ExplorerTab getRootPanel(Node root) {
        return (ExplorerTab)((Object)this.rootsToTCs().get(root));
    }

    public static NbMainExplorer getExplorer() {
        if (explorer == null) {
            explorer = new NbMainExplorer();
        }
        return explorer;
    }

    private static Mode explorerMode(Workspace workspace) {
        Mode result = workspace.findMode("explorer");
        if (result == null) {
            String displayName = NbBundle.getBundle((Class)NbMainExplorer.class).getString("CTL_ExplorerTitle");
            result = workspace.createMode("explorer", displayName, NbMainExplorer.class.getResource("/org/netbeans/core/resources/frames/explorer.gif"));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        NbMainExplorer e = new NbMainExplorer();
        e.open();
    }

    private static final class RootsListener
    implements ChangeListener {
        RootsListener() {
        }

        public void stateChanged(ChangeEvent e) {
            NbMainExplorer.getExplorer().doOpen(null);
        }
    }

    public static class ModuleTab
    extends MainTab {
        static final long serialVersionUID = 8089827754534653731L;

        public void setRootContext(Node root) {
            super.setRootContext(root);
            this.adjustComponentPersistence();
        }

        public int getPersistenceType() {
            return this.persistenceType;
        }

        protected void validateRootContext() {
            Class<?> nodeClass = this.getExplorerManager().getRootContext().getClass();
            Node[] roots = NbPlaces.getDefault().roots();
            for (int i = 0; i < roots.length; ++i) {
                if (!nodeClass.equals(roots[i].getClass())) continue;
                this.setRootContext(roots[i]);
                this.registerRootContext(roots[i]);
                break;
            }
        }

        public Object readResolve() throws ObjectStreamException {
            Node root = this.getExplorerManager().getRootContext();
            ModuleTab tc = NbMainExplorer.findModuleTab(root, this);
            if (tc == null) {
                throw new InvalidObjectException("Cannot deserialize ModuleTab for node " + root);
            }
            tc.scheduleValidation();
            return tc;
        }
    }

    public static class MainTab
    extends ExplorerTab {
        static final long serialVersionUID = 4233454980309064344L;
        private static MainTab lastActivated;
        private static MainTab DEFAULT;

        public static synchronized MainTab getDefaultMainTab() {
            if (DEFAULT == null) {
                DEFAULT = new MainTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static MainTab findEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().environment(), true);
        }

        public static MainTab createEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().environment(), false);
        }

        public int getPersistenceType() {
            return 0;
        }

        protected String preferredID() {
            return "runtime";
        }

        public HelpCtx getHelpCtx() {
            return ExplorerUtils.getHelpCtx((Node[])this.getExplorerManager().getSelectedNodes(), (HelpCtx)new HelpCtx(class$org$netbeans$core$EnvironmentNode == null ? (class$org$netbeans$core$EnvironmentNode = NbMainExplorer.class$("org.netbeans.core.EnvironmentNode")) : class$org$netbeans$core$EnvironmentNode));
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            MainTab.getDefaultMainTab().scheduleValidation();
            return MainTab.getDefaultMainTab();
        }

        public void open(Workspace workspace) {
            Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            Mode ourMode = realWorkspace.findMode((TopComponent)this);
            if (ourMode == null) {
                NbMainExplorer.explorerMode(realWorkspace).dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        protected void updateTitle() {
        }

        protected void componentActivated() {
            super.componentActivated();
            lastActivated = this;
        }

        protected void validateRootContext() {
            super.validateRootContext();
            this.registerRootContext(this.getExplorerManager().getRootContext());
        }

        protected void registerRootContext(Node rc) {
            NbMainExplorer explorer = NbMainExplorer.getExplorer();
            explorer.prevRoots().add(rc);
            explorer.rootsToTCs().put(rc, this);
        }
    }

    public static class ExplorerTab
    extends ExplorerPanel
    implements TopComponent.Cloneable {
        static final long serialVersionUID = -8202452314155464024L;
        protected TreeView view;
        private PropertyChangeListener weakRcL;
        private PropertyChangeListener weakIdeL;
        private NodeListener weakNRcL;
        private IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = NbMainExplorer.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        private NodeListener rcListener;
        private boolean valid = true;
        private boolean rootVis = true;
        protected int persistenceType = 0;

        public ExplorerTab() {
            this.getActionMap().put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)this.ideSettings.getConfirmDelete()));
            this.weakIdeL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)((Object)this.ideSettings));
            this.ideSettings.addPropertyChangeListener(this.weakIdeL);
        }

        public int getPersistenceType() {
            return 0;
        }

        protected void componentShowing() {
            super.componentShowing();
            if (this.view == null) {
                this.view = this.initGui();
                this.view.setRootVisible(this.rootVis);
                this.view.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerBeanTree"));
                this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerBeanTree"));
            }
        }

        public void addNotify() {
            super.addNotify();
            if (WindowManager.getDefault().findMode((TopComponent)this) != null) {
                return;
            }
            this.componentShowing();
        }

        public void requestFocus() {
            super.requestFocus();
            if (this.view != null) {
                this.view.requestFocus();
            }
        }

        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            if (this.view != null) {
                return this.view.requestFocusInWindow();
            }
            return false;
        }

        protected TreeView initGui() {
            BeanTreeView view = new BeanTreeView();
            view.setDragSource(true);
            this.setLayout(new BorderLayout());
            this.add((Component)view);
            return view;
        }

        public void open(Workspace workspace) {
            this.setValidRootContext();
            super.open(workspace);
        }

        public void setRootContext(Node rc) {
            Node oldRC = this.getExplorerManager().getRootContext();
            if (this.weakRcL != null) {
                oldRC.removePropertyChangeListener(this.weakRcL);
            }
            if (this.weakNRcL != null) {
                oldRC.removeNodeListener(this.weakNRcL);
            }
            this.getExplorerManager().setRootContext(rc);
            this.initializeWithRootContext(rc);
        }

        public void setRootContext(Node rc, boolean rootVisible) {
            this.rootVis = rootVisible;
            if (this.view != null) {
                this.view.setRootVisible(rootVisible);
            }
            this.setRootContext(rc);
        }

        public void adjustComponentPersistence() {
            Node.Handle handle = this.getExplorerManager().getRootContext().getHandle();
            this.persistenceType = handle == null ? 2 : 1;
        }

        public Node getRootContext() {
            return this.getExplorerManager().getRootContext();
        }

        public Object readResolve() throws ObjectStreamException {
            this.scheduleValidation();
            return this;
        }

        private void setValidRootContext() {
            if (!this.valid) {
                this.valid = true;
                this.validateRootContext();
            }
        }

        protected void validateRootContext() {
            this.initializeWithRootContext(this.getExplorerManager().getRootContext());
        }

        protected void updateTitle() {
            this.setName(this.getExplorerManager().getRootContext().getDisplayName());
        }

        private NodeListener rcListener() {
            if (this.rcListener == null) {
                this.rcListener = new RootContextListener();
            }
            return this.rcListener;
        }

        private void initializeWithRootContext(Node rc) {
            this.setIcon(rc.getIcon(1));
            this.setToolTipText(rc.getShortDescription());
            this.setName(rc.getDisplayName());
            this.updateTitle();
            if (this.weakRcL == null) {
                this.weakRcL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)rc);
            } else {
                rc.removePropertyChangeListener(this.weakRcL);
            }
            rc.addPropertyChangeListener(this.weakRcL);
            if (this.weakNRcL == null) {
                this.weakNRcL = NodeOp.weakNodeListener((NodeListener)this.rcListener(), (Object)rc);
            } else {
                rc.removeNodeListener(this.weakNRcL);
            }
            rc.addNodeListener(this.weakNRcL);
        }

        protected final void scheduleValidation() {
            this.valid = false;
            this.setValidRootContext();
        }

        public void setName(String name) {
            super.setName(name);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleName(name);
            }
        }

        public void setToolTipText(String text) {
            super.setToolTipText(text);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleDescription(text);
            }
        }

        public TopComponent cloneComponent() {
            ExplorerTab nue = new ExplorerTab();
            nue.getExplorerManager().setRootContext(this.getExplorerManager().getRootContext());
            try {
                nue.getExplorerManager().setSelectedNodes(this.getExplorerManager().getSelectedNodes());
            }
            catch (PropertyVetoException pve) {
                ErrorManager.getDefault().notify((Throwable)pve);
            }
            return nue;
        }

        private final class RootContextListener
        implements NodeListener {
            RootContextListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                Object source = evt.getSource();
                if (source instanceof IDESettings) {
                    ExplorerTab.this.getActionMap().put("delete", ExplorerUtils.actionDelete((ExplorerManager)ExplorerTab.this.getExplorerManager(), (boolean)((IDESettings)((Object)source)).getConfirmDelete()));
                    return;
                }
                final Node n = (Node)source;
                if ("displayName".equals(propName) || "name".equals(propName)) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            ExplorerTab.this.setName(n.getDisplayName());
                        }
                    });
                } else if ("icon".equals(propName)) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            ExplorerTab.this.setIcon(n.getIcon(1));
                        }
                    });
                } else if ("shortDescription".equals(propName)) {
                    ExplorerTab.this.setToolTipText(n.getShortDescription());
                }
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                ExplorerTab.this.setCloseOperation(0);
                ExplorerTab.this.close();
            }

            public void childrenRemoved(NodeMemberEvent e) {
            }

            public void childrenReordered(NodeReorderEvent e) {
            }

            public void childrenAdded(NodeMemberEvent e) {
            }
        }
    }
}

