/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.netbeans.beaninfo.editors.FileEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectListView
extends DataObjectPanel
implements PropertyChangeListener {
    static final int DEFAULT_INSET = 10;
    private JFileChooser chooser;
    private File rootFile;
    private Node filteredRootNode;
    private boolean initialized = false;

    public DataObjectListView(PropertyEditorSupport my, PropertyEnv env) {
        super(my, env);
    }

    public void addNotify() {
        this.completeInitialization();
        super.addNotify();
    }

    private void completeInitialization() {
        Node n;
        if (this.initialized) {
            return;
        }
        if (this.insets != null) {
            this.setBorder(new EmptyBorder(this.insets));
        } else {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        this.setLayout(new BorderLayout(0, 2));
        this.filteredRootNode = this.rootNode;
        if (this.filteredRootNode == null) {
            if (this.dataFilter != null) {
                if (this.folderFilter != null) {
                    DataFilter dFilter = new DataFilter(){

                        public boolean acceptDataObject(DataObject obj) {
                            if (DataObjectListView.this.folderFilter.acceptDataObject(obj)) {
                                return true;
                            }
                            return DataObjectListView.this.dataFilter.acceptDataObject(obj);
                        }
                    };
                    this.filteredRootNode = RepositoryNodeFactory.getDefault().repository(dFilter);
                } else {
                    this.filteredRootNode = RepositoryNodeFactory.getDefault().repository(this.dataFilter);
                }
            } else {
                this.filteredRootNode = this.folderFilter != null ? RepositoryNodeFactory.getDefault().repository(this.folderFilter) : RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
            }
        }
        if (this.nodeFilter != null) {
            DataObjectPanel.FilteredChildren children = new DataObjectPanel.FilteredChildren(this.filteredRootNode, this.nodeFilter, this.dataFilter);
            FilterNode n2 = new FilterNode(this.filteredRootNode, (Children)children);
            this.filteredRootNode = n2;
        }
        if (this.rootObject != null && (n = this.findNodeForObj(this.filteredRootNode, this.rootObject)) != null) {
            NodeAcceptor naccep = this.nodeFilter;
            if (naccep == null) {
                naccep = new NodeAcceptor(){

                    public boolean acceptNodes(Node[] nodes) {
                        return false;
                    }
                };
            }
            DataObjectPanel.FilteredChildren children = new DataObjectPanel.FilteredChildren(n, naccep, this.dataFilter);
            FilterNode filtNode = new FilterNode(n, (Children)children);
            this.filteredRootNode = filtNode;
        }
        this.rootFile = new NodeFile(DataObjectListView.getFileName(this.filteredRootNode), this.filteredRootNode);
        this.chooser = new NodeFileChooser(this.rootFile, new NodeFileSystemView());
        FileEditor.hackFileChooser(this.chooser);
        if (this.description != null) {
            this.setDescription(this.description);
        } else {
            this.setDescription(NbBundle.getMessage((Class)DataObjectListView.class, (String)"ACSD_DataObjectPanel"));
        }
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setMultiSelectionEnabled(this.multiSelection);
        this.chooser.setFileSelectionMode(this.selectionMode);
        this.chooser.addPropertyChangeListener(this);
        if (this.dObj != null) {
            String path = DataObjectListView.findPathTo(this.filteredRootNode, this.dObj);
            this.chooser.setCurrentDirectory(new NodeFile(path, this.dObj.getNodeDelegate()));
        }
        this.add((Component)this.chooser, "Center");
        if (this.multiSelection) {
            DataObject[] dObjArr = this.getDataObjects();
            if (this.dataFilter != null && dObjArr != null) {
                boolean b = false;
                for (int i = 0; i < dObjArr.length; ++i) {
                    if (!this.dataFilter.acceptDataObject(dObjArr[i])) continue;
                    b = true;
                    break;
                }
                this.setOkButtonEnabled(b);
            } else {
                this.setOkButtonEnabled(dObjArr != null);
            }
        } else if (this.dataFilter != null && this.getDataObject() != null) {
            this.setOkButtonEnabled(this.dataFilter.acceptDataObject(this.getDataObject()));
        } else {
            this.setOkButtonEnabled(this.getDataObject() != null);
        }
        this.initialized = true;
    }

    private static String findPathTo(Node rootNode, DataObject dobj) {
        DataObject o;
        Stack<DataObject> st = new Stack<DataObject>();
        for (o = dobj; o != null; o = o.getFolder()) {
            st.push(o);
        }
        Children children = rootNode.getChildren();
        Node n = null;
        while (n == null && !st.isEmpty()) {
            o = (DataObject)st.pop();
            n = children.findChild(o.getNodeDelegate().getName());
            if (n != null) continue;
            Node[] nodes = children.getNodes(true);
            for (int i = 0; i < nodes.length && n == null; ++i) {
                DataObject oo = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? DataObjectListView.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (oo == null || oo != o) continue;
                n = nodes[i];
            }
        }
        String path = DataObjectListView.getFileName(rootNode);
        if (n != null) {
            path = path + File.separator + DataObjectListView.getFileName(n);
            while (!st.isEmpty()) {
                Node nn = ((DataObject)st.pop()).getNodeDelegate();
                path = path + File.separator + DataObjectListView.getFileName(nn);
            }
        }
        return path;
    }

    private static String getFileName(Node n) {
        DataObject dObj = (DataObject)n.getCookie(DataObject.class);
        if (dObj != null) {
            FileObject pf = dObj.getPrimaryFile();
            if (pf.isRoot()) {
                return n.getDisplayName();
            }
            return pf.getNameExt();
        }
        return n.getDisplayName();
    }

    public void setDescription(String desc) {
        this.description = desc;
        this.getAccessibleContext().setAccessibleDescription(desc);
        if (this.chooser != null) {
            this.chooser.getAccessibleContext().setAccessibleDescription(desc);
        }
    }

    private Node findNode(String path) {
        String fileName;
        Node n = this.filteredRootNode;
        String p = path;
        int ind = p.indexOf(File.separatorChar);
        if (ind != -1) {
            fileName = p.substring(0, ind);
            p = p.substring(ind + 1);
        } else {
            fileName = p;
        }
        fileName = fileName.replace('#', File.separatorChar);
        block0: while (ind != -1) {
            Node[] nodes = n.getChildren().getNodes(true);
            ind = p.indexOf(File.separatorChar);
            if (ind != -1) {
                fileName = p.substring(0, ind);
                p = p.substring(ind + 1);
            } else {
                fileName = p;
            }
            fileName = fileName.replace('#', File.separatorChar);
            for (int i = 0; i < nodes.length; ++i) {
                if (!fileName.equals(DataObjectListView.getFileName(nodes[i]))) continue;
                n = nodes[i];
                continue block0;
            }
        }
        if (!fileName.equals(DataObjectListView.getFileName(n))) {
            return null;
        }
        return n;
    }

    private Node createNode(String path) {
        String fileName;
        Object n = this.filteredRootNode;
        Node parent = null;
        String p = path;
        int ind = p.indexOf(File.separatorChar);
        if (ind != -1) {
            fileName = p.substring(0, ind);
            p = p.substring(ind + 1);
        } else {
            fileName = p;
        }
        fileName = fileName.replace('#', File.separatorChar);
        block0: while (ind != -1) {
            Node[] nodes = n.getChildren().getNodes(true);
            parent = n;
            ind = p.indexOf(File.separatorChar);
            if (ind != -1) {
                fileName = p.substring(0, ind);
                p = p.substring(ind + 1);
            } else {
                fileName = p;
            }
            fileName = fileName.replace('#', File.separatorChar);
            for (int i = 0; i < nodes.length; ++i) {
                if (!fileName.equals(DataObjectListView.getFileName(nodes[i]))) continue;
                n = nodes[i];
                continue block0;
            }
        }
        if (!fileName.equals(DataObjectListView.getFileName(n))) {
            n = new FakeNode(Children.LEAF);
            n.setDisplayName(fileName.replace('#', File.separatorChar));
        }
        return n;
    }

    public DataObject getDataObject() {
        Node n;
        File f;
        DataObject retValue = null;
        if (!this.multiSelection && (f = this.chooser.getSelectedFile()) instanceof NodeFile && (n = ((NodeFile)f).getNode()) != null) {
            retValue = (DataObject)n.getCookie(DataObject.class);
        }
        return retValue;
    }

    public Node getNode() {
        File f;
        Node retValue = null;
        if (!this.multiSelection && (f = this.chooser.getSelectedFile()) instanceof NodeFile) {
            retValue = ((NodeFile)f).getNode();
        }
        return retValue;
    }

    public DataObject[] getDataObjects() {
        DataObject[] retValue = null;
        if (this.multiSelection) {
            File[] f = this.chooser.getSelectedFiles();
            retValue = new DataObject[f.length];
            for (int i = 0; i < f.length; ++i) {
                Node n;
                if (!(f[i] instanceof NodeFile) || (n = ((NodeFile)f[i]).getNode()) == null) continue;
                retValue[i] = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? DataObjectListView.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            }
        }
        return retValue;
    }

    public Node[] getNodes() {
        Node[] retValue = null;
        if (this.multiSelection) {
            File[] f = this.chooser.getSelectedFiles();
            retValue = new Node[f.length];
            for (int i = 0; i < f.length; ++i) {
                if (!(f[i] instanceof NodeFile)) continue;
                retValue[i] = ((NodeFile)f[i]).getNode();
            }
        }
        return retValue;
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.multiSelection) {
            return this.getDataObjects();
        }
        return this.getDataObject();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFilesChangedProperty".equals(e.getPropertyName()) || "SelectedFileChangedProperty".equals(e.getPropertyName())) {
            File[] selFiles = this.chooser.getSelectedFiles();
            if (selFiles == null) {
                return;
            }
            if (selFiles.length == 0 && this.chooser.getSelectedFile() != null) {
                selFiles = new File[]{this.chooser.getSelectedFile()};
            }
            Node[] nodes = new Node[selFiles.length];
            for (int i = 0; i < selFiles.length; ++i) {
                nodes[i] = selFiles[i] instanceof NodeFile ? ((NodeFile)selFiles[i]).getNode() : this.findNode(selFiles[i].getPath());
            }
            ArrayList<DataObject> dObjList = new ArrayList<DataObject>(selFiles.length);
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dObj;
                if (nodes[i] == null || (dObj = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? DataObjectListView.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                if (this.dataFilter != null) {
                    if (!this.dataFilter.acceptDataObject(dObj)) continue;
                    dObjList.add(dObj);
                    continue;
                }
                dObjList.add(dObj);
            }
            DataObject[] dObjArray = dObjList.toArray(new DataObject[dObjList.size()]);
            boolean enableOK = false;
            enableOK = dObjArray.length > 0;
            if (this.multiSelection) {
                this.myEditor.setValue(dObjArray);
            } else if (dObjArray.length > 0) {
                this.myEditor.setValue(dObjArray[0]);
            } else {
                this.myEditor.setValue(null);
            }
            this.setOkButtonEnabled(enableOK);
        } else if ("directoryChanged".equals(e.getPropertyName())) {
            // empty if block
        }
    }

    public class NodeFileChooser
    extends JFileChooser {
        NodeFileChooser(File currentDirectory, FileSystemView fsv) {
            super(currentDirectory, fsv);
        }

        protected void setup(FileSystemView view) {
            this.setFileView(new NodeFileView());
            super.setup(view);
        }

        public void setCurrentDirectory(File dir) {
            if (DataObjectListView.this != null && dir != null && !(dir instanceof NodeFile)) {
                Node n = DataObjectListView.this.findNode(dir.getPath());
                dir = new NodeFile(dir.getPath(), n);
            }
            super.setCurrentDirectory(dir);
        }
    }

    private class NodeFileSystemView
    extends FileSystemView {
        private final String newFolderString = UIManager.getString("FileChooser.other.newFolder");

        NodeFileSystemView() {
        }

        public boolean isRoot(File f) {
            return DataObjectListView.this.rootFile.equals(f);
        }

        public File createNewFolder(File containingDir) throws IOException {
            String path = containingDir.getPath() + File.separator + this.newFolderString;
            Node n = DataObjectListView.this.findNode(path);
            if (n != null) {
                NodeFile folder = new NodeFile(path, n);
                return folder;
            }
            Node parent = DataObjectListView.this.findNode(containingDir.getPath());
            if (parent == null) {
                return null;
            }
            DataObject dObj = (DataObject)parent.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectListView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dObj != null) {
                if (!(dObj instanceof DataFolder)) {
                    return null;
                }
            } else {
                return null;
            }
            DataFolder.create((DataFolder)((DataFolder)dObj), (String)this.newFolderString);
            n = DataObjectListView.this.createNode(path);
            NodeFile folder = new NodeFile(path, n);
            return folder;
        }

        public File createFileObject(File dir, String filename) {
            filename = filename.replace(File.separatorChar, '#');
            String path = dir.getPath() + File.separator + filename;
            Node n = DataObjectListView.this.findNode(path);
            if (n == null) {
                n = DataObjectListView.this.createNode(path);
            }
            NodeFile file = new NodeFile(path, n);
            return file;
        }

        public File createFileObject(String path) {
            Node n = DataObjectListView.this.findNode(path);
            if (n == null) {
                n = DataObjectListView.this.createNode(path);
            }
            NodeFile file = new NodeFile(path, n);
            return file;
        }

        public boolean isHiddenFile(File f) {
            return false;
        }

        public File[] getRoots() {
            return new NodeFile[]{(NodeFile)DataObjectListView.this.rootFile};
        }

        public File getHomeDirectory() {
            return DataObjectListView.this.rootFile;
        }

        public File[] getFiles(File dir, boolean useFileHiding) {
            if (dir instanceof NodeFile) {
                return dir.listFiles();
            }
            return super.getFiles(dir, useFileHiding);
        }

        public File getParentDirectory(File dir) {
            if (dir != null) {
                File f = this.createFileObject(dir.getPath());
                File parent = f.getParentFile();
                return parent;
            }
            return null;
        }

        public String getSystemDisplayName(File f) {
            return f.getName();
        }
    }

    private class NodeFileView
    extends FileView {
        NodeFileView() {
        }

        public String getName(File f) {
            if (f instanceof NodeFile) {
                return f.getName();
            }
            Node n = DataObjectListView.this.findNode(f.getPath());
            if (n != null) {
                return n.getDisplayName();
            }
            return null;
        }

        public Icon getIcon(File f) {
            if (f instanceof NodeFile) {
                return ((NodeFile)f).getIcon();
            }
            Node n = DataObjectListView.this.findNode(f.getPath());
            if (n != null) {
                ImageIcon icon = new ImageIcon(n.getIcon(1));
                return icon;
            }
            return null;
        }
    }

    private class NodeFile
    extends File {
        private Node n;

        NodeFile(String path, Node n) {
            super(path);
            this.n = n;
        }

        NodeFile(File parent, String child, Node n) {
            super(parent, child);
            this.n = n;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public boolean renameTo(File dest) {
            DataObject dObj = (DataObject)this.n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectListView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dObj != null) {
                try {
                    dObj.rename(dest.getName());
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    return false;
                }
                return true;
            }
            return false;
        }

        public File[] listFiles() {
            Node[] nodes = this.n.getChildren().getNodes(true);
            File[] files = new NodeFile[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                String name = DataObjectListView.getFileName(nodes[i]);
                name = name.replace(File.separatorChar, '#');
                files[i] = new NodeFile(this.getPath() + File.separator + name, nodes[i]);
            }
            return files;
        }

        public String getName() {
            if (this.n != null) {
                return this.n.getDisplayName();
            }
            return super.getName();
        }

        public String getParent() {
            String p = super.getParent();
            return p;
        }

        public File getParentFile() {
            String p = this.getParent();
            if (p == null) {
                return null;
            }
            if (this.n == null) {
                return null;
            }
            Node parent = DataObjectListView.this.findNode(p);
            if (parent == null) {
                return null;
            }
            return new NodeFile(p, parent);
        }

        public boolean exists() {
            Node n = DataObjectListView.this.findNode(this.getPath());
            if (n != null) {
                return !(n instanceof FakeNode);
            }
            return false;
        }

        public boolean isAbsolute() {
            String p = this.getPath();
            int ind = p.indexOf(File.separatorChar);
            if (ind != -1) {
                p = p.substring(0, ind);
            }
            return (p = p.replace('#', File.separatorChar)).equals(DataObjectListView.getFileName(DataObjectListView.this.filteredRootNode));
        }

        public boolean isDirectory() {
            if (this.n == null) {
                return false;
            }
            DataObject dObj = (DataObject)this.n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectListView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dObj != null) {
                return dObj instanceof DataFolder;
            }
            return true;
        }

        public boolean isFile() {
            if (this.n == null) {
                return true;
            }
            DataObject dObj = (DataObject)this.n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObjectListView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dObj != null) {
                return !(dObj instanceof DataFolder);
            }
            return false;
        }

        public Icon getIcon() {
            ImageIcon icon = new ImageIcon(this.n.getIcon(1));
            return icon;
        }

        public String getAbsolutePath() {
            return this.getPath();
        }

        public File getAbsoluteFile() {
            return new NodeFile(this.getAbsolutePath(), this.n);
        }

        public String getCanonicalPath() throws IOException {
            return this.getPath();
        }

        public File getCanonicalFile() throws IOException {
            return new NodeFile(this.getCanonicalPath(), this.n);
        }

        public Node getNode() {
            return this.n;
        }
    }

    private static class FakeNode
    extends AbstractNode {
        public FakeNode(Children children) {
            super(children);
        }
    }
}

