/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.settings;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import javax.swing.KeyStroke;

public final class MultiKeyBinding {
    private List keyStrokeList;
    private String actionName;

    public MultiKeyBinding(KeyStroke[] keyStrokes, String actionName) {
        if (keyStrokes == null) {
            throw new NullPointerException("keyStrokes cannot be null");
        }
        if (actionName == null) {
            throw new NullPointerException("actionName cannot be null");
        }
        this.keyStrokeList = new UnmodifiableArrayList(keyStrokes);
        this.actionName = actionName;
    }

    public MultiKeyBinding(KeyStroke keyStroke, String actionName) {
        this(new KeyStroke[]{keyStroke}, actionName);
        if (keyStroke == null) {
            throw new NullPointerException("keyStroke cannot be null");
        }
    }

    public KeyStroke getKeyStroke(int index) {
        return (KeyStroke)this.keyStrokeList.get(index);
    }

    public int getKeyStrokeCount() {
        return this.keyStrokeList.size();
    }

    public List getKeyStrokeList() {
        return this.keyStrokeList;
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean equals(Object o) {
        if (o instanceof MultiKeyBinding) {
            MultiKeyBinding kb = (MultiKeyBinding)o;
            if (this.actionName == null ? kb.actionName != null : !this.actionName.equals(kb.actionName)) {
                return false;
            }
            return ((Object)this.keyStrokeList).equals(kb.keyStrokeList);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.getKeyStrokeCount(); ++i) {
            result = 37 * result + this.getKeyStroke(i).hashCode();
        }
        if (this.actionName != null) {
            result = 37 * result + this.actionName.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("keys(");
        for (int i = 0; i < this.keyStrokeList.size(); ++i) {
            sb.append(this.getKeyStroke(i));
        }
        sb.append("), actionName=");
        sb.append(this.actionName);
        return sb.toString();
    }

    private static final class UnmodifiableArrayList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        private Object[] array;

        UnmodifiableArrayList(Object[] array) {
            if (array == null) {
                throw new NullPointerException();
            }
            this.array = array;
        }

        public int size() {
            return this.array.length;
        }

        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        public Object get(int index) {
            return this.array[index];
        }

        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.array.length; ++i) {
                    if (this.array[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.array.length; ++i) {
                    if (!o.equals(this.array[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        public boolean equals(Object o) {
            return o instanceof UnmodifiableArrayList ? Arrays.equals(this.array, ((UnmodifiableArrayList)o).array) : super.equals(o);
        }
    }
}

