/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.internalapi.GuardedQuery;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.GeneralException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class TryWrapper {
    private Element elementToReplace;
    private Element replaceParent;
    private JavaModelPackage model;
    private List tryBody;

    public TryWrapper(FileObject fo, int from, int to) {
        this(JavaModelUtil.getSelectedStatements(JavaMetamodel.getManager().getResource(fo), from, to));
    }

    public TryWrapper(List statements) {
        if (statements == null) {
            throw new GeneralException(NbBundle.getMessage((Class)TryWrapper.class, (String)"MSG_CannotEncapsulate"));
        }
        this.tryBody = new ArrayList(statements);
        this.elementToReplace = (Element)this.tryBody.get(0);
        if (GuardedQuery.isSectionGuarded(this.elementToReplace.getResource(), JavaMetamodel.getManager().getElementPosition(this.elementToReplace))) {
            throw new GeneralException(NbBundle.getMessage((Class)TryWrapper.class, (String)"MSG_CannotEncapsulateGuardedBlock"));
        }
        this.replaceParent = (Element)this.elementToReplace.refImmediateComposite();
        this.model = (JavaModelPackage)this.elementToReplace.refOutermostPackage();
    }

    private void check(List body, List declaredVariables) {
        Iterator it = body.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof LocalVarDeclaration)) continue;
            LocalVarDeclaration decl = (LocalVarDeclaration)o;
            declaredVariables.addAll(decl.getVariables());
        }
    }

    private ExpressionStatement createAssignment(LocalVariable var) {
        VariableAccess access = this.model.getVariableAccess().createVariableAccess(var.getName(), null, false);
        InitialValue initValue = var.getInitialValue();
        var.setInitialValue(null);
        Assignment a = this.model.getAssignment().createAssignment((PrimaryExpression)access, (Operator)OperatorEnum.ASSIGN, (Expression)initValue);
        ExpressionStatement s = this.model.getExpressionStatement().createExpressionStatement((Expression)a);
        return s;
    }

    private Set getUsedVariables(List decl, List statements) {
        LinkedHashSet<LocalVariable> used = new LinkedHashSet<LocalVariable>();
        LinkedList l = new LinkedList();
        l.addAll(statements);
        while (!l.isEmpty()) {
            Element e = (Element)l.removeFirst();
            if (e instanceof VariableAccess) {
                Iterator i = decl.iterator();
                while (i.hasNext()) {
                    LocalVariable var = (LocalVariable)i.next();
                    if (!((VariableAccess)e).getName().equals(var.getName())) continue;
                    used.add(var);
                }
            }
            l.addAll(e.getChildren());
        }
        return used;
    }

    public TryStatement wrap() {
        ArrayList decl = new ArrayList();
        this.check(this.tryBody, decl);
        List catches = this.createCatches(this.getExceptions(this.tryBody));
        StatementBlock finallyBlock = !catches.isEmpty() ? null : this.model.getStatementBlock().createStatementBlock();
        TryStatement tryStatement = this.model.getTryStatement().createTryStatement();
        tryStatement.getCatches().addAll(catches);
        tryStatement.setFinalizer(finallyBlock);
        if (this.replaceParent instanceof Feature) {
            ArrayList<TryStatement> l = new ArrayList<TryStatement>();
            l.add(tryStatement);
            this.replaceParent.replaceChild(this.elementToReplace, (Element)this.model.getStatementBlock().createStatementBlock(l));
            StatementBlock tryBlock = this.model.getStatementBlock().createStatementBlock(this.tryBody);
            tryStatement.setBody(tryBlock);
        } else {
            ArrayList ll = new ArrayList();
            ll.addAll(this.replaceParent.getChildren());
            ll.remove(this.elementToReplace);
            this.replaceParent.replaceChild(this.elementToReplace, (Element)tryStatement);
            ArrayList tryBody2 = new ArrayList(this.tryBody);
            this.tryBody.remove(this.elementToReplace);
            Iterator i = this.tryBody.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                this.replaceParent.replaceChild(e, null);
                ll.remove(e);
            }
            StatementBlock tryBlock = this.model.getStatementBlock().createStatementBlock(tryBody2);
            tryStatement.setBody(tryBlock);
            Set l = this.getUsedVariables(decl, ll);
            List body = this.replaceParent instanceof StatementBlock ? ((StatementBlock)this.replaceParent).getStatements() : Collections.singletonList(tryStatement);
            int index = body.indexOf(tryStatement);
            body.addAll(index, this.separateDeclsAndInits(l, tryBlock));
        }
        return tryStatement;
    }

    private List separateDeclsAndInits(Set usedVars, StatementBlock addInitializersTo) {
        ArrayList<LocalVarDeclaration> decl = new ArrayList<LocalVarDeclaration>();
        Iterator varsIt = usedVars.iterator();
        HashSet<LocalVarDeclaration> separated = new HashSet<LocalVarDeclaration>(2);
        List statements = addInitializersTo.getStatements();
        while (varsIt.hasNext()) {
            LocalVariable var = (LocalVariable)varsIt.next();
            LocalVarDeclaration parent = (LocalVarDeclaration)var.refImmediateComposite();
            if (separated.contains(parent)) continue;
            separated.add(parent);
            LocalVarDeclaration lvdCopy = (LocalVarDeclaration)parent.duplicate();
            LocalVariable[] vars = lvdCopy.getVariables().toArray(new LocalVariable[0]);
            boolean removeInitVals = false;
            for (int varInDecl = 0; varInDecl < vars.length; ++varInDecl) {
                Iterator varsIt2 = usedVars.iterator();
                while (varsIt2.hasNext()) {
                    LocalVariable lv_used = (LocalVariable)varsIt2.next();
                    if (!lv_used.getName().equals(vars[varInDecl].getName())) continue;
                    removeInitVals = true;
                    break;
                }
                if (!removeInitVals) continue;
                ArrayList<ExpressionStatement> newAssignments = new ArrayList<ExpressionStatement>();
                int parentIndex = statements.indexOf(parent);
                for (int j = 0; j < vars.length; ++j) {
                    if (vars[j].getInitialValue() == null) continue;
                    newAssignments.add(this.createAssignment(vars[j]));
                    vars[j].setInitialValue(null);
                }
                statements.addAll(parentIndex, newAssignments);
                break;
            }
            if (!removeInitVals) continue;
            decl.add(lvdCopy);
            parent.refDelete();
        }
        return decl;
    }

    private List createCatches(Collection ex) {
        ArrayList<Catch> catches = new ArrayList<Catch>();
        String parName = "ex";
        Iterator i = ex.iterator();
        while (i.hasNext()) {
            MultipartId e = (MultipartId)i.next();
            Parameter par = this.model.getParameter().createParameter(parName, null, false, (TypeReference)e, 0, false);
            MultipartId var = this.model.getMultipartId().createMultipartId(parName, null, null);
            MethodInvocation m = this.model.getMethodInvocation().createMethodInvocation("printStackTrace", Collections.EMPTY_LIST, (PrimaryExpression)var, false);
            ExpressionStatement st = this.model.getExpressionStatement().createExpressionStatement((Expression)m);
            StatementBlock block = this.model.getStatementBlock().createStatementBlock(Collections.singletonList(st));
            catches.add(this.model.getCatch().createCatch(par, block));
        }
        return catches;
    }

    private Collection getExceptions(List b) {
        JavaClass c;
        Set exSet = JavaModelUtil.getExceptionsFromStatements(b);
        TreeMap<Integer, JavaClass> exMap = new TreeMap<Integer, JavaClass>();
        ArrayList<MultipartId> result = new ArrayList<MultipartId>();
        int index = 0;
        int exs = exSet.size();
        Iterator<Object> i = exSet.iterator();
        while (i.hasNext()) {
            c = (JavaClass)i.next();
            int id = -(this.getExceptionLevel(c) * exs + index);
            exMap.put(new Integer(id), c);
            ++index;
        }
        Collection exceptions = exMap.values();
        i = exceptions.iterator();
        while (i.hasNext()) {
            c = (JavaClass)i.next();
            result.add(JavaModelUtil.resolveImportsForClass(this.replaceParent, c));
        }
        return result;
    }

    private int getExceptionLevel(JavaClass ex) {
        if (ex.getName().equals("java.lang.Object")) {
            return 0;
        }
        if (ex.getName().equals("java.lang.Throwable")) {
            return 0;
        }
        return this.getExceptionLevel(ex.getSuperClass()) + 1;
    }
}

