/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.util.NbBundle;

public class ProgressDisplayer
implements ProgressListener,
PropertyChangeListener {
    private ClassPathImplementation cp;
    private JMManager model;
    private boolean dirty = false;
    private ProgressContributor progressContributor;
    private ProgressContributor startFake;
    private ProgressContributor endFake;
    private AggregateProgressHandle globalProgress;
    private static ProgressDisplayer instance = null;

    private ProgressDisplayer(JMManager model) {
        this.model = model;
        this.cp = model.getMergedClassPathImpl();
        this.cp.addPropertyChangeListener((PropertyChangeListener)this);
        this.model.getProgressSupport().addProgressListener(this);
        this.globalProgress = AggregateProgressFactory.createHandle((String)NbBundle.getMessage((Class)ProgressDisplayer.class, (String)"TXT_ApplyingPathsTitle"), (ProgressContributor[])new ProgressContributor[0], null, null);
        this.globalProgress.start();
        this.startFake = AggregateProgressFactory.createProgressContributor((String)"startFake");
        this.endFake = AggregateProgressFactory.createProgressContributor((String)"endFake");
        this.globalProgress.addContributor(this.startFake);
        this.globalProgress.addContributor(this.endFake);
        this.startFake.start(1);
        this.endFake.start(1);
    }

    public void start(ProgressEvent event) {
        int ec = event.getCount();
        this.progressContributor = AggregateProgressFactory.createProgressContributor((String)Integer.toString(event.hashCode()));
        this.globalProgress.addContributor(this.progressContributor);
        this.progressContributor.start(ec);
        this.startFake.finish();
    }

    public void step(ProgressEvent event) {
        this.progressContributor.progress(event.getCount());
    }

    public void stop(ProgressEvent event) {
        if (JMManager.SCAN_DEBUG) {
            System.err.println("ProgressDisplayer: stop1");
        }
        if (this.getDirty()) {
            if (JMManager.SCAN_DEBUG) {
                System.err.println("ProgressDisplayer: stop2 - dirty");
            }
            this.progressContributor.finish();
            this.startResolution();
        } else {
            if (JMManager.SCAN_DEBUG) {
                System.err.println("ProgressDisplayer: stop3");
            }
            this.endFake.finish();
            this.globalProgress.finish();
            this.model.getProgressSupport().removeProgressListener(this);
            this.cp.removePropertyChangeListener((PropertyChangeListener)this);
            instance = null;
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if ("unresolvedRoots".equals(evt.getPropertyName())) {
            if (JMManager.SCAN_DEBUG) {
                System.err.println("ProgressDisplayer: globalpath changed");
            }
            this.dirty = true;
        }
    }

    private synchronized boolean getDirty() {
        boolean res = this.dirty;
        this.dirty = false;
        return res;
    }

    private void startResolution() {
        if (JMManager.SCAN_DEBUG) {
            System.err.println("ProgressDisplayer: startResolution");
        }
        this.model.startResolution();
    }

    private String formatMessage(String message, String parameter) {
        return MessageFormat.format(message, parameter);
    }

    public void updatePackage(String packageName) {
        this.progressContributor.progress(this.formatMessage(NbBundle.getMessage((Class)ProgressDisplayer.class, (String)"MSG_ScanningPackage"), packageName));
    }

    public static ProgressDisplayer getVisibleProgressDisplayer() {
        return instance;
    }

    public static boolean showProgress(JMManager model) {
        if (JMManager.SCAN_DEBUG) {
            System.err.println("ProgressDisplayer: openProgressDialog");
        }
        instance = new ProgressDisplayer(model);
        instance.startResolution();
        return true;
    }
}

