/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.patterns;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class DTOHelper {
    private Project project;
    private org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar;
    private Entity entity;
    private JavaClass classElm;
    private EnterpriseBeans beans;
    private FileObject fo;

    public DTOHelper(Feature feature) {
        this.classElm = JMIUtils.getDeclaringClass((Feature)feature);
        DataObject dObj = JavaMetamodel.getManager().getDataObject(feature.getResource());
        assert (dObj != null) : "Can not find data object for class";
        this.fo = dObj.getPrimaryFile();
        this.project = FileOwnerQuery.getOwner((FileObject)this.fo);
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.fo);
        DDProvider provider = DDProvider.getDefault();
        try {
            this.ejbJar = provider.getMergedDDRoot(ejbModule.getMetadataUnit());
            this.beans = this.ejbJar.getEnterpriseBeans();
            this.entity = (Entity)this.beans.findBeanByName("Entity", "EjbClass", this.classElm.getName());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public CmrField[] getCmrFields() {
        ArrayList<CmrField> cmrFields = new ArrayList<CmrField>();
        EjbRelation[] r = this.getRelation();
        if (r != null) {
            boolean j = false;
            for (int i = 0; i < r.length; ++i) {
                EjbRelationshipRole role = r[i].getEjbRelationshipRole();
                if (this.isUseEjb(role)) {
                    cmrFields.add(role.getCmrField());
                }
                if (!this.isUseEjb(role = r[i].getEjbRelationshipRole2())) continue;
                cmrFields.add(role.getCmrField());
            }
        }
        return (CmrField[])cmrFields.toArray();
    }

    private EjbRelation[] getRelation() {
        Relationships relation = this.ejbJar.getSingleRelationships();
        return relation != null ? relation.getEjbRelation() : null;
    }

    public boolean isMultiple(CmrField cmrField) {
        boolean isMultiple = false;
        EjbRelation[] r = this.getRelation();
        if (r != null) {
            for (int i = 0; i < r.length; ++i) {
                EjbRelationshipRole role = r[i].getEjbRelationshipRole();
                if (cmrField == role.getCmrField()) {
                    if ("Many".equals(r[i].getEjbRelationshipRole2().getMultiplicity())) {
                        isMultiple = true;
                    }
                }
                if (cmrField != (role = r[i].getEjbRelationshipRole2()).getCmrField()) continue;
                if (!"Many".equals(r[i].getEjbRelationshipRole().getMultiplicity())) continue;
                isMultiple = true;
            }
        }
        return isMultiple;
    }

    public String getOppositeFieldType(CmrField cmrField) {
        String cmrFieldType2 = "";
        EjbRelation[] r = this.getRelation();
        if (r != null) {
            for (int i = 0; i < r.length; ++i) {
                EjbRelationshipRole role = r[i].getEjbRelationshipRole();
                if (cmrField == role.getCmrField()) {
                    String ejbName = r[i].getEjbRelationshipRole2().getRelationshipRoleSource().getEjbName();
                    cmrFieldType2 = this.findLocalIntNameByEntityName(ejbName);
                    break;
                }
                role = r[i].getEjbRelationshipRole2();
                if (cmrField != role.getCmrField()) continue;
                String ejbName = r[i].getEjbRelationshipRole().getRelationshipRoleSource().getEjbName();
                cmrFieldType2 = this.findLocalIntNameByEntityName(ejbName);
                break;
            }
        }
        return cmrFieldType2;
    }

    public String findLocalIntNameByEntityName(String entityName) {
        Entity[] ents = this.beans.getEntity();
        String localInterfaceName = "";
        for (int i = 0; i < ents.length; ++i) {
            if (!entityName.equals(ents[i].getEjbName())) continue;
            localInterfaceName = ents[i].getLocal();
            break;
        }
        return localInterfaceName;
    }

    public String findEntityNameByLocalInt(String interf) {
        Entity[] ents = this.beans.getEntity();
        String ejbName = "";
        for (int i = 0; i < ents.length; ++i) {
            if (!interf.equals(ents[i].getLocal())) continue;
            ejbName = ents[i].getEjbName();
            break;
        }
        return ejbName;
    }

    private boolean isUseEjb(EjbRelationshipRole role) {
        return role != null && role.getRelationshipRoleSource() != null && role.getRelationshipRoleSource().getEjbName().equals(this.getEntityName());
    }

    public CmpField[] getCmpFields() {
        return this.entity.getCmpField();
    }

    public String getFieldType(String fieldName) {
        String returnType = "";
        returnType = EntityMethodController.getGetterMethod(this.classElm, fieldName).getType().getName();
        return returnType;
    }

    public String getEntityName() {
        return this.entity.getEjbName();
    }

    public String getLocalName() {
        return this.entity.getLocal();
    }

    public String getFullName() {
        return this.classElm.getName();
    }

    public String getPackage() {
        return this.getFullName().substring(0, this.getFullName().lastIndexOf(46));
    }

    public Project getProject() {
        return this.project;
    }

    public SourceGroup getSourceGroup() {
        SourceGroup entityFolder = null;
        SourceGroup[] folders = Util.getJavaSourceGroups((Project)this.project);
        for (int i = 0; i < folders.length; ++i) {
            if (!folders[i].contains(this.fo)) continue;
            entityFolder = folders[i];
        }
        return entityFolder;
    }
}

