/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ejbcore.api.ui.CallEjb;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EjbReferencesTableModel
extends InnerTableModel {
    private XmlMultiViewDataObject dataObject;
    Ejb ejb;
    private static final String[] COLUMN_NAMES = new String[]{NbBundle.getBundle((Class)EjbReferencesTableModel.class).getString("LBL_ReferenceName"), NbBundle.getBundle((Class)EjbReferencesTableModel.class).getString("LBL_LinkedEjb"), NbBundle.getBundle((Class)EjbReferencesTableModel.class).getString("LBL_Interface"), NbBundle.getBundle((Class)EjbReferencesTableModel.class).getString("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{170, 260, 70, 250};

    public EjbReferencesTableModel(XmlMultiViewDataObject dataObject, Ejb ejb) {
        super(((EjbJarMultiViewDataObject)dataObject).getModelSynchronizer(), COLUMN_NAMES, COLUMN_WIDTHS);
        this.dataObject = dataObject;
        this.ejb = ejb;
    }

    public int getRowCount() {
        return this.ejb.getEjbLocalRef().length + this.ejb.getEjbRef().length;
    }

    public boolean isCellEditable(int row, int column) {
        return this.isColumnEditable(column);
    }

    public int addRow() {
        JavaClass beanClass = (JavaClass)JMIUtils.resolveType((String)this.ejb.getEjbClass());
        if (CallEjb.showCallEjbDialog((JavaClass)beanClass, (String)NbBundle.getMessage((Class)EjbReferencesTableModel.class, (String)"LBL_AddEjbReference"))) {
            this.modelUpdatedFromUI();
        }
        return -1;
    }

    public void removeRow(int selectedRow) {
        ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage((Class)EjbReferencesTableModel.class, (String)"LBL_RemoveEjbRefWarning"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            EjbLocalRef localRef = this.ejb.getEjbLocalRef(selectedRow);
            if (localRef != null) {
                this.ejb.removeEjbLocalRef(localRef);
            } else {
                EjbRef ref = this.ejb.getEjbRef(selectedRow);
                if (ref != null) {
                    this.ejb.removeEjbRef(ref);
                }
            }
            this.modelUpdatedFromUI();
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int n = this.ejb.getEjbLocalRef().length;
        if (rowIndex < n) {
            EjbLocalRef ref = this.ejb.getEjbLocalRef(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ref.getEjbRefName();
                }
                case 1: {
                    return ref.getEjbLink();
                }
                case 2: {
                    return "local";
                }
                case 3: {
                    return ref.getDefaultDescription();
                }
            }
        } else {
            EjbRef ref = this.ejb.getEjbRef(rowIndex - n);
            switch (columnIndex) {
                case 0: {
                    return ref.getEjbRefName();
                }
                case 1: {
                    return ref.getEjbLink();
                }
                case 2: {
                    return "remote";
                }
                case 3: {
                    return ref.getDefaultDescription();
                }
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isColumnEditable(columnIndex)) {
            return;
        }
        EjbRef ref = this.ejb.getEjbRef(rowIndex);
        if (ref != null) {
            ref.setDescription((String)aValue);
        } else {
            EjbLocalRef localRef = this.ejb.getEjbLocalRef(rowIndex);
            if (localRef != null) {
                localRef.setDescription((String)aValue);
            }
        }
        this.modelUpdatedFromUI();
    }

    private boolean isColumnEditable(int columnIndex) {
        return columnIndex == 3;
    }
}

