/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class StartActionProvider
extends ActionsProvider {
    private static final boolean startVerbose;
    private static int jdiTrace;
    private JPDADebuggerImpl debuggerImpl;
    private ContextProvider lookupProvider;

    public StartActionProvider(ContextProvider lookupProvider) {
        this.debuggerImpl = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = lookupProvider;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_START);
    }

    public void doAction(Object action) {
        JPDADebuggerImpl debugger;
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.doAction ()");
        }
        if ((debugger = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class))) != null && debugger.getVirtualMachine() != null) {
            return;
        }
        this.debuggerImpl.setStarting();
        AbstractDICookie cookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        this.doStartDebugger(cookie);
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.doAction () setStarting");
        }
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.doAction () end");
        }
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        JPDADebuggerImpl debugger;
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.postAction ()");
        }
        if ((debugger = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class))) != null && debugger.getVirtualMachine() != null) {
            return;
        }
        final AbstractDICookie cookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.postAction () setStarting");
        }
        this.debuggerImpl.setStarting();
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.postAction () setStarting end");
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StartActionProvider.this.debuggerImpl.setStartingThread(Thread.currentThread());
                try {
                    StartActionProvider.this.doStartDebugger(cookie);
                }
                finally {
                    StartActionProvider.this.debuggerImpl.unsetStartingThread();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDebugger(AbstractDICookie cookie) {
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.doAction ().thread");
        }
        try {
            VirtualMachine virtualMachine = cookie.getVirtualMachine();
            virtualMachine.setDebugTraceMode(jdiTrace);
            Object startLock = new Object();
            Operator o = this.createOperator(virtualMachine, startLock);
            Object object = startLock;
            synchronized (object) {
                if (startVerbose) {
                    System.out.println("\nS StartActionProvider.doAction () - starting operator thread");
                }
                o.start();
                if (cookie instanceof ListeningDICookie) {
                    startLock.wait(1500L);
                }
            }
            this.debuggerImpl.setRunning(virtualMachine, o);
            if (startVerbose) {
                System.out.println("\nS StartActionProvider.doAction ().thread end: success");
            }
        }
        catch (IOException ioex) {
            if (startVerbose) {
                System.out.println("\nS StartActionProvider.doAction ().thread end: exception " + ioex);
            }
            this.debuggerImpl.setException(ioex);
            ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
        }
        catch (Exception ex) {
            if (startVerbose) {
                System.out.println("\nS StartActionProvider.doAction ().thread end: exception " + ex);
            }
            this.debuggerImpl.setException(ex);
            ErrorManager.getDefault().notify((Throwable)ex);
            ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
        }
    }

    public boolean isEnabled(Object action) {
        return true;
    }

    public void addActionsProviderListener(ActionsProviderListener l) {
    }

    public void removeActionsProviderListener(ActionsProviderListener l) {
    }

    private Operator createOperator(VirtualMachine virtualMachine, final Object startLock) {
        return new Operator(virtualMachine, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean exec(Event event) {
                Object object = startLock;
                synchronized (object) {
                    startLock.notify();
                }
                return false;
            }
        }, new Runnable(){

            public void run() {
                ((Session)StartActionProvider.this.lookupProvider.lookupFirst(null, class$org$netbeans$api$debugger$Session == null ? (class$org$netbeans$api$debugger$Session = StartActionProvider.class$("org.netbeans.api.debugger.Session")) : class$org$netbeans$api$debugger$Session)).kill();
            }
        }, this.debuggerImpl.LOCK);
    }

    static {
        boolean bl = startVerbose = System.getProperty("netbeans.debugger.start") != null;
        if (System.getProperty("netbeans.debugger.jditrace") != null) {
            try {
                jdiTrace = Integer.parseInt(System.getProperty("netbeans.debugger.jditrace"));
            }
            catch (NumberFormatException ex) {
                jdiTrace = 0;
            }
        } else {
            jdiTrace = 0;
        }
    }
}

