/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsTableModel
implements TableModel,
Constants,
PropertyChangeListener {
    private Vector listeners = new Vector();
    private static final Integer SD = new Integer(4);

    private static String loc(String key) {
        return NbBundle.getBundle((Class)SessionsTableModel.class).getString(key);
    }

    public SessionsTableModel(ContextProvider contextProvider) {
        JPDADebugger debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session) {
            if (columnID.equals("SessionState")) {
                return SessionsTableModel.getSessionState((Session)row);
            }
            if (columnID.equals("SessionLanguage")) {
                return row;
            }
            if (columnID.equals("SessionHostName")) {
                return ((Session)row).getLocationName();
            }
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session) {
            if (columnID.equals("SessionState")) {
                return true;
            }
            if (columnID.equals("SessionLanguage")) {
                return false;
            }
            if (columnID.equals("SessionHostName")) {
                return true;
            }
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(row);
    }

    private static String getSessionState(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return SessionsTableModel.loc("MSG_Session_State_Starting");
        }
        JPDADebugger d = (JPDADebugger)e.lookupFirst(null, JPDADebugger.class);
        switch (d.getState()) {
            case 4: {
                return SessionsTableModel.loc("MSG_Session_State_Disconnected");
            }
            case 2: {
                return SessionsTableModel.loc("MSG_Session_State_Running");
            }
            case 1: {
                return SessionsTableModel.loc("MSG_Session_State_Starting");
            }
            case 3: {
                return SessionsTableModel.loc("MSG_Session_State_Stopped");
            }
        }
        return null;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.fireTreeChanged();
        if (e.getNewValue().equals(SD)) {
            ((JPDADebugger)e.getSource()).removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

