/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PersistenceUnitWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private Project project;
    private PersistenceUnitWizardDescriptor descriptor;

    public static PersistenceUnitWizard create() {
        return new PersistenceUnitWizard();
    }

    public String name() {
        return NbBundle.getMessage(PersistenceUnitWizard.class, (String)"LBL_WizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.project = Templates.getProject((WizardDescriptor)wizard);
        this.descriptor = new PersistenceUnitWizardDescriptor(this.project);
        this.panels = new WizardDescriptor.Panel[]{this.descriptor};
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(PersistenceUnitWizard.class, (String)"Templates/Persistence/PersistenceUnit"));
        Util.mergeSteps(wizard, this.panels, null);
    }

    public Set instantiate() throws IOException {
        PersistenceUnit punit = null;
        if (this.descriptor.isContainerManaged()) {
            punit = new PersistenceUnit();
            if (this.descriptor.isJTA()) {
                punit.setJtaDataSource(this.descriptor.getDatasource());
            } else {
                punit.setNonJtaDataSource(this.descriptor.getDatasource());
                punit.setTransactionType("RESOURCE_LOCAL");
            }
            if (this.descriptor.isNonDefaultProviderEnabled()) {
                punit.setProvider(this.descriptor.getNonDefaultProvider());
            }
        } else {
            punit = ProviderUtil.buildPersistenceUnit(this.descriptor.getPersistenceUnitName(), this.descriptor.getSelectedProvider(), this.descriptor.getPersistenceConnection());
            punit.setTransactionType("RESOURCE_LOCAL");
            if (this.descriptor.getPersistenceLibrary() != null) {
                Util.addLibraryToProject(this.project, this.descriptor.getPersistenceLibrary());
            }
        }
        punit.setName(this.descriptor.getPersistenceUnitName());
        ProviderUtil.setTableGeneration(punit, this.descriptor.getTableGeneration(), this.project);
        PUDataObject pud = ProviderUtil.getPUDataObject(this.project);
        pud.addPersistenceUnit(punit);
        pud.save();
        return Collections.singleton(pud.getPrimaryFile());
    }

    private PersistenceUnit constructApplicationManagedPU() {
        Provider provider = null;
        provider = this.descriptor.getPersistenceLibrary() == null ? ProviderUtil.getProvider(this.descriptor.getNonDefaultProvider(), this.project) : ProviderUtil.getProvider(this.descriptor.getPersistenceLibrary());
        return ProviderUtil.buildPersistenceUnit(this.descriptor.getPersistenceUnitName(), provider, this.descriptor.getPersistenceConnection());
    }
}

