/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;

class FCLSupport {
    public static final int DATA_CREATED = 0;
    public static final int FOLDER_CREATED = 1;
    public static final int FILE_CHANGED = 2;
    public static final int FILE_DELETED = 3;
    public static final int FILE_RENAMED = 4;
    public static final int ATTR_CHANGED = 5;
    private ListenerList listeners;

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(FileChangeListener.class);
        }
        this.listeners.add(fcl);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fe, int operation) {
        Object[] fcls;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            fcls = this.listeners.getAllListeners();
        }
        for (int i = 0; i < fcls.length; ++i) {
            if (!(fcls[i] instanceof FileChangeListener)) continue;
            FCLSupport.dispatchEvent((FileChangeListener)fcls[i], fe, operation);
        }
    }

    static final void dispatchEvent(FileChangeListener fcl, FileEvent fe, int operation) {
        switch (operation) {
            case 0: {
                fcl.fileDataCreated(fe);
                break;
            }
            case 1: {
                fcl.fileFolderCreated(fe);
                break;
            }
            case 2: {
                fcl.fileChanged(fe);
                break;
            }
            case 3: {
                fcl.fileDeleted(fe);
                break;
            }
            case 4: {
                fcl.fileRenamed((FileRenameEvent)fe);
                break;
            }
            case 5: {
                fcl.fileAttributeChanged((FileAttributeEvent)fe);
            }
        }
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.getAllListeners().length != 0;
    }
}

