/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.ejb;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbAnnotationListener;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.j2ee.metadata.MergedProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.NNListener;
import org.netbeans.modules.j2ee.metadata.NNMDRListener;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DDProvider {
    private static final String EJB_21_DOCTYPE = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
    private static final String EJB_20_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    private static final String EJB_11_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    private static final DDProvider ddProvider = new DDProvider();
    private Map ddMap = new HashMap(5);
    private Map<MetadataUnit, EjbJar> annotationDDMap = new WeakHashMap<MetadataUnit, EjbJar>(5);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public EjbJar getMergedDDRoot(MetadataUnit mu) throws IOException {
        if (mu == null) {
            return null;
        }
        EjbJar xmlRoot = this.getDDRoot(mu.getDeploymentDescriptor());
        if (xmlRoot != null && !xmlRoot.getVersion().equals(new BigDecimal("3.0"))) {
            return xmlRoot;
        }
        EjbJar annotationRoot = this.getAnnotationDDRoot(mu);
        if (xmlRoot instanceof EjbJarProxy) {
            xmlRoot = ((EjbJarProxy)xmlRoot).getOriginal();
        }
        if (annotationRoot instanceof EjbJarProxy) {
            annotationRoot = ((EjbJarProxy)annotationRoot).getOriginal();
        }
        return (EjbJar)MergedProvider.getDefault().getRoot((BaseBean)annotationRoot, (BaseBean)xmlRoot);
    }

    private synchronized EjbJar getAnnotationDDRoot(MetadataUnit mu) throws IOException {
        if (mu == null) {
            return null;
        }
        EjbJar ejbJar = this.annotationDDMap.get(mu);
        if (ejbJar != null) {
            return ejbJar;
        }
        ejbJar = new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_0.EjbJar();
        this.annotationDDMap.put(mu, ejbJar);
        NNMDRListener.getDefault().addAnnotationListener((NNListener)new EjbAnnotationListener(ejbJar, mu.getClassPath()));
        return ejbJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EjbJar> getRoots() {
        DDProvider dDProvider = this;
        synchronized (dDProvider) {
            return new ArrayList<EjbJar>(this.annotationDDMap.values());
        }
    }

    public boolean isScanInProgress() {
        return NNMDRListener.getDefault().isScanInProgress();
    }

    public void waitScanFinished() {
        NNMDRListener.getDefault().waitScanFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EjbJar getDDRoot(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject instanceof DDProviderDataObject) {
                return this.getDDRoot0((DDProviderDataObject)dataObject);
            }
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
        EjbJarProxy ejbJarProxy = null;
        Map map = this.ddMap;
        synchronized (map) {
            ejbJarProxy = this.getFromCache(fo);
            if (ejbJarProxy != null) {
                return ejbJarProxy;
            }
        }
        fo.addFileChangeListener((FileChangeListener)new DDFileChangeListener());
        ejbJarProxy = DDUtils.createEjbJarProxy(fo.getInputStream());
        this.putToCache(fo, ejbJarProxy);
        return ejbJarProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EjbJar getDDRoot0(DDProviderDataObject ddProviderDataObject) throws IOException {
        EjbJarProxy ejbJarProxy = null;
        Map map = this.ddMap;
        synchronized (map) {
            ejbJarProxy = this.getFromCache(ddProviderDataObject);
            if (ejbJarProxy == null) {
                ejbJarProxy = DDUtils.createEjbJarProxy(ddProviderDataObject.createReader());
                this.putToCache(ddProviderDataObject, ejbJarProxy);
            }
        }
        return ejbJarProxy;
    }

    public EjbJar getDDRootCopy(FileObject fo) throws IOException {
        return (EjbJar)this.getDDRoot(fo).clone();
    }

    private EjbJarProxy getFromCache(Object o) {
        return (EjbJarProxy)this.ddMap.get(o);
    }

    private void putToCache(Object o, EjbJarProxy ejbJarProxy) {
        this.ddMap.put(o, ejbJarProxy);
    }

    public EjbJar getDDRoot(InputSource inputSource) throws IOException, SAXException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = DDProvider.createParser(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document document = parser.parse(inputSource);
        SAXParseException error = errorHandler.getError();
        String version = DDProvider.extractVersion(document);
        EjbJar original = DDProvider.createEjbJar(version, document);
        EjbJarProxy ejbJarProxy = new EjbJarProxy(original, version);
        ejbJarProxy.setError(error);
        if (error != null) {
            ejbJarProxy.setStatus(1);
        } else {
            ejbJarProxy.setStatus(0);
        }
        return ejbJarProxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof EjbJarProxy) {
            return (BaseBean)((EjbJarProxy)bean).getOriginal();
        }
        return null;
    }

    private static EjbJar createEjbJar(String version, Document document) {
        if ("3.0".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_3_0.EjbJar(document, 1);
        }
        if ("2.1".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_2_1.EjbJar(document, 1);
        }
        if ("2.0".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.ejb.model_2_0.EjbJar(document, 1);
        }
        return null;
    }

    private static String extractVersion(Document document) {
        String id = null;
        DocumentType dt = document.getDoctype();
        if (dt != null) {
            id = dt.getPublicId();
        } else {
            String schemaLocation = document.getDocumentElement().getAttribute("xsi:schemaLocation");
            if (schemaLocation != null) {
                id = schemaLocation.substring(schemaLocation.lastIndexOf(" ") + 1);
            }
        }
        if (id != null) {
            if (EJB_21_DOCTYPE.equals(id)) {
                return "2.1";
            }
            if (EJB_20_DOCTYPE.equals(id)) {
                return "2.0";
            }
            if (EJB_11_DOCTYPE.equals(id)) {
                return "1.1";
            }
        }
        return "3.0";
    }

    private static DocumentBuilder createParser(ErrorHandler errorHandler) throws SAXException {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    private class DDFileChangeListener
    extends FileChangeAdapter {
        private DDFileChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    EjbJarProxy ejbJarProxy = DDProvider.this.getFromCache(fo);
                    if (ejbJarProxy != null) {
                        String encoding = EncodingUtil.detectEncoding((InputStream)new BufferedInputStream(fo.getInputStream()));
                        if (encoding == null) {
                            encoding = "UTF8";
                        }
                        DDUtils.merge(ejbJarProxy, new InputStreamReader(fo.getInputStream(), encoding));
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String resource;
            if (DDProvider.EJB_11_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_1_1.dtd";
            } else if (DDProvider.EJB_20_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_2_0.dtd";
            } else if (DDProvider.EJB_21_DOCTYPE.equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_2_1.xsd";
            } else if ("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd".equals(systemId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/ejb-jar_3_0.xsd";
            } else {
                return null;
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }
}

