/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableOwnerOperations;
import org.openide.ErrorManager;

public class TableListNodeInfo
extends DatabaseNodeInfo
implements TableOwnerOperations {
    static final long serialVersionUID = -6156362126513404875L;

    protected void initChildren(Vector children) throws DatabaseException {
        try {
            String[] types = new String[]{"TABLE"};
            DriverSpecification drvSpec = this.getDriverSpecification();
            DatabaseMetaData dmd = drvSpec.getMetaData();
            List recycleBinTables = "Oracle".equals(dmd.getDatabaseProductName()) && dmd.getDatabaseMajorVersion() >= 10 ? this.getOracleRecycleBinTables(dmd) : Collections.EMPTY_LIST;
            drvSpec.getTables("%", types);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    DatabaseNodeInfo info = DatabaseNodeInfo.createNodeInfo(this, "table", rset);
                    if (info != null) {
                        if (!recycleBinTables.contains(info.getName())) {
                            info.put("table", info.getName());
                            children.add(info);
                        }
                    } else {
                        throw new Exception(TableListNodeInfo.bundle().getString("EXC_UnableToCreateNodeInformationForTable"));
                    }
                    rset.clear();
                }
                rs.close();
            }
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException(e.getMessage());
            dbe.initCause(e);
            throw dbe;
        }
    }

    public void addTable(String tname) throws DatabaseException {
        try {
            String[] types = new String[]{"TABLE", "BASE"};
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getTables(tname, types);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                rs.next();
                rset = drvSpec.getRow();
                if (rset == null) {
                    throw new NullPointerException();
                }
                DatabaseNodeInfo info = DatabaseNodeInfo.createNodeInfo(this, "table", rset);
                rset.clear();
                rs.close();
                if (info == null) {
                    throw new Exception(TableListNodeInfo.bundle().getString("EXC_UnableToCreateNodeInformationForTable"));
                }
                info.put("table", info.getName());
                this.refreshChildren();
            }
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException(e.getMessage());
            dbe.initCause(e);
            throw dbe;
        }
    }

    public TableNodeInfo getChildrenTableInfo(TableNodeInfo info) {
        String scode = info.getCode();
        String sname = info.getName();
        try {
            Enumeration enu = this.getChildren().elements();
            while (enu.hasMoreElements()) {
                TableNodeInfo elem = (TableNodeInfo)enu.nextElement();
                if (!elem.getCode().equals(scode) || !elem.getName().equals(sname)) continue;
                return elem;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getOracleRecycleBinTables(DatabaseMetaData dmd) {
        List<String> result = new ArrayList();
        try {
            Statement stmt = dmd.getConnection().createStatement();
            try {
                ResultSet rs = stmt.executeQuery("SELECT OBJECT_NAME FROM RECYCLEBIN WHERE TYPE = 'TABLE'");
                try {
                    while (rs.next()) {
                        result.add(rs.getString("OBJECT_NAME"));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            result = Collections.EMPTY_LIST;
        }
        return result;
    }
}

