/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.earproject.ui.wizards.NewEarProjectWizardIterator;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelModuleDetection;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportBlueprintEarWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    static final String PROP_NAME_INDEX = "nameIndex";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(PROP_NAME_INDEX, NbBundle.getBundle(ImportBlueprintEarWizardIterator.class), new HelpCtx(this.getClass()), true), new PanelModuleDetection()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(ImportBlueprintEarWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(ImportBlueprintEarWizardIterator.class, (String)"LBL_IW_ApplicationModulesStep")};
    }

    public Set<FileObject> instantiate() throws IOException {
        File dirF = (File)this.wiz.getProperty("projdir");
        File srcF = (File)this.wiz.getProperty("sourceRoot");
        String name = (String)this.wiz.getProperty("name");
        String j2eeLevel = (String)this.wiz.getProperty("j2eeLevel");
        String serverInstanceID = (String)this.wiz.getProperty("serverInstanceID");
        String platformName = (String)this.wiz.getProperty("setJavaPlatform");
        String sourceLevel = (String)this.wiz.getProperty("setSourceLevel");
        Map userModules = (Map)this.wiz.getProperty("userModules");
        return ImportBlueprintEarWizardIterator.testableInstantiate(platformName, sourceLevel, j2eeLevel, dirF, srcF, serverInstanceID, name, userModules);
    }

    static Set<FileObject> testableInstantiate(String platformName, String sourceLevel, String j2eeLevel, File dirF, File srcF, String serverInstanceID, String name, Map<FileObject, ModuleType> userModules) throws IOException {
        EarProjectGenerator.importProject(dirF, srcF, name, j2eeLevel, serverInstanceID, platformName, sourceLevel, userModules);
        FileObject dir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dirF));
        FoldersListSettings.getDefault().setLastUsedServer(serverInstanceID);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        resultSet.add(dir);
        NewEarProjectWizardIterator.setProjectChooserFolder(dirF);
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(ImportBlueprintEarWizardIterator.class, (String)"LBL_WizardStepsCount"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    FileObject getIndexJSPFO(FileObject webRoot, String indexJSP) {
        return webRoot.getFileObject(indexJSP.replace('.', '/'), "jsp");
    }
}

