/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.BrokenProjectSupport;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.UpdateHelper;
import org.netbeans.modules.j2ee.earproject.ui.ArchiveViews;
import org.netbeans.modules.j2ee.earproject.ui.IconBaseProvider;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2eeArchiveLogicalViewProvider
implements LogicalViewProvider {
    private final EarProject project;
    protected final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    protected final ReferenceHelper resolver;
    private final List<? extends Action> specialActions;
    private final AntBasedProjectType abpt;
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "jar.content.additional"};

    public J2eeArchiveLogicalViewProvider(EarProject project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver, List<? extends Action> specialActions, AntBasedProjectType abpt) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
        this.specialActions = specialActions;
        this.abpt = abpt;
    }

    public Node createLogicalView() {
        return new ArchiveLogicalViewRootNode();
    }

    public Node findPath(Node root, Object target) {
        Project project = (Project)root.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!project.equals(owner)) {
                return null;
            }
            Node result = this.findNodeUnderConfiguration(root, fo);
            if (result != null) {
                return result;
            }
            Node[] nodes = root.getChildren().getNodes(true);
            for (int i = nodes.length - 1; i >= 0; --i) {
                result = PackageView.findPath((Node)nodes[i], (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Node findNodeUnderConfiguration(Node root, FileObject fo) {
        FileObject rootfo = this.helper.getAntProjectHelper().resolveFileObject(this.evaluator.getProperty("meta.inf"));
        String relPath = FileUtil.getRelativePath((FileObject)rootfo, (FileObject)fo);
        if (relPath == null) {
            return null;
        }
        int idx = relPath.indexOf(46);
        if (idx != -1) {
            relPath = relPath.substring(0, idx);
        }
        StringTokenizer st = new StringTokenizer(relPath, "/");
        Node result = NodeOp.findChild((Node)root, (String)rootfo.getName());
        while (st.hasMoreTokens()) {
            result = NodeOp.findChild((Node)result, (String)st.nextToken());
        }
        return result;
    }

    private static Lookup createLookup(Project project, AntProjectHelper c) {
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        Lookup ret = null;
        ret = null == c ? Lookups.fixed((Object[])new Object[]{project, rootFolder}) : Lookups.fixed((Object[])new Object[]{project, rootFolder, c});
        return ret;
    }

    public static boolean hasBrokenLinks(AntProjectHelper helper, ReferenceHelper resolver) {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)helper, (ReferenceHelper)resolver, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
    }

    private String getIconBase() {
        IconBaseProvider ibp = (IconBaseProvider)this.project.getLookup().lookup(IconBaseProvider.class);
        return null == ibp ? "org/netbeans/modules/j2ee/earproject/ui/resources/" : ibp.getIconBase();
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String key, String name, boolean global) {
            return new ActionImpl(key, name, (Lookup)(global ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String command, String name, Lookup context) {
                super(name);
                this.context = context;
                this.command = command;
                this.name = name;
            }

            public void actionPerformed(ActionEvent e) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                ap.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ArchiveLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/j2ee/earproject/ui/resources/brokenProjectBadge.gif";
        private Action brokenLinksAction;
        private final BrokenServerAction brokenServerAction;
        private final BrokenProjectSupport brokenProjectSupport;
        private boolean broken;
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;

        public ArchiveLogicalViewRootNode() {
            super((Children)new ArchiveViews.LogicalViewChildren(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), J2eeArchiveLogicalViewProvider.this.evaluator), J2eeArchiveLogicalViewProvider.createLookup(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper()));
            this.privateLock = new Object();
            this.setIconBaseWithExtension(J2eeArchiveLogicalViewProvider.this.getIconBase() + "projectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)J2eeArchiveLogicalViewProvider.this.project).getDisplayName());
            if (J2eeArchiveLogicalViewProvider.hasBrokenLinks(J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), J2eeArchiveLogicalViewProvider.this.resolver)) {
                this.broken = true;
            }
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider moduleProvider = (J2eeModuleProvider)J2eeArchiveLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)moduleProvider));
            this.refreshProjectFiles();
            this.brokenProjectSupport = (BrokenProjectSupport)J2eeArchiveLogicalViewProvider.this.project.getLookup().lookup(BrokenProjectSupport.class);
            this.brokenProjectSupport.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ArchiveLogicalViewRootNode.this.checkProjectValidity();
                }
            });
        }

        private void refreshProjectFiles() {
            this.setFiles(this.getProjectFiles());
        }

        Set<FileObject> getProjectFiles() {
            Sources sources = ProjectUtils.getSources((Project)J2eeArchiveLogicalViewProvider.this.project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            return this.getProjectFiles(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private Set<FileObject> getProjectFiles(Collection<SourceGroup> groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> files = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject groupRoot = group.getRootFolder();
                if (J2eeArchiveLogicalViewProvider.this.project.getProjectDirectory().equals(groupRoot)) {
                    Enumeration en = J2eeArchiveLogicalViewProvider.this.project.getProjectDirectory().getChildren(false);
                    while (en.hasMoreElements()) {
                        FileObject child = (FileObject)en.nextElement();
                        if (FileOwnerQuery.getOwner((FileObject)child) != J2eeArchiveLogicalViewProvider.this.project) continue;
                        files.add(child);
                    }
                    continue;
                }
                files.add(groupRoot);
            }
            return files;
        }

        private final void setFiles(Set<FileObject> files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            if (files == null) {
                return;
            }
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            for (FileObject fo : files) {
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, "Can not get " + fo + " filesystem, ignoring...");
                    err.notify(1, (Throwable)e);
                }
            }
        }

        private synchronized void checkProjectValidity() {
            boolean old = this.broken;
            this.broken = this.brokenProjectSupport.hasBrokenArtifacts();
            if (!this.broken) {
                this.broken = J2eeArchiveLogicalViewProvider.hasBrokenLinks(J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), J2eeArchiveLogicalViewProvider.this.resolver);
            }
            if (old != this.broken) {
                this.getBrokenLinksAction().setEnabled(this.broken);
                this.fireIconChange();
                this.fireOpenedIconChange();
                this.fireDisplayNameChange(null, null);
            }
        }

        public Action getBrokenLinksAction() {
            if (this.broken && this.brokenLinksAction == null) {
                this.brokenLinksAction = new BrokenLinksAction();
            }
            return this.brokenLinksAction;
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
            return this.broken || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + dispName + "</font>" : null;
        }

        public Image getIcon(int type) {
            Image img = this.getMyIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        public Action[] getActions(boolean context) {
            return context ? super.getActions(true) : this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2eeArchiveLogicalViewProvider.this.project, (String)s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refreshProjectFiles();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refreshProjectFiles();
        }

        public Image getMyIcon(int type) {
            Image original = super.getIcon(type);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)Utilities.loadImage((String)BROKEN_PROJECT_BADGE), (int)8, (int)0) : original;
        }

        public Image getMyOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)Utilities.loadImage((String)BROKEN_PROJECT_BADGE), (int)8, (int)0) : original;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(ArchiveLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle bundle = NbBundle.getBundle(J2eeArchiveLogicalViewProvider.class);
            J2eeModuleProvider provider = (J2eeModuleProvider)J2eeArchiveLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(J2eeArchiveLogicalViewProvider.this.specialActions);
            actions.addAll(Arrays.asList(null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null)));
            if (provider != null && provider.hasVerifierSupport()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)bundle.getString("LBL_VerifyAction_Name"), null));
            }
            actions.addAll(Arrays.asList(null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)bundle.getString("LBL_DeployAction_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null, SystemAction.get(FindAction.class), null));
            try {
                Repository repository = Repository.getDefault();
                FileSystem sfs = repository.getDefaultFileSystem();
                FileObject fo = sfs.findResource("Projects/Actions");
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                    Lookup.Template query = new Lookup.Template(Object.class);
                    Lookup lookup = actionRegistry.getLookup();
                    Iterator it = lookup.lookup(query).allInstances().iterator();
                    if (it.hasNext()) {
                        actions.add(null);
                    }
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof Action) {
                            actions.add((Action)next);
                            continue;
                        }
                        if (!(next instanceof JSeparator)) continue;
                        actions.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            if (this.broken) {
                actions.add(this.getBrokenLinksAction());
            }
            if (this.brokenServerAction.isEnabled()) {
                actions.add(this.brokenServerAction);
            }
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(J2eeArchiveLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                J2eeArchiveLogicalViewProvider.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)J2eeArchiveLogicalViewProvider.this.evaluator));
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent e) {
                EarProjectProperties app = new EarProjectProperties(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.resolver, J2eeArchiveLogicalViewProvider.this.abpt);
                String j2eeSpec = (String)app.get("j2ee.platform");
                String instance = BrokenServerSupport.selectServer((String)j2eeSpec, (Object)J2eeModule.EAR);
                if (instance != null) {
                    app.put("j2ee.server.instance", instance);
                    app.store();
                }
                this.checkMissingServer();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("j2ee.server.instance".equals(evt.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
            }

            public void instanceAdded(String serverInstanceID) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String serverInstanceID) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean old = this.brokenServer;
                String serverInstanceID = J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)serverInstanceID);
                if (old != this.brokenServer) {
                    ArchiveLogicalViewRootNode.this.fireIconChange();
                    ArchiveLogicalViewRootNode.this.fireOpenedIconChange();
                    ArchiveLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                J2eeArchiveLogicalViewProvider.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)J2eeArchiveLogicalViewProvider.this.evaluator));
                this.putValue("Name", NbBundle.getMessage(J2eeArchiveLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
            }

            public void actionPerformed(ActionEvent e) {
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)J2eeArchiveLogicalViewProvider.this.resolver, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
                ArchiveLogicalViewRootNode.this.brokenProjectSupport.adjustReferences();
                ArchiveLogicalViewRootNode.this.checkProjectValidity();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (this.task == null) {
                    this.task = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.task.schedule(100);
            }

            public void run() {
                ArchiveLogicalViewRootNode.this.checkProjectValidity();
            }
        }
    }
}

