/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public abstract class NbBaseServlet
extends HttpServlet {
    public void init() throws ServletException {
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return NbBundle.getBundle((Class)NbBaseServlet.class).getString("MSG_BaseServletDescr");
    }

    protected boolean checkAccess(HttpServletRequest request) throws IOException {
        HttpServerSettings settings = (HttpServerSettings)SharedClassObject.findObject((Class)HttpServerSettings.class);
        if (settings == null) {
            return false;
        }
        if (settings.getHostProperty().getHost().equals("any")) {
            return true;
        }
        HashSet hs = settings.getGrantedAddressesSet();
        if (hs.contains(request.getRemoteAddr().trim())) {
            return true;
        }
        String pathI = request.getPathInfo();
        if (pathI == null) {
            pathI = "";
        }
        try {
            String address = request.getRemoteAddr().trim();
            if (settings.allowAccess(InetAddress.getByName(address), pathI)) {
                return true;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        return false;
    }
}

