/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinVistaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 9;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 1;
    private static final int ICON_Y_PAD = 7;
    private static final int BUMP_X_PAD = 3;
    private static final int BUMP_Y_PAD_UPPER = 6;
    private static final int BUMP_Y_PAD_BOTTOM = 3;
    private static boolean colorsReady = false;
    private static Color unselFillBrightUpperC;
    private static Color unselFillDarkUpperC;
    private static Color unselFillBrightLowerC;
    private static Color unselFillDarkLowerC;
    private static Color selFillC;
    private static Color focusFillUpperC;
    private static Color focusFillBrightLowerC;
    private static Color focusFillDarkLowerC;
    private static Color mouseOverFillBrightUpperC;
    private static Color mouseOverFillDarkUpperC;
    private static Color mouseOverFillBrightLowerC;
    private static Color mouseOverFillDarkLowerC;
    private static Color txtC;
    private static Color borderC;
    private static Color selBorderC;
    private static Color borderInnerC;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinVistaViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 17);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinVistaViewTabDisplayerUI((TabDisplayer)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        WinVistaViewTabDisplayerUI.initColors();
        c.setOpaque(true);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 17 : fm.getAscent() + 2 * fm.getDescent() + 3;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        if (0 == index) {
            ++x;
        }
        int txtWidth = width;
        if (this.isSelected(index)) {
            int space4pin;
            AbstractViewTabDisplayerUI.PinButton pin = this.configurePinButton(index);
            boolean showPin = pin != null && pin.getOrientation() != TabDisplayer.ORIENTATION_INVISIBLE;
            int n = space4pin = showPin ? this.pinButton.getWidth() + 1 : 0;
            if (this.displayer.isShowCloseButton()) {
                if (closeIcon == null) {
                    closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
                }
                String iconPath = this.findIconPath(index);
                Icon icon = closeIcon.obtainIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                int space4Icon = iconWidth + 2 + space4pin;
                txtWidth = width - 9 - space4Icon;
                this.getCloseIconRect(this.tempRect, index);
                icon.paintIcon(this.getDisplayer(), g, this.tempRect.x, this.tempRect.y);
            } else {
                txtWidth = width - 18 - space4pin;
                this.tempRect.x = x + (width - 2);
                int n2 = this.tempRect.y = !showPin ? 0 : this.displayer.getHeight() / 2 - this.pinButton.getPreferredSize().height / 2;
            }
            if (showPin) {
                if (this.tempRect.x - space4pin < x + 9 - 1) {
                    this.pinButton.setVisible(false);
                } else {
                    this.pinButton.setVisible(true);
                    this.pinButton.setLocation(this.tempRect.x - space4pin, this.tempRect.y);
                }
            } else {
                this.pinButton.setVisible(false);
            }
        } else {
            txtWidth = width - 18;
        }
        ColorUtil.paintVistaTabDragTexture(this.getDisplayer(), g, x + 3, y + 6, height - 9);
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 9), (int)(y + fm.getAscent() + 3), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
        boolean isFirst = index == 0;
        boolean isHighlighted = this.isTabHighlighted(index);
        g.translate(x, y);
        Color borderColor = isHighlighted ? selBorderC : borderC;
        g.setColor(borderColor);
        boolean left = false;
        if (isFirst) {
            g.drawLine(0, 0, 0, height - 2);
        }
        g.drawLine(0, 0, width - 1, 0);
        if (index < this.getDataModel().size() - 1 && this.isTabHighlighted(index + 1)) {
            g.setColor(selBorderC);
        }
        g.drawLine(width - 1, 0, width - 1, height - 2);
        g.setColor(borderC);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.setColor(borderInnerC);
        if (isFirst) {
            g.drawLine(1, 1, 1, height - 2);
        } else {
            g.drawLine(0, 1, 0, height - 2);
        }
        g.drawLine(width - 2, 1, width - 2, height - 2);
        g.drawLine(1, 1, width - 2, 1);
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        y += 2;
        height -= 2;
        boolean selected = this.isSelected(index);
        boolean focused = selected && this.isActive();
        boolean attention = this.isAttention(index);
        boolean mouseOver = this.isMouseOver(index);
        if (focused && !attention) {
            ColorUtil.vistaFillRectGradient((Graphics2D)g, x, y, width, height, focusFillUpperC, focusFillBrightLowerC, focusFillDarkLowerC);
        } else if (selected && !attention) {
            g.setColor(selFillC);
            g.fillRect(x, y, width, height);
        } else if (mouseOver && !attention) {
            ColorUtil.vistaFillRectGradient((Graphics2D)g, x, y, width, height, mouseOverFillBrightUpperC, mouseOverFillDarkUpperC, mouseOverFillBrightLowerC, mouseOverFillDarkLowerC);
        } else if (attention) {
            Color a = new Color(255, 255, 128);
            Color b = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)g, x, y, width, height, a, b);
        } else {
            ColorUtil.vistaFillRectGradient((Graphics2D)g, x, y, width, height, unselFillBrightUpperC, unselFillDarkUpperC, unselFillBrightLowerC, unselFillDarkLowerC);
        }
    }

    protected Font getTxtFont() {
        Font font = super.getTxtFont();
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        return font;
    }

    private String findIconPath(int index) {
        if (((OwnController)this.getController()).isClosePressed() == index) {
            return "org/netbeans/swing/tabcontrol/resources/vista_close_pressed.png";
        }
        if (((OwnController)this.getController()).isMouseInCloseButton() == index) {
            return "org/netbeans/swing/tabcontrol/resources/vista_close_over.png";
        }
        return "org/netbeans/swing/tabcontrol/resources/vista_close_enabled.png";
    }

    private boolean isTabHighlighted(int index) {
        if (((OwnController)this.getController()).getMouseIndex() == index) {
            return true;
        }
        return this.isSelected(index) && this.isActive();
    }

    private boolean isMouseOver(int index) {
        return ((OwnController)this.getController()).getMouseIndex() == index && !this.isSelected(index);
    }

    private static void initColors() {
        if (!colorsReady) {
            txtC = UIManager.getColor("TabbedPane.foreground");
            selFillC = UIManager.getColor("tab_sel_fill");
            focusFillUpperC = UIManager.getColor("tab_focus_fill_upper");
            focusFillBrightLowerC = UIManager.getColor("tab_focus_fill_bright_lower");
            focusFillDarkLowerC = UIManager.getColor("tab_focus_fill_dark_lower");
            unselFillBrightUpperC = UIManager.getColor("tab_unsel_fill_bright_upper");
            unselFillDarkUpperC = UIManager.getColor("tab_unsel_fill_dark_upper");
            unselFillBrightLowerC = UIManager.getColor("tab_unsel_fill_bright_lower");
            unselFillDarkLowerC = UIManager.getColor("tab_unsel_fill_dark_lower");
            mouseOverFillBrightUpperC = UIManager.getColor("tab_mouse_over_fill_bright_upper");
            mouseOverFillDarkUpperC = UIManager.getColor("tab_mouse_over_fill_dark_upper");
            mouseOverFillBrightLowerC = UIManager.getColor("tab_mouse_over_fill_bright_lower");
            mouseOverFillDarkLowerC = UIManager.getColor("tab_mouse_over_fill_dark_lower");
            borderC = UIManager.getColor("tab_border");
            selBorderC = UIManager.getColor("tab_sel_border");
            borderInnerC = UIManager.getColor("tab_border_inner");
            colorsReady = true;
        }
    }

    private Rectangle getCloseIconRect(Rectangle rect, int index) {
        TabLayoutModel tlm = this.getLayoutModel();
        int x = tlm.getX(index);
        int y = tlm.getY(index);
        int w = tlm.getW(index);
        int h = tlm.getH(index);
        String iconPath = this.findIconPath(index);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(iconPath);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        rect.x = x + w - iconWidth - 2;
        rect.y = this.getCenteredIconY(icon, index);
        rect.width = iconWidth;
        rect.height = iconHeight;
        return rect;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> normalIcons = new HashMap<Object, String>(6);
        normalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_enabled.png");
        normalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_enabled.png");
        normalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_enabled.png");
        normalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_enabled.png");
        HashMap<Object, String> pressedIcons = new HashMap<Object, String>(6);
        pressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_pressed.png");
        pressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_pressed.png");
        pressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_pressed.png");
        pressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_pressed.png");
        HashMap<Object, String> rolloverIcons = new HashMap<Object, String>(6);
        rolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_over.png");
        rolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_over.png");
        rolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_over.png");
        rolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_over.png");
        HashMap<Object, String> focusNormalIcons = new HashMap<Object, String>(6);
        focusNormalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_enabled.png");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_enabled.png");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_enabled.png");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_enabled.png");
        HashMap<Object, String> focusPressedIcons = new HashMap<Object, String>(6);
        focusPressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_pressed.png");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_pressed.png");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_pressed.png");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_pressed.png");
        HashMap<Object, String> focusRolloverIcons = new HashMap<Object, String>(6);
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/vista_slideright_over.png");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/vista_slideleft_over.png");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/vista_slidedown_over.png");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/vista_pin_over.png");
        return new VistaPinButton(this.displayer, focusNormalIcons, focusPressedIcons, focusRolloverIcons, normalIcons, pressedIcons, rolloverIcons);
    }

    protected static class VistaPinButton
    extends AbstractViewTabDisplayerUI.PinButton {
        private Map focusedNormal;
        private Map focusedRollover;
        private Map focusedPressed;
        private TabDisplayer displayer;

        protected VistaPinButton(TabDisplayer displayer, Map focusedNormal, Map focusedPressed, Map focusedRollover, Map selectNormal, Map selectPressed, Map selectRollover) {
            super(selectNormal, selectPressed, selectRollover);
            this.focusedPressed = focusedPressed;
            this.focusedRollover = focusedRollover;
            this.focusedNormal = focusedNormal;
            this.displayer = displayer;
        }

        public Icon getIcon() {
            if (this.displayer == null) {
                return null;
            }
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedNormal.get(this.getOrientation()));
            }
            return super.getIcon();
        }

        public Icon getRolloverIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedRollover.get(this.getOrientation()));
            }
            return super.getRolloverIcon();
        }

        public Icon getPressedIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedPressed.get(this.getOrientation()));
            }
            return super.getPressedIcon();
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        protected int inCloseIconRect(Point point) {
            if (!WinVistaViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int index = WinVistaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (index < 0 || !WinVistaViewTabDisplayerUI.this.isSelected(index)) {
                return -1;
            }
            return WinVistaViewTabDisplayerUI.this.getCloseIconRect(WinVistaViewTabDisplayerUI.this.tempRect, index).contains(point) ? index : -1;
        }

        protected boolean inPinButtonRect(Point p) {
            if (!WinVistaViewTabDisplayerUI.this.pinButton.isVisible()) {
                return false;
            }
            Point p2 = SwingUtilities.convertPoint(WinVistaViewTabDisplayerUI.this.displayer, p, WinVistaViewTabDisplayerUI.this.pinButton);
            return WinVistaViewTabDisplayerUI.this.pinButton.contains(p2);
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            this.updateHighlight(WinVistaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (!this.inPinButtonRect(e.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = WinVistaViewTabDisplayerUI.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex) - 1;
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex) + 2;
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinVistaViewTabDisplayerUI.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex) - 1;
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex) + 2;
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (repaintRect != null) {
                WinVistaViewTabDisplayerUI.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }
    }
}

