/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.AquaViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicSlidingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ToolbarTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinXPEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinXPViewTabDisplayerUI;

public final class TabDisplayer
extends JComponent
implements Accessible {
    private boolean initialized = false;
    private TabDataModel model;
    private SingleSelectionModel sel = null;
    private boolean active;
    private final int type;
    public static final int TYPE_VIEW = 0;
    public static final int TYPE_EDITOR = 1;
    public static final int TYPE_SLIDING = 2;
    public static final int TYPE_TOOLBAR = 3;
    public static final String PROP_ACTIVE = "active";
    public static final String COMMAND_CLOSE = "close";
    public static final String COMMAND_SELECT = "select";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_MAXIMIZE = "maximize";
    public static final String COMMAND_CLOSE_ALL = "closeAll";
    public static final String COMMAND_CLOSE_ALL_BUT_THIS = "closeAllButThis";
    public static final String COMMAND_ENABLE_AUTO_HIDE = "enableAutoHide";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String EDITOR_TAB_DISPLAYER_UI_CLASS_ID = "EditorTabDisplayerUI";
    public static final String VIEW_TAB_DISPLAYER_UI_CLASS_ID = "ViewTabDisplayerUI";
    public static final String SLIDING_TAB_DISPLAYER_UI_CLASS_ID = "SlidingTabDisplayerUI";
    public static final String TOOLBAR_TAB_DISPLAYER_UI_CLASS_ID = "ToolbarTabDisplayerUI";
    public static final String PROP_ORIENTATION = "orientation";
    public static final Object ORIENTATION_EAST = "east";
    public static final Object ORIENTATION_WEST = "west";
    public static final Object ORIENTATION_NORTH = "north";
    public static final Object ORIENTATION_SOUTH = "south";
    public static final Object ORIENTATION_CENTER = "center";
    public static final Object ORIENTATION_INVISIBLE = "invisible";
    private transient List actionListenerList;
    private LocationInformer locationInformer = null;
    private boolean showClose = !Boolean.getBoolean("nb.tabs.suppressCloseButton");

    public TabDisplayer() {
        this(new DefaultTabDataModel(), 0);
    }

    public TabDisplayer(TabDataModel model, int type) {
        this(model, type, null);
    }

    public TabDisplayer(TabDataModel model, int type, LocationInformer locationInformer) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown UI type: " + type);
            }
        }
        this.model = model;
        this.type = type;
        this.locationInformer = locationInformer;
        this.putClientProperty(PROP_ORIENTATION, ORIENTATION_NORTH);
        this.initialized = true;
        this.updateUI();
        this.setFocusable(false);
    }

    public final TabDisplayerUI getUI() {
        return (TabDisplayerUI)this.ui;
    }

    public final void updateUI() {
        if (!this.initialized) {
            return;
        }
        if (this.type == 3) {
            this.setUI(new ToolbarTabDisplayerUI(this));
            return;
        }
        if (this.type == 2) {
            this.setUI(new BasicSlidingTabDisplayerUI(this));
            return;
        }
        ComponentUI ui = null;
        if (UIManager.get(this.getUIClassID()) != null) {
            try {
                ui = UIManager.getUI(this);
            }
            catch (Error error) {
                System.err.println("Could not load a UI for " + this.getUIClassID() + " - missing class?");
            }
        } else {
            ui = this.findUIStandalone();
        }
        if (ui == null) {
            ui = this.getType() == 0 ? WinClassicViewTabDisplayerUI.createUI(this) : WinClassicEditorTabDisplayerUI.createUI(this);
        }
        this.setUI((TabDisplayerUI)ui);
    }

    private ComponentUI findUIStandalone() {
        ComponentUI result = null;
        String lf = UIManager.getLookAndFeel().getID();
        switch (this.type) {
            case 0: {
                if ("Aqua".equals(lf)) {
                    result = AquaViewTabDisplayerUI.createUI(this);
                    break;
                }
                if (!"Windows".equals(lf)) break;
                result = TabDisplayer.isXPLF() ? WinXPViewTabDisplayerUI.createUI(this) : WinClassicViewTabDisplayerUI.createUI(this);
                break;
            }
            case 1: {
                if ("Aqua".equals(lf)) {
                    result = AquaEditorTabDisplayerUI.createUI(this);
                    break;
                }
                if (!"Windows".equals(lf)) break;
                result = TabDisplayer.isXPLF() ? WinXPEditorTabDisplayerUI.createUI(this) : WinClassicEditorTabDisplayerUI.createUI(this);
            }
        }
        return result;
    }

    private static boolean isXPLF() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    public String getUIClassID() {
        switch (this.getType()) {
            case 0: {
                return VIEW_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 1: {
                return EDITOR_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 2: {
                return SLIDING_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 3: {
                return TOOLBAR_TAB_DISPLAYER_UI_CLASS_ID;
            }
        }
        throw new IllegalArgumentException("Unknown UI type: " + this.getType());
    }

    public final int getType() {
        return this.type;
    }

    public final Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    public final Dimension getMinimumSize() {
        return this.getUI().getMinimumSize(this);
    }

    public final void requestAttention(int tab) {
        this.getUI().requestAttention(tab);
    }

    public final void cancelRequestAttention(int tab) {
        this.getUI().cancelRequestAttention(tab);
    }

    public final boolean requestAttention(TabData data) {
        boolean result;
        int idx = this.getModel().indexOf(data);
        boolean bl = result = idx >= 0;
        if (result) {
            this.requestAttention(idx);
        }
        return result;
    }

    void setSelectionModel(SingleSelectionModel sel) {
        this.sel = sel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.sel;
    }

    public final TabDataModel getModel() {
        return this.model;
    }

    public final void setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.firePropertyChange(PROP_ACTIVE, !active, active);
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getToolTipText(MouseEvent event) {
        if (this.ui != null) {
            int index;
            Point p = event.getPoint();
            if (event.getSource() != this) {
                Component c = (Component)event.getSource();
                p = SwingUtilities.convertPoint(c, p, this);
            }
            if ((index = this.getUI().tabForCoordinate(p)) != -1) {
                String button = this.getUI().getTooltipForButtons(p);
                if (button != null) {
                    return button;
                }
                return this.getModel().getTab((int)index).tip;
            }
        }
        return super.getToolTipText(event);
    }

    public final void makeTabVisible(int index) {
        this.getUI().makeTabVisible(index);
    }

    public final Rectangle getTabRect(int tab, Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        }
        this.getUI().getTabRect(tab, dest);
        return dest;
    }

    public final Image getDragImage(int index) {
        return this.getUI().createImageOfTab(index);
    }

    public final synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public final synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    public String getCommandAtPoint(Point p) {
        return this.getUI().getCommandAtPoint(p);
    }

    public void registerShortcuts(JComponent comp) {
        this.getUI().registerShortcuts(comp);
    }

    public void unregisterShortcuts(JComponent comp) {
        this.getUI().unregisterShortcuts(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postActionEvent(TabActionEvent event) {
        List list;
        TabDisplayer tabDisplayer = this;
        synchronized (tabDisplayer) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    public int tabForCoordinate(Point p) {
        return this.getUI().tabForCoordinate(p);
    }

    public LocationInformer getLocationInformer() {
        return this.locationInformer;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTabDisplayer();
        }
        return this.accessibleContext;
    }

    public final void setShowCloseButton(boolean val) {
        boolean wasShow = this.isShowCloseButton();
        if (wasShow != val) {
            this.showClose = val;
            if (this.isShowing()) {
                this.repaint();
            }
            this.firePropertyChange("showCloseButton", !val, val);
        }
    }

    public final boolean isShowCloseButton() {
        return this.showClose;
    }

    protected class AccessibleTabDisplayer
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleTabDisplayer() {
            super(TabDisplayer.this);
            TabDisplayer.this.getModel().addChangeListener(this);
        }

        public void stateChanged(ChangeEvent e) {
            Object o = e.getSource();
            this.firePropertyChange("AccessibleSelection", null, o);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return TabDisplayer.this.getModel().size();
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= TabDisplayer.this.getModel().size()) {
                return null;
            }
            TabData data = TabDisplayer.this.getModel().getTab(i);
            if (data.getComponent() instanceof Accessible) {
                return (Accessible)((Object)data.getComponent());
            }
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point p) {
            int tab = TabDisplayer.this.tabForCoordinate(p);
            if (tab == -1) {
                tab = TabDisplayer.this.getSelectionModel().getSelectedIndex();
            }
            return this.getAccessibleChild(tab);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int i) {
            int index = TabDisplayer.this.getSelectionModel().getSelectedIndex();
            return this.getAccessibleChild(index);
        }

        public boolean isAccessibleChildSelected(int i) {
            return i == TabDisplayer.this.getSelectionModel().getSelectedIndex();
        }

        public void addAccessibleSelection(int i) {
        }

        public void removeAccessibleSelection(int i) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

