/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class WarDeploymentConfiguration
extends WLDeploymentConfiguration
implements PropertyChangeListener {
    private File file;
    private WeblogicWebApp webLogicWebApp;

    public WarDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
    }

    public void init(File file) {
        this.file = file;
        this.getWeblogicWebApp();
        if (this.dataObject == null) {
            try {
                this.dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
                this.dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
    }

    public String getContextPath() throws ConfigurationException {
        WeblogicWebApp webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            throw new ConfigurationException("weblogic.xml is not parseable, cannot read the context path value.");
        }
        return webLogicWebApp.getContextRoot(0);
    }

    public void setContextPath(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        this.modifyWeblogicWebApp(new WeblogicWebAppModifier(){

            public void modify(WeblogicWebApp webLogicWebApp) {
                webLogicWebApp.setContextRoot(new String[]{newContextPath});
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            this.webLogicWebApp = null;
        }
    }

    public synchronized WeblogicWebApp getWeblogicWebApp() {
        if (this.webLogicWebApp == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.webLogicWebApp = WeblogicWebApp.createGraph(this.file);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.webLogicWebApp = this.genereateWeblogicWebApp();
                    this.writefile(this.file, this.webLogicWebApp);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.webLogicWebApp;
    }

    public void save(OutputStream os) throws ConfigurationException {
        WeblogicWebApp webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            webLogicWebApp.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private void modifyWeblogicWebApp(WeblogicWebAppModifier modifier) throws ConfigurationException {
        assert (this.dataObject != null) : "DataObject has not been initialized yet";
        try {
            EditorCookie editor = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            WeblogicWebApp newWeblogicWebApp = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newWeblogicWebApp = WeblogicWebApp.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                WeblogicWebApp oldWeblogicWebApp = this.getWeblogicWebApp();
                if (oldWeblogicWebApp == null) {
                    throw new ConfigurationException("Configuration data are not parseable cannot perform changes.");
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_weblogicXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newWeblogicWebApp = oldWeblogicWebApp;
            }
            modifier.modify(newWeblogicWebApp);
            boolean modified = this.dataObject.isModified();
            this.replaceDocument(doc, newWeblogicWebApp);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.webLogicWebApp = newWeblogicWebApp;
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
    }

    private WeblogicWebApp genereateWeblogicWebApp() {
        WeblogicWebApp webLogicWebApp = new WeblogicWebApp();
        webLogicWebApp.createAttribute("xmlns:j2ee", "xmlns:j2ee", 513, null, null);
        webLogicWebApp.setAttributeValue("xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/90 http://www.bea.com/ns/weblogic/90/weblogic-web-app.xsd");
        webLogicWebApp.setContextRoot(new String[]{""});
        return webLogicWebApp;
    }

    private void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write((OutputStream)out);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
            }
        });
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    private static interface WeblogicWebAppModifier {
        public void modify(WeblogicWebApp var1);
    }
}

