/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Component;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskAnnotation;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.suggestions.SuggestionAnno;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class FixAction
extends NodeAction {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] node) {
        if (node == null || node.length < 1) {
            return false;
        }
        boolean enabled = false;
        for (int i = 0; i < node.length; ++i) {
            Task task = TaskNode.getTask((Node)node[i]);
            if (task == null || task.getAction() == null) continue;
            enabled = true;
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] node) {
        SuggestionManagerImpl manager = (SuggestionManagerImpl)SuggestionManager.getDefault();
        boolean skipConfirm = false;
        if (!$assertionsDisabled && !(node[0] instanceof SuggestionNode)) {
            throw new AssertionError((Object)"Need to be softened later on");
        }
        TaskListView tlv = TaskListView.getCurrent();
        ArrayList originalModified = new ArrayList(DataObject.getRegistry().getModifiedSet());
        boolean fixingStarted = false;
        try {
            for (int i = 0; i < node.length; ++i) {
                SuggestionPerformer performer;
                SuggestionImpl item = (SuggestionImpl)TaskNode.getTask((Node)node[i]);
                if (item == null || (performer = item.getAction()) == null) continue;
                boolean doConfirm = manager.isConfirm(item.getSType());
                Object confirmation = null;
                if (doConfirm && !skipConfirm && performer.hasConfirmation()) {
                    confirmation = performer.getConfirmation((Suggestion)item);
                }
                if (confirmation != null) {
                    Object[] objectArray;
                    if (tlv != null) {
                        tlv.showTaskInEditor((Task)item, (TaskAnnotation)new SuggestionAnno(item));
                        tlv.select((Task)item);
                    }
                    JButton fixButton = new JButton();
                    Actions.setMenuText((AbstractButton)fixButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"FixIt"), (boolean)true);
                    JButton fixAllButton = null;
                    JButton skipButton = null;
                    if (node.length > 1) {
                        fixAllButton = new JButton();
                        Actions.setMenuText((AbstractButton)fixAllButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"FixAll"), (boolean)true);
                        skipButton = new JButton();
                        Actions.setMenuText((AbstractButton)skipButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"Skip"), (boolean)true);
                        fixAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"ACSD_FixAll"));
                        skipButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"ACSD_Skip"));
                    }
                    JButton cancelButton = new JButton();
                    Actions.setMenuText((AbstractButton)cancelButton, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"Cancel"), (boolean)true);
                    if (confirmation instanceof Component) {
                        ((Component)confirmation).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"ACSD_Confirmation"));
                    }
                    fixButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"ACSD_Fix"));
                    cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"ACSD_Cancel"));
                    String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$FixAction == null ? FixAction.class$("org.netbeans.modules.tasklist.suggestions.FixAction") : class$org$netbeans$modules$tasklist$suggestions$FixAction), (String)"TITLE_fixconfirm");
                    if (node.length > 1) {
                        JButton[] jButtonArray = new JButton[4];
                        jButtonArray[0] = fixButton;
                        jButtonArray[1] = skipButton;
                        jButtonArray[2] = fixAllButton;
                        objectArray = jButtonArray;
                        jButtonArray[3] = cancelButton;
                    } else {
                        Object[] objectArray2 = new JButton[2];
                        objectArray2[0] = fixButton;
                        objectArray = objectArray2;
                        objectArray2[1] = cancelButton;
                    }
                    DialogDescriptor dlg = new DialogDescriptor(confirmation, title, true, objectArray, (Object)fixButton, 0, null, null);
                    dlg.setMessageType(-1);
                    dlg.setModal(true);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
                    dialog.pack();
                    dialog.show();
                    Object pressedButton = dlg.getValue();
                    if (tlv != null) {
                        tlv.showTaskInEditor(null, null);
                    }
                    if (pressedButton == cancelButton) {
                        break;
                    }
                    if (pressedButton == fixAllButton) {
                        skipConfirm = true;
                    } else if (pressedButton == skipButton || pressedButton != fixButton) continue;
                }
                if (!fixingStarted) {
                    fixingStarted = true;
                    manager.setFixing(true);
                }
                if (item.isZombie()) {
                    int matches = 0;
                    Iterator it = item.getParent().subtasksIterator();
                    SuggestionImpl match = null;
                    boolean exact = false;
                    while (it.hasNext()) {
                        SuggestionImpl sm = (SuggestionImpl)((Object)it.next());
                        if (sm.hasSubtasks()) {
                            Iterator it2 = sm.subtasksIterator();
                            while (it2.hasNext()) {
                                SuggestionImpl sm2 = (SuggestionImpl)((Object)it2.next());
                                if (item.getSType() != sm2.getSType() || !item.getSummary().equals(sm2.getSummary()) || item.getPriority() != sm2.getPriority() || item.getPriority() != sm2.getPriority()) continue;
                                match = sm2;
                                ++matches;
                                if (!item.getLine().equals(sm2.getLine())) continue;
                                exact = true;
                                break;
                            }
                            if (!exact) continue;
                            break;
                        }
                        if (item.getSType() != sm.getSType() || !item.getSummary().equals(sm.getSummary()) || item.getPriority() != sm.getPriority() || item.getPriority() != sm.getPriority()) continue;
                        match = sm;
                        ++matches;
                        if (!item.getLine().equals(sm.getLine())) continue;
                        exact = true;
                        break;
                    }
                    if (match != null && (exact || matches == 1)) {
                        item = match;
                    }
                }
                performer.perform((Suggestion)item);
            }
        }
        finally {
            if (fixingStarted) {
                manager.setFixing(false);
            }
        }
        Set modifiedRO = DataObject.getRegistry().getModifiedSet();
        HashSet modified = new HashSet(modifiedRO);
        modified.removeAll(originalModified);
        boolean haveModified = false;
        Iterator it = modified.iterator();
        while (it.hasNext()) {
            JEditorPane[] panes;
            DataObject dao = (DataObject)it.next();
            EditorCookie cookie = (EditorCookie)dao.getCookie(class$org$openide$cookies$EditorCookie == null ? FixAction.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
            if (cookie == null || (panes = cookie.getOpenedPanes()) != null && panes.length != 0) continue;
            haveModified = true;
        }
        if (haveModified) {
            DataObject dao;
            Object[] objectArray;
            JButton openFiles = new JButton();
            Actions.setMenuText((AbstractButton)openFiles, (String)NbBundle.getMessage((Class)FixAction.class, (String)"ShowFiles"), (boolean)true);
            JButton selectFiles = new JButton();
            Actions.setMenuText((AbstractButton)selectFiles, (String)NbBundle.getMessage((Class)FixAction.class, (String)"SelectFiles"), (boolean)true);
            JButton saveFiles = new JButton();
            Actions.setMenuText((AbstractButton)saveFiles, (String)NbBundle.getMessage((Class)FixAction.class, (String)"SaveAllFiles"), (boolean)true);
            JButton cancelButton = new JButton();
            Actions.setMenuText((AbstractButton)cancelButton, (String)NbBundle.getMessage((Class)FixAction.class, (String)"Cancel"), (boolean)true);
            String title = NbBundle.getMessage((Class)FixAction.class, (String)"FixSavesTitle");
            String string = NbBundle.getMessage((Class)FixAction.class, (String)"FixFileSaves");
            if (node.length > 1) {
                Object[] objectArray3 = new JButton[3];
                objectArray3[0] = openFiles;
                objectArray3[1] = saveFiles;
                objectArray = objectArray3;
                objectArray3[2] = cancelButton;
            } else {
                JButton[] jButtonArray = new JButton[3];
                jButtonArray[0] = openFiles;
                jButtonArray[1] = saveFiles;
                objectArray = jButtonArray;
                jButtonArray[2] = cancelButton;
            }
            DialogDescriptor dlg = new DialogDescriptor((Object)string, title, true, objectArray, (Object)openFiles, 0, null, null);
            dlg.setMessageType(-1);
            dlg.setModal(true);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
            dialog.pack();
            dialog.show();
            Object pressedButton = dlg.getValue();
            if (pressedButton == openFiles) {
                it = modified.iterator();
                while (it.hasNext()) {
                    dao = (DataObject)it.next();
                    EditorCookie cookie = (EditorCookie)dao.getCookie(class$org$openide$cookies$EditorCookie == null ? FixAction.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                    if (cookie == null) continue;
                    cookie.open();
                }
            } else if (pressedButton == saveFiles) {
                it = modified.iterator();
                while (it.hasNext()) {
                    dao = (DataObject)it.next();
                    EditorCookie cookie = (EditorCookie)dao.getCookie(class$org$openide$cookies$EditorCookie == null ? FixAction.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                    if (cookie == null) continue;
                    try {
                        cookie.saveDocument();
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(16, (Throwable)e);
                    }
                }
            } else if (pressedButton == selectFiles) {
                // empty if block
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage((Class)FixAction.class, (String)"LBL_FixConfirm");
    }

    protected String iconResource() {
        return "org/netbeans/modules/tasklist/suggestions/fix.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static {
        $assertionsDisabled = !FixAction.class.desiredAssertionStatus();
    }
}

