/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public final class PlatformComponentFactory {
    private static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");
    private static Set userSuites = new TreeSet<Object>(Collator.getInstance());
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory;

    private PlatformComponentFactory() {
    }

    public static JComboBox getNbPlatformsComboxBox() {
        JComboBox<Object> plafComboBox = new JComboBox<Object>(new NbPlatformListModel());
        plafComboBox.setRenderer(new NbPlatformListRenderer());
        return plafComboBox;
    }

    public static JList getNbPlatformsList() {
        JList<Object> plafList = new JList<Object>(new NbPlatformListModel());
        plafList.setSelectionMode(0);
        plafList.setCellRenderer(new NbPlatformListRenderer());
        return plafList;
    }

    public static JComboBox getSuitesComboBox() {
        SuiteListModel model = new SuiteListModel(userSuites);
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            String suiteDir = SuiteUtils.getSuiteDirectoryPath(projects[i]);
            if (suiteDir == null) continue;
            model.addElement(suiteDir);
        }
        JComboBox suiteCombo = new JComboBox(model);
        if (model.getSize() > 0) {
            suiteCombo.setSelectedIndex(0);
        }
        return suiteCombo;
    }

    public static void addUserSuite(String suiteDir) {
        userSuites.add(suiteDir);
    }

    public static ListCellRenderer getURLListRenderer() {
        return new URLListRenderer();
    }

    static final class URLListRenderer
    extends DefaultListCellRenderer {
        URLListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            URL baseU;
            URL u = (URL)value;
            String text = u.toExternalForm();
            if (u.getProtocol().equals("file")) {
                text = new File(URI.create(u.toExternalForm())).getAbsolutePath();
            } else if (u.getProtocol().equals("jar") && u.equals(FileUtil.getArchiveRoot((URL)(baseU = FileUtil.getArchiveFile((URL)u)))) && baseU.getProtocol().equals("file")) {
                text = new File(URI.create(baseU.toExternalForm())).getAbsolutePath();
            }
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    static final class NbPlatformJavadocRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] javadocRoots;

        NbPlatformJavadocRootsModel(NbPlatform plaf) {
            this.plaf = plaf;
            this.javadocRoots = plaf.getJavadocRoots();
        }

        public Object getElementAt(int index) {
            return this.javadocRoots[index];
        }

        public int getSize() {
            return this.javadocRoots.length;
        }

        void removeJavadocRoots(URL[] jdRootToRemove) {
            try {
                this.plaf.removeJavadocRoots(jdRootToRemove);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void addJavadocRoot(URL jdRootToAdd) {
            try {
                this.plaf.addJavadocRoot(jdRootToAdd);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveJavadocRootsDown(int[] toMoveDown) {
            try {
                for (int i = 0; i < toMoveDown.length; ++i) {
                    this.plaf.moveJavadocRootDown(toMoveDown[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveJavadocRootsUp(int[] toMoveUp) {
            try {
                for (int i = 0; i < toMoveUp.length; ++i) {
                    this.plaf.moveJavadocRootUp(toMoveUp[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }
    }

    static final class NbPlatformSourceRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] srcRoots;

        NbPlatformSourceRootsModel(NbPlatform plaf) {
            this.plaf = plaf;
            this.srcRoots = plaf.getSourceRoots();
        }

        public Object getElementAt(int index) {
            return this.srcRoots[index];
        }

        public int getSize() {
            return this.srcRoots.length;
        }

        void removeSourceRoot(URL[] srcRootToRemove) {
            try {
                this.plaf.removeSourceRoots(srcRootToRemove);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, srcRootToRemove.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void addSourceRoot(URL srcRootToAdd) {
            try {
                this.plaf.addSourceRoot(srcRootToAdd);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveSourceRootsDown(int[] toMoveDown) {
            try {
                for (int i = 0; i < toMoveDown.length; ++i) {
                    this.plaf.moveSourceRootDown(toMoveDown[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveSourceRootsUp(int[] toMoveUp) {
            try {
                for (int i = 0; i < toMoveUp.length; ++i) {
                    this.plaf.moveSourceRootUp(toMoveUp[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }
    }

    private static class SuiteListModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private Set suites = new TreeSet<Object>(Collator.getInstance());
        private Object selectedSuite;
        static final /* synthetic */ boolean $assertionsDisabled;

        SuiteListModel(Set suites) {
            this.suites.addAll(suites);
        }

        public void setSelectedItem(Object suite) {
            if (suite == null) {
                return;
            }
            if (!$assertionsDisabled && !(suite instanceof String)) {
                throw new AssertionError();
            }
            if (this.selectedSuite != suite) {
                this.selectedSuite = suite;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedSuite;
        }

        public int getSize() {
            return this.suites.size();
        }

        public Object getElementAt(int index) {
            return this.suites.toArray()[index];
        }

        public void addElement(Object obj) {
            this.suites.add(obj);
            this.fireIntervalAdded(this, 0, this.suites.size());
        }

        public void insertElementAt(Object obj, int index) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to insertElementAt?");
            }
        }

        public void removeElement(Object obj) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to removeElement?");
            }
        }

        public void removeElementAt(int index) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Who needs to call removeElementAt?");
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory = PlatformComponentFactory.class$("org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory")) : class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory).desiredAssertionStatus();
        }
    }

    static class ModuleEntryListModel
    extends AbstractListModel {
        private ModuleEntry[] mes;

        ModuleEntryListModel(ModuleEntry[] mes) {
            this.mes = mes;
        }

        public int getSize() {
            return this.mes.length;
        }

        public Object getElementAt(int index) {
            return this.mes[index].getLocalizedName();
        }
    }

    public static class NbPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private NbPlatform[] nbPlafs = NbPlatformListModel.getSortedPlatforms();
        private Object selectedPlaf;
        static final /* synthetic */ boolean $assertionsDisabled;

        private static NbPlatform[] getSortedPlatforms() {
            Set _platforms = NbPlatform.getPlatforms();
            NbPlatform[] platforms = _platforms.toArray(new NbPlatform[_platforms.size()]);
            Arrays.sort(platforms, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int res = Collator.getInstance().compare(((NbPlatform)o1).getLabel(), ((NbPlatform)o2).getLabel());
                    if (res != 0) {
                        return res;
                    }
                    return System.identityHashCode(o1) - System.identityHashCode(o2);
                }
            });
            return platforms;
        }

        public NbPlatformListModel() {
            if (this.nbPlafs.length > 0) {
                this.selectedPlaf = this.nbPlafs[0];
            }
        }

        public int getSize() {
            return this.nbPlafs.length;
        }

        public Object getElementAt(int index) {
            return index < this.nbPlafs.length ? this.nbPlafs[index] : null;
        }

        public void setSelectedItem(Object plaf) {
            if (!$assertionsDisabled && plaf != null && !(plaf instanceof NbPlatform)) {
                throw new AssertionError();
            }
            if (this.selectedPlaf != plaf) {
                this.selectedPlaf = plaf;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(NbPlatform plaf) {
            try {
                NbPlatform.removePlatform(plaf);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms();
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        NbPlatform addPlatform(String id, String destdir, String label) {
            try {
                NbPlatform plaf = NbPlatform.addPlatform(id, new File(destdir), NbPlatform.getDefaultPlatform().getHarnessLocation(), label);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms();
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                return plaf;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
                return null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory = PlatformComponentFactory.class$("org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory")) : class$org$netbeans$modules$apisupport$project$ui$platform$PlatformComponentFactory).desiredAssertionStatus();
        }
    }

    private static class NbPlatformListRenderer
    extends DefaultListCellRenderer {
        private NbPlatformListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            NbPlatform plaf = (NbPlatform)value;
            String text = plaf == null ? "" : plaf.getLabel();
            Component c = super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            if (plaf != null && !plaf.isValid()) {
                c.setForeground(INVALID_PLAF_COLOR);
            }
            return c;
        }
    }
}

