/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Stack;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.UpdateHelper;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.PlatformUiSupport;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppClientProjectGenerator {
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";
    private static final String MANIFEST_FILE = "MANIFEST.MF";

    private AppClientProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, String name, String mainClass, String j2eeLevel, String serverInstanceID) throws IOException {
        FileObject fo = AppClientProjectGenerator.createProjectDir(dir);
        FileObject srcRoot = fo.createFolder(DEFAULT_SRC_FOLDER);
        FileObject javaRoot = srcRoot.createFolder(DEFAULT_JAVA_FOLDER);
        FileObject confRoot = srcRoot.createFolder(DEFAULT_CONF_FOLDER);
        fo.createFolder(DEFAULT_TEST_FOLDER);
        String resource = "1.5".equals(j2eeLevel) ? "org-netbeans-modules-j2ee-clientproject/application-client-5.xml" : "org-netbeans-modules-j2ee-clientproject/application-client-1.4.xml";
        FileObject ddFile = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(resource), (FileObject)confRoot, (String)"application-client");
        AppClient appClient = DDProvider.getDefault().getDDRoot(ddFile);
        appClient.setDisplayName(name);
        appClient.write(ddFile);
        AntProjectHelper h = AppClientProjectGenerator.createProject(fo, name, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, mainClass, j2eeLevel, serverInstanceID);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put((Object)"source.root", (Object)DEFAULT_SRC_FOLDER);
        ep.setProperty("meta.inf", "${source.root}/conf");
        ep.setProperty("src.dir", "${source.root}/java");
        h.putProperties("nbproject/project.properties", ep);
        Project p = ProjectManager.getDefault().findProject(fo);
        ProjectManager.getDefault().saveProject(p);
        if (mainClass != null) {
            AppClientProjectGenerator.createMainClass(mainClass, javaRoot);
        }
        AppClientProjectGenerator.createManifest(confRoot, MANIFEST_FILE);
        return h;
    }

    public static AntProjectHelper importProject(final File dir, String name, final File[] sourceFolders, final File[] testFolders, File confFolder, File libFolder, String j2eeLevel, String serverInstanceID) throws IOException {
        FileObject appClientXML;
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        FileObject dirFO = AppClientProjectGenerator.createProjectDir(dir);
        final AntProjectHelper h = AppClientProjectGenerator.createProject(dirFO, name, null, null, confFolder.getAbsolutePath(), libFolder == null ? null : libFolder.getAbsolutePath(), null, null, j2eeLevel, serverInstanceID);
        final AppClientProject p = (AppClientProject)ProjectManager.getDefault().findProject(dirFO);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props;
                    Element root;
                    String propName;
                    int i;
                    Element data = h.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "source-roots");
                    assert (nl.getLength() == 1);
                    Element sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "test-roots");
                    assert (nl.getLength() == 1);
                    Element testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = refHelper.createForeignFileReference(sourceFolders[i], AppClientProjectGenerator.DEFAULT_JAVA_FOLDER);
                        root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                        root.setAttribute("id", propName);
                        sourceRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName, (Object)srcReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders.length == 0) {
                        String testLoc = NbBundle.getMessage(AppClientProjectGenerator.class, (String)"TXT_DefaultTestFolderName");
                        File f = new File(dir, testLoc);
                        f.mkdirs();
                        String propName2 = "test.src.dir";
                        root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                        root.setAttribute("id", propName2);
                        root.setAttribute("name", NbBundle.getMessage(AppClientProjectGenerator.class, (String)"NAME_test.src.dir"));
                        testRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName2, (Object)testLoc);
                        h.putProperties("nbproject/project.properties", props);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                testFolders[i].mkdirs();
                            }
                            propName = "test.src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                            String testReference = refHelper.createForeignFileReference(testFolders[i], AppClientProjectGenerator.DEFAULT_JAVA_FOLDER);
                            root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                            root.setAttribute("id", propName);
                            testRoots.appendChild(root);
                            props = h.getProperties("nbproject/project.properties");
                            props.put((Object)propName, (Object)testReference);
                            h.putProperties("nbproject/project.properties", props);
                        }
                    }
                    h.putPrimaryConfigurationData(data, true);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me);
        }
        FileObject confFolderFO = FileUtil.toFileObject((File)confFolder);
        FileObject fileObject = appClientXML = confFolderFO == null ? null : confFolderFO.getFileObject("application-client.xml");
        if (appClientXML != null) {
            try {
                String dispName;
                AppClient root = DDProvider.getDefault().getDDRoot(appClientXML);
                boolean writeDD = false;
                if (new BigDecimal("1.3").equals(root.getVersion()) && "1.4".equals(j2eeLevel)) {
                    root.setVersion(new BigDecimal("1.4"));
                    writeDD = true;
                }
                if (null == (dispName = root.getDefaultDisplayName()) || dispName.trim().length() == 0) {
                    root.setDisplayName(name);
                    writeDD = true;
                }
                if (writeDD) {
                    root.write(appClientXML);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            String resource = "1.5".equals(j2eeLevel) ? "org-netbeans-modules-j2ee-clientproject/application-client-5.xml" : "org-netbeans-modules-j2ee-clientproject/application-client-1.4.xml";
            FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(resource), (FileObject)confFolderFO, (String)"application-client");
        }
        AppClientProjectGenerator.createManifest(confFolderFO, MANIFEST_FILE);
        return h;
    }

    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File confFolder, File libFolder, String j2eeLevel, String serverInstanceID, boolean fromJavaSource) throws IOException {
        AntProjectHelper h = AppClientProjectGenerator.importProject(dir, name, sourceFolders, testFolders, confFolder, libFolder, j2eeLevel, serverInstanceID);
        EditableProperties subEp = h.getProperties("nbproject/project.properties");
        subEp.setProperty("java.source.based", fromJavaSource + "");
        h.putProperties("nbproject/project.properties", subEp);
        Project subP = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ProjectManager.getDefault().saveProject(subP);
        return h;
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, String srcRoot, String testRoot, String configFiles, String libraries, String resources, String mainClass, String j2eeLevel, String serverInstanceID) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.j2ee.clientproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
            root.setAttribute("id", "src.dir");
            root.setAttribute("name", NbBundle.getMessage(AppClientProjectGenerator.class, (String)"NAME_src.dir"));
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
            root.setAttribute("id", "test.src.dir");
            root.setAttribute("name", NbBundle.getMessage(AppClientProjectGenerator.class, (String)"NAME_test.src.dir"));
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        if (configFiles != null) {
            ep.setProperty("meta.inf", configFiles);
        }
        if (libraries != null) {
            ep.setProperty("lib.dir", libraries);
        }
        if (resources != null) {
            ep.setProperty("resource.dir", resources);
        } else {
            ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        ep.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("build.ear.classes.dir", "${build.dir}/ear-module");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("javac.classpath", new String[0]);
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setProperty("jar.compress", "false");
        if (mainClass != null) {
            ep.setProperty("main.class", mainClass);
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.source", "${default.javac.source}");
        ep.setProperty("javac.target", "${default.javac.target}");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/jar");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("run.jvmargs", "");
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "");
        ep.setProperty("javadoc.additionalparam", "");
        Deployment deployment = Deployment.getDefault();
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        if (!j2eePlatform.getSupportedSpecVersions(J2eeModule.CLIENT).contains(j2eeLevel)) {
            ErrorManager.getDefault().log(16, "J2EE level:" + j2eeLevel + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID) + " for module type CLIENT");
        }
        ep.setProperty("j2ee.server.type", deployment.getServerID(serverInstanceID));
        ep.setProperty("j2ee.platform", j2eeLevel);
        ep.setProperty("manifest.file", "${meta.inf}/MANIFEST.MF");
        String mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "main.class.args");
        if (mainClassArgs != null && !mainClassArgs.equals("")) {
            ep.put((Object)"j2ee.appclient.mainclass.args", (Object)mainClassArgs);
        } else {
            mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "j2ee.clientName");
            if (mainClassArgs != null) {
                ep.put((Object)"j2ee.clientName", (Object)mainClassArgs);
            }
        }
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        File[] accrt = j2eePlatform.getToolClasspathEntries("appClientRuntime");
        ep.setProperty("j2ee.appclient.tool.runtime", Utils.toClasspathString(accrt));
        ep.setProperty("j2ee.appclient.tool.mainclass", j2eePlatform.getToolProperty("appClientRuntime", "main.class"));
        ep.setProperty("j2ee.appclient.tool.jvmoptions", j2eePlatform.getToolProperty("appClientRuntime", "jvm.opts"));
        String args = j2eePlatform.getToolProperty("appClientRuntime", "j2ee.appclient.args");
        if (args != null) {
            ep.setProperty("j2ee.appclient.tool.args", args);
        }
        ep.setProperty("j2ee.server.instance", serverInstanceID);
        String classpath = Utils.toClasspathString(j2eePlatform.getClasspathEntries());
        ep.setProperty("j2ee.platform.classpath", classpath);
        if (j2eePlatform.isToolSupported("wscompile")) {
            File[] wsClasspath = j2eePlatform.getToolClasspathEntries("wscompile");
            ep.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(wsClasspath));
        }
        if ("J2EE".equals(deployment.getServerID(serverInstanceID))) {
            File asRoot = j2eePlatform.getPlatformRoots()[0];
            File exFile = new File(asRoot, "lib/javaee.jar");
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)serverInstanceID);
            if (exFile.exists()) {
                ep.setProperty("wa.copy.client.jar.from", new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/generated/xml/j2ee-modules").getAbsolutePath());
            } else {
                ep.setProperty("wa.copy.client.jar.from", new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/applications/j2ee-modules").getAbsolutePath());
            }
        } else {
            ep.remove((Object)"wa.copy.client.jar.from");
        }
        File projectFolder = FileUtil.toFile((FileObject)dirFO);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, "nbproject/ant-deploy.xml"), (Object)J2eeModule.CLIENT, (String)serverInstanceID);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
        if (deployAntPropsFile != null) {
            ep.setProperty("deploy.ant.properties.file", deployAntPropsFile.getAbsolutePath());
        }
        h.putProperties("nbproject/private/private.properties", ep);
        return h;
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            AppClientProjectGenerator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void createMainClass(String mainClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject mainTemplate = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Main.java");
        if (mainTemplate == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    public static void setPlatform(final AntProjectHelper helper, final String platformName, final String sourceLevel) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    AppClientProject project = (AppClientProject)ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                    UpdateHelper updateHelper = project.getUpdateHelper();
                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                    String finalPlatformName = platformName;
                    if (finalPlatformName == null) {
                        finalPlatformName = JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
                    }
                    PlatformUiSupport.storePlatform(ep, updateHelper, finalPlatformName, sourceLevel != null ? new SpecificationVersion(sourceLevel) : null);
                    helper.putProperties("nbproject/project.properties", ep);
                    ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String path) throws IOException {
        if (dir.getFileObject(path) == null) {
            FileObject manifest = FileUtil.createData((FileObject)dir, (String)path);
            FileLock lock = manifest.lock();
            try {
                OutputStream os = manifest.getOutputStream(lock);
                try {
                    PrintWriter pw = new PrintWriter(os);
                    pw.println("Manifest-Version: 1.0");
                    pw.println("X-COMMENT: Main-Class will be added automatically by build");
                    pw.println();
                    pw.flush();
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }
}

