/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class BundleEditPanel
extends JPanel
implements PropertyChangeListener {
    private PropertiesDataObject obj;
    private DocumentListener listener;
    private static TableViewSettings settings;
    static final long serialVersionUID = -843810329041244483L;
    private JButton addButton;
    private JCheckBox autoResizeCheck;
    private JPanel buttonPanel;
    private JLabel commentLabel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JPanel tablePanel;
    private JTextArea textComment;
    private JTextArea textValue;
    private JLabel valueLabel;
    private JPanel valuePanel;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public BundleEditPanel(final PropertiesDataObject obj, PropertiesTableModel propTableModel) {
        this.obj = obj;
        this.initComponents();
        this.initAccessibility();
        this.initSettings();
        this.table.setColumnModel(new TableViewColumnModel());
        this.table.setModel(propTableModel);
        JTextField textField = new JTextField();
        textField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        textField.setBorder(new LineBorder(Color.black));
        textField.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSN_CellEditor"));
        textField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSD_CellEditor"));
        this.listener = new ModifiedListener();
        this.table.setDefaultEditor(PropertiesTableModel.StringPair.class, new PropertiesTableCellEditor(textField, this.textComment, this.textValue, this.valueLabel, this.listener));
        this.table.setDefaultRenderer(PropertiesTableModel.StringPair.class, new TableViewRenderer());
        this.updateAddButton();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("tableCellEditor")) {
                    BundleEditPanel.this.updateEnabled();
                } else if (evt.getPropertyName().equals("model")) {
                    BundleEditPanel.this.updateAddButton();
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = BundleEditPanel.this.table.getColumnModel();
                int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
                if (columnModelIndex < 0) {
                    return;
                }
                int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                obj.getBundleStructure().sort(modelIndex);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BundleEditPanel.this.updateSelection();
                    }
                });
            }
        });
    }

    protected void stopEditing() {
        if (!this.table.isEditing()) {
            return;
        }
        TableCellEditor cellEdit = this.table.getCellEditor();
        if (cellEdit != null) {
            cellEdit.stopCellEditing();
        }
    }

    private void updateEnabled() {
        this.textValue.setEditable(this.table.isEditing());
        this.textValue.setEnabled(this.table.isEditing());
        if (this.table.isEditing()) {
            PropertiesTableModel.StringPair sp = (PropertiesTableModel.StringPair)this.table.getCellEditor().getCellEditorValue();
            this.textComment.setEditable(sp.isCommentEditable());
            this.textComment.setEnabled(sp.isCommentEditable());
        } else {
            this.textComment.setEditable(false);
            this.textComment.setEnabled(false);
        }
    }

    private void updateSelection() {
        String comment;
        String value;
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        BundleStructure structure = this.obj.getBundleStructure();
        this.removeButton.setEnabled(row >= 0 && !structure.isReadOnly());
        if (column == -1) {
            value = "";
            comment = "";
        } else if (column == 0) {
            Element.ItemElem elem = structure.getItem(0, row);
            value = structure.keyAt(row);
            comment = elem.getComment();
        } else {
            Element.ItemElem elem = structure.getItem(column - 1, row);
            value = elem.getValue();
            comment = elem.getComment();
        }
        this.textValue.getDocument().removeDocumentListener(this.listener);
        this.textComment.getDocument().removeDocumentListener(this.listener);
        this.textValue.setText(value);
        this.textComment.setText(comment);
        this.textValue.getDocument().addDocumentListener(this.listener);
        this.textComment.getDocument().addDocumentListener(this.listener);
    }

    private void updateAddButton() {
        this.addButton.setEnabled(!this.obj.getBundleStructure().isReadOnly());
    }

    public JTable getTable() {
        return this.table;
    }

    private void initSettings() {
        settings = TableViewSettings.getDefault();
        settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)settings));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_BundleEditPanel"));
        this.commentLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_CommentLabel_Mnem").charAt(0));
        this.valueLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_ValueLabel_Mnem").charAt(0));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSN_CTL_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACSD_CTL_Table"));
        this.textValue.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_TEXTVALUE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_LBL_AddPropertyButton"));
        this.textComment.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_TEXTCOMMENT"));
        this.autoResizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_CTL_AutoResize"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)BundleEditPanel.class).getString("ACS_LBL_RemovePropertyButton"));
    }

    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    private void initComponents() {
        this.tablePanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new BundleTable();
        this.valuePanel = new JPanel();
        this.commentLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textComment = new JTextArea();
        this.valueLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.textValue = new JTextArea();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.autoResizeCheck = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setFocusCycleRoot(true);
        this.tablePanel.setLayout(new GridBagLayout());
        this.table.setCellSelectionEnabled(true);
        this.scrollPane.setViewportView(this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tablePanel, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.textComment);
        this.commentLabel.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_CommentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.commentLabel, gridBagConstraints);
        this.textComment.setEditable(false);
        this.textComment.setLineWrap(true);
        this.textComment.setRows(3);
        this.textComment.setEnabled(false);
        this.jScrollPane2.setViewportView(this.textComment);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.valueLabel.setLabelFor(this.textValue);
        this.valueLabel.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_ValueLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.valuePanel.add((Component)this.valueLabel, gridBagConstraints);
        this.textValue.setEditable(false);
        this.textValue.setLineWrap(true);
        this.textValue.setRows(3);
        this.textValue.setEnabled(false);
        this.jScrollPane3.setViewportView(this.textValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 11, 11, 0);
        this.valuePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.valuePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_AddPropertyButton_Mnem").charAt(0));
        this.addButton.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_AddPropertyButton"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_RemovePropertyButton_Mnem").charAt(0));
        this.removeButton.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("LBL_RemovePropertyButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.autoResizeCheck.setMnemonic(NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_AutoResize_Mnem").charAt(0));
        this.autoResizeCheck.setSelected(true);
        this.autoResizeCheck.setText(NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_AutoResize"));
        this.autoResizeCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.autoResizeCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.buttonPanel.add((Component)this.autoResizeCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void autoResizeCheckActionPerformed(ActionEvent evt) {
        if (this.autoResizeCheck.isSelected()) {
            this.table.setAutoResizeMode(4);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        this.stopEditing();
        String key = ((PropertiesTableModel.StringPair)this.table.getModel().getValueAt(selectedRow, 0)).getValue();
        if (key == null) {
            return;
        }
        NotifyDescriptor.Confirmation msg = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle((Class)BundleEditPanel.class).getString("MSG_DeleteKeyQuestion"), key), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)msg).equals(NotifyDescriptor.OK_OPTION)) {
            try {
                this.obj.getOpenSupport().atomicUndoRedoFlag = new Object();
                for (int i = 0; i < this.obj.getBundleStructure().getEntryCount(); ++i) {
                    PropertiesStructure ps;
                    PropertiesFileEntry entry = this.obj.getBundleStructure().getNthEntry(i);
                    if (entry == null || (ps = entry.getHandler().getStructure()) == null) continue;
                    ps.deleteItem(key);
                }
            }
            finally {
                this.obj.getOpenSupport().atomicUndoRedoFlag = null;
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.stopEditing();
        final Dialog[] dialog = new Dialog[1];
        final Element.ItemElem item = new Element.ItemElem(null, new Element.KeyElem(null, ""), new Element.ValueElem(null, ""), new Element.CommentElem(null, ""));
        PropertyPanel panel = new PropertyPanel(item);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getBundle((Class)BundleEditPanel.class).getString("CTL_NewPropertyTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt2) {
                if (evt2.getSource() == DialogDescriptor.OK_OPTION) {
                    dialog[0].setVisible(false);
                    dialog[0].dispose();
                    final String key = item.getKey();
                    String value = item.getValue();
                    String comment = item.getComment();
                    boolean keyAdded = false;
                    try {
                        ((BundleEditPanel)BundleEditPanel.this).obj.getOpenSupport().atomicUndoRedoFlag = new Object();
                        for (int i = 0; i < BundleEditPanel.this.obj.getBundleStructure().getEntryCount(); ++i) {
                            PropertiesFileEntry entry = BundleEditPanel.this.obj.getBundleStructure().getNthEntry(i);
                            if (entry != null && !entry.getHandler().getStructure().addItem(key, value, comment)) {
                                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$BundleEditPanel == null ? BundleEditPanel.class$("org.netbeans.modules.properties.BundleEditPanel") : class$org$netbeans$modules$properties$BundleEditPanel)).getString("MSG_KeyExists"), item.getKey(), Util.getLocaleLabel((MultiDataObject.Entry)entry)), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                                continue;
                            }
                            keyAdded = true;
                        }
                    }
                    finally {
                        ((BundleEditPanel)BundleEditPanel.this).obj.getOpenSupport().atomicUndoRedoFlag = null;
                    }
                    if (keyAdded) {
                        PropertiesRequestProcessor.getInstance().post(new Runnable(){

                            public void run() {
                                int rowIndex = BundleEditPanel.this.obj.getBundleStructure().getKeyIndexByName(key);
                                if (rowIndex != -1) {
                                    final int row = rowIndex;
                                    boolean column = true;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            Rectangle cellRect;
                                            if (BundleEditPanel.this.table.getAutoscrolls() && (cellRect = BundleEditPanel.this.table.getCellRect(row, 1, false)) != null) {
                                                BundleEditPanel.this.table.scrollRectToVisible(cellRect);
                                            }
                                            BundleEditPanel.this.table.getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
                                            BundleEditPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                                            BundleEditPanel.this.table.requestFocusInWindow();
                                            BundleEditPanel.this.table.editCellAt(row, 1);
                                        }
                                    });
                                }
                            }
                        });
                    }
                } else if (evt2.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    dialog[0].setVisible(false);
                    dialog[0].dispose();
                }
            }
        });
        dialog[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialog[0].show();
    }

    private class ModifiedListener
    implements DocumentListener {
        private ModifiedListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.documentModified();
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentModified();
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentModified();
        }

        private void documentModified() {
            BundleEditPanel.this.obj.setModified(true);
        }
    }

    static class BundleTable
    extends JTable {
        public BundleTable() {
            this.setRowHeight(this.getCellFontHeight() + 1);
        }

        public void removeEditorSilent() {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.removeCellEditorListener(this);
                if (this.editorComp != null) {
                    this.remove(this.editorComp);
                }
                Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(cellRect);
            }
        }

        private int getCellFontHeight() {
            FontMetrics fm;
            Font cellFont = UIManager.getFont("TextField.font");
            if (cellFont != null && (fm = this.getFontMetrics(cellFont)) != null) {
                return fm.getHeight();
            }
            return 14;
        }
    }

    private class TableViewRenderer
    extends DefaultTableCellRenderer {
        private TableViewRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            PropertiesTableModel.StringPair sp = (PropertiesTableModel.StringPair)value;
            this.setFont(settings.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            String text = null;
            if (sp.getValue() != null) {
                text = sp.getValue();
            }
            if (BasicHTML.isHTMLString(text)) {
                text = " " + text;
            }
            this.setValue(text == null ? "" : text);
            if (sp.isKeyType()) {
                this.setBackground(settings.getKeyBackground());
            } else if (sp.getValue() != null) {
                this.setBackground(settings.getValueBackground());
            } else {
                this.setBackground(settings.getShadowColor());
            }
            if (sp.isKeyType()) {
                this.setForeground(settings.getKeyColor());
            } else {
                this.setForeground(settings.getValueColor());
            }
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (FindPerformer.getFindPerformer(BundleEditPanel.this.table).isHighlightSearch()) {
                String text = this.getText();
                String findString = FindPerformer.getFindPerformer(BundleEditPanel.this.table).getFindString();
                if (text != null && text.length() > 0 && findString != null && findString.length() > 0) {
                    int index = 0;
                    int width = (int)g.getFontMetrics().getStringBounds(findString, g).getWidth();
                    Color oldColor = g.getColor();
                    while ((index = text.indexOf(findString, index)) >= 0) {
                        int x = (int)g.getFontMetrics().getStringBounds(text.substring(0, index), g).getWidth() + this.getInsets().left;
                        g.setColor(settings.getHighlightBackground());
                        g.fillRect(x, 0, width, g.getClipBounds().height);
                        g.setColor(settings.getHighlightColor());
                        g.drawString(findString, x, -((int)g.getFontMetrics().getStringBounds(findString, g).getY()));
                        index += findString.length();
                    }
                    g.setColor(oldColor);
                }
            }
        }
    }

    private class TableViewColumnModel
    extends DefaultTableColumnModel {
        private AncestorListener ancestorListener;
        private final TableCellRenderer headerRenderer;

        private TableViewColumnModel() {
            this.headerRenderer = new TableViewHeaderRenderer();
        }

        public void addColumn(TableColumn aColumn) {
            if (aColumn == null) {
                throw new IllegalArgumentException("Object is null");
            }
            this.tableColumns.addElement(aColumn);
            aColumn.addPropertyChangeListener(this);
            this.adjustColumnWidths();
            aColumn.setHeaderRenderer(this.headerRenderer);
            this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
        }

        private void adjustColumnWidths() {
            int computedColumnWidth;
            Rectangle screenBounds = Utilities.getUsableScreenBounds();
            int columnWidth = screenBounds.width / 10;
            int totalWidth = 0;
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = BundleEditPanel.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, BundleEditPanel.this.table);
            if (tc != null) {
                totalWidth = tc.getBounds().width;
            } else if (this.ancestorListener == null) {
                this.ancestorListener = new AncestorListener(){

                    public void ancestorAdded(AncestorEvent evt) {
                        if (evt.getAncestor() instanceof TopComponent) {
                            TableViewColumnModel.this.adjustColumnWidths();
                            BundleEditPanel.this.table.removeAncestorListener(TableViewColumnModel.this.ancestorListener);
                            TableViewColumnModel.this.ancestorListener = null;
                        }
                    }

                    public void ancestorMoved(AncestorEvent evt) {
                    }

                    public void ancestorRemoved(AncestorEvent evt) {
                    }
                };
                BundleEditPanel.this.table.addAncestorListener(this.ancestorListener);
            }
            int remainder = 0;
            if ((totalWidth -= ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().left + ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().right + 12 + 11) > 0 && (computedColumnWidth = totalWidth / BundleEditPanel.this.table.getColumnCount()) > columnWidth) {
                columnWidth = computedColumnWidth - BundleEditPanel.this.table.getColumnModel().getColumnMargin();
                remainder = totalWidth % BundleEditPanel.this.table.getColumnCount();
            }
            for (int i = 0; i < BundleEditPanel.this.table.getColumnCount(); ++i) {
                TableColumn column = BundleEditPanel.this.table.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(columnWidth + remainder);
                    column.setWidth(columnWidth + remainder);
                    continue;
                }
                column.setPreferredWidth(columnWidth);
                column.setWidth(columnWidth);
            }
            this.recalcWidthCache();
            BundleEditPanel.this.table.revalidate();
            BundleEditPanel.this.table.getTableHeader().repaint();
        }
    }

    private class TableViewHeaderRenderer
    extends DefaultTableCellRenderer {
        private int column;

        private TableViewHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            this.column = column;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int sortIndex = BundleEditPanel.this.table.convertColumnIndexToView(BundleEditPanel.this.obj.getBundleStructure().getSortIndex());
            if (this.column == sortIndex) {
                int y3;
                int y2;
                int y1;
                int x3;
                int x2;
                int x1;
                Color oldColor = g.getColor();
                FontMetrics fm = g.getFontMetrics();
                Rectangle space = fm.getStringBounds(" ", g).getBounds();
                Rectangle mark = fm.getStringBounds("\u25b2", g).getBounds();
                Rectangle bounds = this.getBounds();
                Insets insets = this.getInsets();
                BorderUIResource.BevelBorderUIResource bevelUI = (BorderUIResource.BevelBorderUIResource)BorderUIResource.getLoweredBevelBorderUIResource();
                boolean ascending = BundleEditPanel.this.obj.getBundleStructure().getSortOrder();
                if (ascending) {
                    x1 = space.width + mark.width / 2;
                    x2 = space.width;
                    x3 = space.width + mark.width;
                    y1 = bounds.y + insets.top + 2;
                    y3 = y2 = bounds.y + bounds.height - insets.bottom - 2;
                } else {
                    x1 = space.width;
                    x2 = space.width + mark.width;
                    x3 = space.width + mark.width / 2;
                    y2 = y1 = bounds.y + insets.top + 2;
                    y3 = bounds.y + bounds.height - insets.bottom - 2;
                }
                g.setColor(bevelUI.getShadowOuterColor(this));
                if (ascending) {
                    g.drawLine(x1, y1, x2, y2);
                } else {
                    g.drawPolyline(new int[]{x2, x1, x3}, new int[]{y2, y1, y3}, 3);
                }
                g.setColor(bevelUI.getShadowInnerColor(this));
                if (ascending) {
                    g.drawLine(x1, y1 + 1, x2 + 1, y2 - 1);
                } else {
                    g.drawPolyline(new int[]{x2 - 1, x1 + 1, x3}, new int[]{y2 + 1, y1 + 1, y3 - 1}, 3);
                }
                g.setColor(bevelUI.getHighlightOuterColor(this));
                if (ascending) {
                    g.drawPolyline(new int[]{x1, x3, x2}, new int[]{y1, y3, y2}, 3);
                } else {
                    g.drawLine(x2, y2, x3, y3);
                }
                g.setColor(bevelUI.getHighlightInnerColor(this));
                if (ascending) {
                    g.drawPolyline(new int[]{x1, x3 - 1, x2 + 1}, new int[]{y1 + 1, y3 - 1, y2 - 1}, 3);
                } else {
                    g.drawLine(x2 - 1, y2 + 1, x3, y3 - 1);
                }
                g.setColor(oldColor);
            }
        }
    }
}

