/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

public class TConversionTool {
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] exp_lut1;
    private static short[] u2l;
    private static final byte QUANT_MASK = 15;
    private static final byte SEG_SHIFT = 4;
    private static final short[] seg_end;
    private static short[] a2l;
    private static byte[] u2a;
    private static byte[] a2u;

    public static void convertSign8(byte[] byArray, int n, int n2) {
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] + 128);
        }
    }

    public static void swapOrder16(byte[] byArray, int n, int n2) {
        int n3 = n2 * 2 + n - 1;
        int n4 = n;
        while (n4 < n3) {
            byte by = byArray[n4];
            byArray[n4++] = byArray[n4];
            byArray[n4++] = by;
        }
    }

    public static void swapOrder24(byte[] byArray, int n, int n2) {
        int n3 = n2 * 3 + n - 2;
        int n4 = n;
        while (n4 < n3) {
            byte by = byArray[n4];
            byArray[n4++] = byArray[n4 + 1];
            byArray[++n4] = by;
            ++n4;
        }
    }

    public static void swapOrder32(byte[] byArray, int n, int n2) {
        int n3 = n2 * 4 + n - 3;
        int n4 = n;
        while (n4 < n3) {
            byte by = byArray[n4];
            byArray[n4] = byArray[n4 + 3];
            byArray[n4 + 3] = by;
            by = byArray[++n4];
            byArray[n4++] = byArray[n4];
            byArray[n4++] = by;
            ++n4;
        }
    }

    public static void convertSign8(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = (byte)(byArray[n++] + 128);
            --n3;
        }
    }

    public static void swapOrder16(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n++];
            ++n;
            --n3;
        }
    }

    public static void swapOrder24(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 2];
            int n4 = ++n2;
            ++n2;
            byArray2[n4] = byArray[n++];
            ++n;
            ++n;
            --n3;
        }
    }

    public static void swapOrder32(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3 > 0) {
            byArray2[n2++] = byArray[n + 3];
            byArray2[n2++] = byArray[n + 2];
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n++];
            ++n;
            ++n;
            ++n;
            --n3;
        }
    }

    public static short bytesToShort16(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    public static short bytesToShort16(byte[] byArray, int n, boolean bl) {
        return bl ? (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF) : (short)(byArray[n + 1] << 8 | byArray[n] & 0xFF);
    }

    public static int bytesToInt16(byte by, byte by2) {
        return by << 8 | by2 & 0xFF;
    }

    public static int bytesToInt16(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 8 | byArray[n + 1] & 0xFF : byArray[n + 1] << 8 | byArray[n] & 0xFF;
    }

    public static int bytesToInt24(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF : byArray[n + 2] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int bytesToInt32(byte[] byArray, int n, boolean bl) {
        return bl ? byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF : byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static void shortToBytes16(short s, byte[] byArray, int n, boolean bl) {
        TConversionTool.intToBytes16(s, byArray, n, bl);
    }

    public static void intToBytes16(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2] = (byte)(n >> 8);
        }
    }

    public static void intToBytes24(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n >> 16);
        }
    }

    public static void intToBytes32(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 24);
            byArray[n2++] = (byte)(n >>> 16 & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2] = (byte)(n & 0xFF);
        } else {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)(n >>> 8 & 0xFF);
            byArray[n2++] = (byte)(n >>> 16 & 0xFF);
            byArray[n2] = (byte)(n >> 24);
        }
    }

    public static byte linear2ulaw(int n) {
        int n2;
        int n3;
        int n4;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n5 = n >> 8 & 0x80;
        if (n5 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((n4 = ~(n5 | (n3 = exp_lut1[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> n3 + 3 & 0xF))) == 0) {
            n4 = 2;
        }
        return (byte)n4;
    }

    public static short ulaw2linear(byte by) {
        return u2l[by & 0xFF];
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm162ulaw(byte[] var0, int var1_1, int var2_2, boolean var3_3) {
        block2: {
            var5_5 = var4_4 = var1_1;
            if (!var3_3) ** GOTO lbl14
            while (var2_2 > 0) {
                var0[var5_5++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(var0[var4_4], var0[var4_4 + 1]));
                ++var4_4;
                ++var4_4;
                --var2_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var0[var5_5++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(var0[var4_4 + 1], var0[var4_4]));
                ++var4_4;
                ++var4_4;
                --var2_2;
lbl14:
                // 2 sources

                ** while (var2_2 > 0)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm162ulaw(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var1_1;
            var7_7 = var3_3;
            if (!var5_5) ** GOTO lbl15
            while (var4_4 > 0) {
                var2_2[var7_7++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(var0[var6_6], var0[var6_6 + 1]));
                ++var6_6;
                ++var6_6;
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var7_7++] = TConversionTool.linear2ulaw(TConversionTool.bytesToInt16(var0[var6_6 + 1], var0[var6_6]));
                ++var6_6;
                ++var6_6;
                --var4_4;
lbl15:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static void pcm82ulaw(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            int n3 = n;
            while (n3 < n2) {
                byArray[n3] = TConversionTool.linear2ulaw(byArray[n3] << 8);
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                byArray[n4] = TConversionTool.linear2ulaw((byte)(byArray[n4] + 128) << 8);
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm82ulaw(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var3_3;
            var7_7 = var1_1;
            if (!var5_5) ** GOTO lbl11
            while (var4_4 > 0) {
                var2_2[var6_6++] = TConversionTool.linear2ulaw(var0[var7_7++] << 8);
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var6_6++] = TConversionTool.linear2ulaw((byte)(var0[var7_7++] + 128) << 8);
                --var4_4;
lbl11:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static void ulaw2pcm16(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            TConversionTool.intToBytes16(u2l[byArray[n5++] & 0xFF], byArray2, n4++, bl);
            ++n4;
            --n3;
        }
    }

    public static void ulaw2pcm8(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            int n3 = n;
            while (n3 < n2) {
                byArray[n3] = (byte)(u2l[byArray[n3] & 0xFF] >> 8 & 0xFF);
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                byArray[n4] = (byte)((u2l[byArray[n4] & 0xFF] >> 8) + 128);
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void ulaw2pcm8(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var1_1;
            var7_7 = var3_3;
            if (!var5_5) ** GOTO lbl11
            while (var4_4 > 0) {
                var2_2[var7_7++] = (byte)(TConversionTool.u2l[var0[var6_6++] & 255] >> 8 & 255);
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var7_7++] = (byte)((TConversionTool.u2l[var0[var6_6++] & 255] >> 8) + 128);
                --var4_4;
lbl11:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static byte linear2alaw(short s) {
        int n;
        int n2 = 8;
        if (s >= 0) {
            n = -43;
        } else {
            n = 85;
            s = (short)(-s - 8);
        }
        int n3 = 0;
        while (n3 < 8) {
            if (s <= seg_end[n3]) {
                n2 = (byte)n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 8) {
            return (byte)((0x7F ^ n) & 0xFF);
        }
        byte by = (byte)(n2 << 4);
        by = n2 < 2 ? (byte)(by | s >> 4 & 0xF) : (byte)(by | s >> n2 + 3 & 0xF);
        return (byte)((by ^ n) & 0xFF);
    }

    public static short alaw2linear(byte by) {
        return a2l[by & 0xFF];
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm162alaw(byte[] var0, int var1_1, int var2_2, boolean var3_3) {
        block2: {
            var5_5 = var4_4 = var1_1;
            if (!var3_3) ** GOTO lbl14
            while (var2_2 > 0) {
                var0[var5_5++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(var0[var4_4], var0[var4_4 + 1]));
                ++var4_4;
                ++var4_4;
                --var2_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var0[var5_5++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(var0[var4_4 + 1], var0[var4_4]));
                ++var4_4;
                ++var4_4;
                --var2_2;
lbl14:
                // 2 sources

                ** while (var2_2 > 0)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm162alaw(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var1_1;
            var7_7 = var3_3;
            if (!var5_5) ** GOTO lbl15
            while (var4_4 > 0) {
                var2_2[var7_7++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(var0[var6_6], var0[var6_6 + 1]));
                ++var6_6;
                ++var6_6;
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var7_7++] = TConversionTool.linear2alaw(TConversionTool.bytesToShort16(var0[var6_6 + 1], var0[var6_6]));
                ++var6_6;
                ++var6_6;
                --var4_4;
lbl15:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static void pcm82alaw(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            int n3 = n;
            while (n3 < n2) {
                byArray[n3] = TConversionTool.linear2alaw((short)(byArray[n3] << 8));
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                byArray[n4] = TConversionTool.linear2alaw((short)((byte)(byArray[n4] + 128) << 8));
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pcm82alaw(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var3_3;
            var7_7 = var1_1;
            if (!var5_5) ** GOTO lbl11
            while (var4_4 > 0) {
                var2_2[var6_6++] = TConversionTool.linear2alaw((short)(var0[var7_7++] << 8));
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var6_6++] = TConversionTool.linear2alaw((short)((byte)(var0[var7_7++] + 128) << 8));
                --var4_4;
lbl11:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static void alaw2pcm8(byte[] byArray, int n, int n2, boolean bl) {
        n2 += n;
        if (bl) {
            int n3 = n;
            while (n3 < n2) {
                byArray[n3] = (byte)(a2l[byArray[n3] & 0xFF] >> 8 & 0xFF);
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                byArray[n4] = (byte)((a2l[byArray[n4] & 0xFF] >> 8) + 128);
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void alaw2pcm8(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            var6_6 = var1_1;
            var7_7 = var3_3;
            if (!var5_5) ** GOTO lbl11
            while (var4_4 > 0) {
                var2_2[var7_7++] = (byte)(TConversionTool.a2l[var0[var6_6++] & 255] >> 8 & 255);
                --var4_4;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2[var7_7++] = (byte)((TConversionTool.a2l[var0[var6_6++] & 255] >> 8) + 128);
                --var4_4;
lbl11:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
    }

    public static void alaw2pcm16(byte[] byArray, int n, byte[] byArray2, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            TConversionTool.intToBytes16(a2l[byArray[n5++] & 0xFF], byArray2, n4++, bl);
            ++n4;
            --n3;
        }
    }

    public static byte ulaw2alaw(byte by) {
        return u2a[by & 0xFF];
    }

    public static void ulaw2alaw(byte[] byArray, int n, int n2) {
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = u2a[byArray[n3] & 0xFF];
            ++n3;
        }
    }

    public static void ulaw2alaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            byArray2[n5++] = u2a[byArray[n4++] & 0xFF];
            --n3;
        }
    }

    public static byte alaw2ulaw(byte by) {
        return a2u[by & 0xFF];
    }

    public static void alaw2ulaw(byte[] byArray, int n, int n2) {
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = a2u[byArray[n3] & 0xFF];
            ++n3;
        }
    }

    public static void alaw2ulaw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n3 > 0) {
            byArray2[n4++] = a2u[byArray[n5++] & 0xFF];
            --n3;
        }
    }

    public static void changeOrderOrSign(byte[] byArray, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                TConversionTool.convertSign8(byArray, n, n2);
                break;
            }
            case 2: {
                TConversionTool.swapOrder16(byArray, n, n2 / 2);
                break;
            }
            case 3: {
                TConversionTool.swapOrder24(byArray, n, n2 / 3);
                break;
            }
            case 4: {
                TConversionTool.swapOrder32(byArray, n, n2 / 4);
                break;
            }
        }
    }

    public static void changeOrderOrSign(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                TConversionTool.convertSign8(byArray, n, byArray2, n2, n3);
                break;
            }
            case 2: {
                TConversionTool.swapOrder16(byArray, n, byArray2, n2, n3 / 2);
                break;
            }
            case 3: {
                TConversionTool.swapOrder24(byArray, n, byArray2, n2, n3 / 3);
                break;
            }
            case 4: {
                TConversionTool.swapOrder32(byArray, n, byArray2, n2, n3 / 4);
                break;
            }
        }
    }

    static {
        int[] nArray = new int[256];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 4;
        nArray[27] = 4;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 4;
        nArray[31] = 4;
        nArray[32] = 5;
        nArray[33] = 5;
        nArray[34] = 5;
        nArray[35] = 5;
        nArray[36] = 5;
        nArray[37] = 5;
        nArray[38] = 5;
        nArray[39] = 5;
        nArray[40] = 5;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 5;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 5;
        nArray[52] = 5;
        nArray[53] = 5;
        nArray[54] = 5;
        nArray[55] = 5;
        nArray[56] = 5;
        nArray[57] = 5;
        nArray[58] = 5;
        nArray[59] = 5;
        nArray[60] = 5;
        nArray[61] = 5;
        nArray[62] = 5;
        nArray[63] = 5;
        nArray[64] = 6;
        nArray[65] = 6;
        nArray[66] = 6;
        nArray[67] = 6;
        nArray[68] = 6;
        nArray[69] = 6;
        nArray[70] = 6;
        nArray[71] = 6;
        nArray[72] = 6;
        nArray[73] = 6;
        nArray[74] = 6;
        nArray[75] = 6;
        nArray[76] = 6;
        nArray[77] = 6;
        nArray[78] = 6;
        nArray[79] = 6;
        nArray[80] = 6;
        nArray[81] = 6;
        nArray[82] = 6;
        nArray[83] = 6;
        nArray[84] = 6;
        nArray[85] = 6;
        nArray[86] = 6;
        nArray[87] = 6;
        nArray[88] = 6;
        nArray[89] = 6;
        nArray[90] = 6;
        nArray[91] = 6;
        nArray[92] = 6;
        nArray[93] = 6;
        nArray[94] = 6;
        nArray[95] = 6;
        nArray[96] = 6;
        nArray[97] = 6;
        nArray[98] = 6;
        nArray[99] = 6;
        nArray[100] = 6;
        nArray[101] = 6;
        nArray[102] = 6;
        nArray[103] = 6;
        nArray[104] = 6;
        nArray[105] = 6;
        nArray[106] = 6;
        nArray[107] = 6;
        nArray[108] = 6;
        nArray[109] = 6;
        nArray[110] = 6;
        nArray[111] = 6;
        nArray[112] = 6;
        nArray[113] = 6;
        nArray[114] = 6;
        nArray[115] = 6;
        nArray[116] = 6;
        nArray[117] = 6;
        nArray[118] = 6;
        nArray[119] = 6;
        nArray[120] = 6;
        nArray[121] = 6;
        nArray[122] = 6;
        nArray[123] = 6;
        nArray[124] = 6;
        nArray[125] = 6;
        nArray[126] = 6;
        nArray[127] = 6;
        nArray[128] = 7;
        nArray[129] = 7;
        nArray[130] = 7;
        nArray[131] = 7;
        nArray[132] = 7;
        nArray[133] = 7;
        nArray[134] = 7;
        nArray[135] = 7;
        nArray[136] = 7;
        nArray[137] = 7;
        nArray[138] = 7;
        nArray[139] = 7;
        nArray[140] = 7;
        nArray[141] = 7;
        nArray[142] = 7;
        nArray[143] = 7;
        nArray[144] = 7;
        nArray[145] = 7;
        nArray[146] = 7;
        nArray[147] = 7;
        nArray[148] = 7;
        nArray[149] = 7;
        nArray[150] = 7;
        nArray[151] = 7;
        nArray[152] = 7;
        nArray[153] = 7;
        nArray[154] = 7;
        nArray[155] = 7;
        nArray[156] = 7;
        nArray[157] = 7;
        nArray[158] = 7;
        nArray[159] = 7;
        nArray[160] = 7;
        nArray[161] = 7;
        nArray[162] = 7;
        nArray[163] = 7;
        nArray[164] = 7;
        nArray[165] = 7;
        nArray[166] = 7;
        nArray[167] = 7;
        nArray[168] = 7;
        nArray[169] = 7;
        nArray[170] = 7;
        nArray[171] = 7;
        nArray[172] = 7;
        nArray[173] = 7;
        nArray[174] = 7;
        nArray[175] = 7;
        nArray[176] = 7;
        nArray[177] = 7;
        nArray[178] = 7;
        nArray[179] = 7;
        nArray[180] = 7;
        nArray[181] = 7;
        nArray[182] = 7;
        nArray[183] = 7;
        nArray[184] = 7;
        nArray[185] = 7;
        nArray[186] = 7;
        nArray[187] = 7;
        nArray[188] = 7;
        nArray[189] = 7;
        nArray[190] = 7;
        nArray[191] = 7;
        nArray[192] = 7;
        nArray[193] = 7;
        nArray[194] = 7;
        nArray[195] = 7;
        nArray[196] = 7;
        nArray[197] = 7;
        nArray[198] = 7;
        nArray[199] = 7;
        nArray[200] = 7;
        nArray[201] = 7;
        nArray[202] = 7;
        nArray[203] = 7;
        nArray[204] = 7;
        nArray[205] = 7;
        nArray[206] = 7;
        nArray[207] = 7;
        nArray[208] = 7;
        nArray[209] = 7;
        nArray[210] = 7;
        nArray[211] = 7;
        nArray[212] = 7;
        nArray[213] = 7;
        nArray[214] = 7;
        nArray[215] = 7;
        nArray[216] = 7;
        nArray[217] = 7;
        nArray[218] = 7;
        nArray[219] = 7;
        nArray[220] = 7;
        nArray[221] = 7;
        nArray[222] = 7;
        nArray[223] = 7;
        nArray[224] = 7;
        nArray[225] = 7;
        nArray[226] = 7;
        nArray[227] = 7;
        nArray[228] = 7;
        nArray[229] = 7;
        nArray[230] = 7;
        nArray[231] = 7;
        nArray[232] = 7;
        nArray[233] = 7;
        nArray[234] = 7;
        nArray[235] = 7;
        nArray[236] = 7;
        nArray[237] = 7;
        nArray[238] = 7;
        nArray[239] = 7;
        nArray[240] = 7;
        nArray[241] = 7;
        nArray[242] = 7;
        nArray[243] = 7;
        nArray[244] = 7;
        nArray[245] = 7;
        nArray[246] = 7;
        nArray[247] = 7;
        nArray[248] = 7;
        nArray[249] = 7;
        nArray[250] = 7;
        nArray[251] = 7;
        nArray[252] = 7;
        nArray[253] = 7;
        nArray[254] = 7;
        nArray[255] = 7;
        exp_lut1 = nArray;
        short[] sArray = new short[256];
        sArray[0] = -32124;
        sArray[1] = -31100;
        sArray[2] = -30076;
        sArray[3] = -29052;
        sArray[4] = -28028;
        sArray[5] = -27004;
        sArray[6] = -25980;
        sArray[7] = -24956;
        sArray[8] = -23932;
        sArray[9] = -22908;
        sArray[10] = -21884;
        sArray[11] = -20860;
        sArray[12] = -19836;
        sArray[13] = -18812;
        sArray[14] = -17788;
        sArray[15] = -16764;
        sArray[16] = -15996;
        sArray[17] = -15484;
        sArray[18] = -14972;
        sArray[19] = -14460;
        sArray[20] = -13948;
        sArray[21] = -13436;
        sArray[22] = -12924;
        sArray[23] = -12412;
        sArray[24] = -11900;
        sArray[25] = -11388;
        sArray[26] = -10876;
        sArray[27] = -10364;
        sArray[28] = -9852;
        sArray[29] = -9340;
        sArray[30] = -8828;
        sArray[31] = -8316;
        sArray[32] = -7932;
        sArray[33] = -7676;
        sArray[34] = -7420;
        sArray[35] = -7164;
        sArray[36] = -6908;
        sArray[37] = -6652;
        sArray[38] = -6396;
        sArray[39] = -6140;
        sArray[40] = -5884;
        sArray[41] = -5628;
        sArray[42] = -5372;
        sArray[43] = -5116;
        sArray[44] = -4860;
        sArray[45] = -4604;
        sArray[46] = -4348;
        sArray[47] = -4092;
        sArray[48] = -3900;
        sArray[49] = -3772;
        sArray[50] = -3644;
        sArray[51] = -3516;
        sArray[52] = -3388;
        sArray[53] = -3260;
        sArray[54] = -3132;
        sArray[55] = -3004;
        sArray[56] = -2876;
        sArray[57] = -2748;
        sArray[58] = -2620;
        sArray[59] = -2492;
        sArray[60] = -2364;
        sArray[61] = -2236;
        sArray[62] = -2108;
        sArray[63] = -1980;
        sArray[64] = -1884;
        sArray[65] = -1820;
        sArray[66] = -1756;
        sArray[67] = -1692;
        sArray[68] = -1628;
        sArray[69] = -1564;
        sArray[70] = -1500;
        sArray[71] = -1436;
        sArray[72] = -1372;
        sArray[73] = -1308;
        sArray[74] = -1244;
        sArray[75] = -1180;
        sArray[76] = -1116;
        sArray[77] = -1052;
        sArray[78] = -988;
        sArray[79] = -924;
        sArray[80] = -876;
        sArray[81] = -844;
        sArray[82] = -812;
        sArray[83] = -780;
        sArray[84] = -748;
        sArray[85] = -716;
        sArray[86] = -684;
        sArray[87] = -652;
        sArray[88] = -620;
        sArray[89] = -588;
        sArray[90] = -556;
        sArray[91] = -524;
        sArray[92] = -492;
        sArray[93] = -460;
        sArray[94] = -428;
        sArray[95] = -396;
        sArray[96] = -372;
        sArray[97] = -356;
        sArray[98] = -340;
        sArray[99] = -324;
        sArray[100] = -308;
        sArray[101] = -292;
        sArray[102] = -276;
        sArray[103] = -260;
        sArray[104] = -244;
        sArray[105] = -228;
        sArray[106] = -212;
        sArray[107] = -196;
        sArray[108] = -180;
        sArray[109] = -164;
        sArray[110] = -148;
        sArray[111] = -132;
        sArray[112] = -120;
        sArray[113] = -112;
        sArray[114] = -104;
        sArray[115] = -96;
        sArray[116] = -88;
        sArray[117] = -80;
        sArray[118] = -72;
        sArray[119] = -64;
        sArray[120] = -56;
        sArray[121] = -48;
        sArray[122] = -40;
        sArray[123] = -32;
        sArray[124] = -24;
        sArray[125] = -16;
        sArray[126] = -8;
        sArray[128] = 32124;
        sArray[129] = 31100;
        sArray[130] = 30076;
        sArray[131] = 29052;
        sArray[132] = 28028;
        sArray[133] = 27004;
        sArray[134] = 25980;
        sArray[135] = 24956;
        sArray[136] = 23932;
        sArray[137] = 22908;
        sArray[138] = 21884;
        sArray[139] = 20860;
        sArray[140] = 19836;
        sArray[141] = 18812;
        sArray[142] = 17788;
        sArray[143] = 16764;
        sArray[144] = 15996;
        sArray[145] = 15484;
        sArray[146] = 14972;
        sArray[147] = 14460;
        sArray[148] = 13948;
        sArray[149] = 13436;
        sArray[150] = 12924;
        sArray[151] = 12412;
        sArray[152] = 11900;
        sArray[153] = 11388;
        sArray[154] = 10876;
        sArray[155] = 10364;
        sArray[156] = 9852;
        sArray[157] = 9340;
        sArray[158] = 8828;
        sArray[159] = 8316;
        sArray[160] = 7932;
        sArray[161] = 7676;
        sArray[162] = 7420;
        sArray[163] = 7164;
        sArray[164] = 6908;
        sArray[165] = 6652;
        sArray[166] = 6396;
        sArray[167] = 6140;
        sArray[168] = 5884;
        sArray[169] = 5628;
        sArray[170] = 5372;
        sArray[171] = 5116;
        sArray[172] = 4860;
        sArray[173] = 4604;
        sArray[174] = 4348;
        sArray[175] = 4092;
        sArray[176] = 3900;
        sArray[177] = 3772;
        sArray[178] = 3644;
        sArray[179] = 3516;
        sArray[180] = 3388;
        sArray[181] = 3260;
        sArray[182] = 3132;
        sArray[183] = 3004;
        sArray[184] = 2876;
        sArray[185] = 2748;
        sArray[186] = 2620;
        sArray[187] = 2492;
        sArray[188] = 2364;
        sArray[189] = 2236;
        sArray[190] = 2108;
        sArray[191] = 1980;
        sArray[192] = 1884;
        sArray[193] = 1820;
        sArray[194] = 1756;
        sArray[195] = 1692;
        sArray[196] = 1628;
        sArray[197] = 1564;
        sArray[198] = 1500;
        sArray[199] = 1436;
        sArray[200] = 1372;
        sArray[201] = 1308;
        sArray[202] = 1244;
        sArray[203] = 1180;
        sArray[204] = 1116;
        sArray[205] = 1052;
        sArray[206] = 988;
        sArray[207] = 924;
        sArray[208] = 876;
        sArray[209] = 844;
        sArray[210] = 812;
        sArray[211] = 780;
        sArray[212] = 748;
        sArray[213] = 716;
        sArray[214] = 684;
        sArray[215] = 652;
        sArray[216] = 620;
        sArray[217] = 588;
        sArray[218] = 556;
        sArray[219] = 524;
        sArray[220] = 492;
        sArray[221] = 460;
        sArray[222] = 428;
        sArray[223] = 396;
        sArray[224] = 372;
        sArray[225] = 356;
        sArray[226] = 340;
        sArray[227] = 324;
        sArray[228] = 308;
        sArray[229] = 292;
        sArray[230] = 276;
        sArray[231] = 260;
        sArray[232] = 244;
        sArray[233] = 228;
        sArray[234] = 212;
        sArray[235] = 196;
        sArray[236] = 180;
        sArray[237] = 164;
        sArray[238] = 148;
        sArray[239] = 132;
        sArray[240] = 120;
        sArray[241] = 112;
        sArray[242] = 104;
        sArray[243] = 96;
        sArray[244] = 88;
        sArray[245] = 80;
        sArray[246] = 72;
        sArray[247] = 64;
        sArray[248] = 56;
        sArray[249] = 48;
        sArray[250] = 40;
        sArray[251] = 32;
        sArray[252] = 24;
        sArray[253] = 16;
        sArray[254] = 8;
        u2l = sArray;
        seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
        a2l = new short[]{-5504, -5248, -6016, -5760, -4480, -4224, -4992, -4736, -7552, -7296, -8064, -7808, -6528, -6272, -7040, -6784, -2752, -2624, -3008, -2880, -2240, -2112, -2496, -2368, -3776, -3648, -4032, -3904, -3264, -3136, -3520, -3392, -22016, -20992, -24064, -23040, -17920, -16896, -19968, -18944, -30208, -29184, -32256, -31232, -26112, -25088, -28160, -27136, -11008, -10496, -12032, -11520, -8960, -8448, -9984, -9472, -15104, -14592, -16128, -15616, -13056, -12544, -14080, -13568, -344, -328, -376, -360, -280, -264, -312, -296, -472, -456, -504, -488, -408, -392, -440, -424, -88, -72, -120, -104, -24, -8, -56, -40, -216, -200, -248, -232, -152, -136, -184, -168, -1376, -1312, -1504, -1440, -1120, -1056, -1248, -1184, -1888, -1824, -2016, -1952, -1632, -1568, -1760, -1696, -688, -656, -752, -720, -560, -528, -624, -592, -944, -912, -1008, -976, -816, -784, -880, -848, 5504, 5248, 6016, 5760, 4480, 4224, 4992, 4736, 7552, 7296, 8064, 7808, 6528, 6272, 7040, 6784, 2752, 2624, 3008, 2880, 2240, 2112, 2496, 2368, 3776, 3648, 4032, 3904, 3264, 3136, 3520, 3392, 22016, 20992, 24064, 23040, 17920, 16896, 19968, 18944, 30208, 29184, 32256, 31232, 26112, 25088, 28160, 27136, 11008, 10496, 12032, 11520, 8960, 8448, 9984, 9472, 15104, 14592, 16128, 15616, 13056, 12544, 14080, 13568, 344, 328, 376, 360, 280, 264, 312, 296, 472, 456, 504, 488, 408, 392, 440, 424, 88, 72, 120, 104, 24, 8, 56, 40, 216, 200, 248, 232, 152, 136, 184, 168, 1376, 1312, 1504, 1440, 1120, 1056, 1248, 1184, 1888, 1824, 2016, 1952, 1632, 1568, 1760, 1696, 688, 656, 752, 720, 560, 528, 624, 592, 944, 912, 1008, 976, 816, 784, 880, 848};
        byte[] byArray = new byte[256];
        byArray[0] = -86;
        byArray[1] = -85;
        byArray[2] = -88;
        byArray[3] = -87;
        byArray[4] = -82;
        byArray[5] = -81;
        byArray[6] = -84;
        byArray[7] = -83;
        byArray[8] = -94;
        byArray[9] = -93;
        byArray[10] = -96;
        byArray[11] = -95;
        byArray[12] = -90;
        byArray[13] = -89;
        byArray[14] = -92;
        byArray[15] = -91;
        byArray[16] = -70;
        byArray[17] = -69;
        byArray[18] = -72;
        byArray[19] = -71;
        byArray[20] = -66;
        byArray[21] = -65;
        byArray[22] = -68;
        byArray[23] = -67;
        byArray[24] = -78;
        byArray[25] = -77;
        byArray[26] = -80;
        byArray[27] = -79;
        byArray[28] = -74;
        byArray[29] = -73;
        byArray[30] = -76;
        byArray[31] = -75;
        byArray[32] = -118;
        byArray[33] = -117;
        byArray[34] = -120;
        byArray[35] = -119;
        byArray[36] = -114;
        byArray[37] = -113;
        byArray[38] = -116;
        byArray[39] = -115;
        byArray[40] = -126;
        byArray[41] = -125;
        byArray[42] = -128;
        byArray[43] = -127;
        byArray[44] = -122;
        byArray[45] = -121;
        byArray[46] = -124;
        byArray[47] = -123;
        byArray[48] = -101;
        byArray[49] = -104;
        byArray[50] = -103;
        byArray[51] = -98;
        byArray[52] = -97;
        byArray[53] = -100;
        byArray[54] = -99;
        byArray[55] = -110;
        byArray[56] = -109;
        byArray[57] = -112;
        byArray[58] = -111;
        byArray[59] = -106;
        byArray[60] = -105;
        byArray[61] = -108;
        byArray[62] = -107;
        byArray[63] = -22;
        byArray[64] = -24;
        byArray[65] = -23;
        byArray[66] = -18;
        byArray[67] = -17;
        byArray[68] = -20;
        byArray[69] = -19;
        byArray[70] = -30;
        byArray[71] = -29;
        byArray[72] = -32;
        byArray[73] = -31;
        byArray[74] = -26;
        byArray[75] = -25;
        byArray[76] = -28;
        byArray[77] = -27;
        byArray[78] = -6;
        byArray[79] = -8;
        byArray[80] = -2;
        byArray[81] = -1;
        byArray[82] = -4;
        byArray[83] = -3;
        byArray[84] = -14;
        byArray[85] = -13;
        byArray[86] = -16;
        byArray[87] = -15;
        byArray[88] = -10;
        byArray[89] = -9;
        byArray[90] = -12;
        byArray[91] = -11;
        byArray[92] = -53;
        byArray[93] = -55;
        byArray[94] = -49;
        byArray[95] = -51;
        byArray[96] = -62;
        byArray[97] = -61;
        byArray[98] = -64;
        byArray[99] = -63;
        byArray[100] = -58;
        byArray[101] = -57;
        byArray[102] = -60;
        byArray[103] = -59;
        byArray[104] = -38;
        byArray[105] = -37;
        byArray[106] = -40;
        byArray[107] = -39;
        byArray[108] = -34;
        byArray[109] = -33;
        byArray[110] = -36;
        byArray[111] = -35;
        byArray[112] = -46;
        byArray[113] = -46;
        byArray[114] = -45;
        byArray[115] = -45;
        byArray[116] = -48;
        byArray[117] = -48;
        byArray[118] = -47;
        byArray[119] = -47;
        byArray[120] = -42;
        byArray[121] = -42;
        byArray[122] = -41;
        byArray[123] = -41;
        byArray[124] = -44;
        byArray[125] = -44;
        byArray[126] = -43;
        byArray[127] = -43;
        byArray[128] = 42;
        byArray[129] = 43;
        byArray[130] = 40;
        byArray[131] = 41;
        byArray[132] = 46;
        byArray[133] = 47;
        byArray[134] = 44;
        byArray[135] = 45;
        byArray[136] = 34;
        byArray[137] = 35;
        byArray[138] = 32;
        byArray[139] = 33;
        byArray[140] = 38;
        byArray[141] = 39;
        byArray[142] = 36;
        byArray[143] = 37;
        byArray[144] = 58;
        byArray[145] = 59;
        byArray[146] = 56;
        byArray[147] = 57;
        byArray[148] = 62;
        byArray[149] = 63;
        byArray[150] = 60;
        byArray[151] = 61;
        byArray[152] = 50;
        byArray[153] = 51;
        byArray[154] = 48;
        byArray[155] = 49;
        byArray[156] = 54;
        byArray[157] = 55;
        byArray[158] = 52;
        byArray[159] = 53;
        byArray[160] = 10;
        byArray[161] = 11;
        byArray[162] = 8;
        byArray[163] = 9;
        byArray[164] = 14;
        byArray[165] = 15;
        byArray[166] = 12;
        byArray[167] = 13;
        byArray[168] = 2;
        byArray[169] = 3;
        byArray[171] = 1;
        byArray[172] = 6;
        byArray[173] = 7;
        byArray[174] = 4;
        byArray[175] = 5;
        byArray[176] = 27;
        byArray[177] = 24;
        byArray[178] = 25;
        byArray[179] = 30;
        byArray[180] = 31;
        byArray[181] = 28;
        byArray[182] = 29;
        byArray[183] = 18;
        byArray[184] = 19;
        byArray[185] = 16;
        byArray[186] = 17;
        byArray[187] = 22;
        byArray[188] = 23;
        byArray[189] = 20;
        byArray[190] = 21;
        byArray[191] = 106;
        byArray[192] = 104;
        byArray[193] = 105;
        byArray[194] = 110;
        byArray[195] = 111;
        byArray[196] = 108;
        byArray[197] = 109;
        byArray[198] = 98;
        byArray[199] = 99;
        byArray[200] = 96;
        byArray[201] = 97;
        byArray[202] = 102;
        byArray[203] = 103;
        byArray[204] = 100;
        byArray[205] = 101;
        byArray[206] = 122;
        byArray[207] = 120;
        byArray[208] = 126;
        byArray[209] = 127;
        byArray[210] = 124;
        byArray[211] = 125;
        byArray[212] = 114;
        byArray[213] = 115;
        byArray[214] = 112;
        byArray[215] = 113;
        byArray[216] = 118;
        byArray[217] = 119;
        byArray[218] = 116;
        byArray[219] = 117;
        byArray[220] = 75;
        byArray[221] = 73;
        byArray[222] = 79;
        byArray[223] = 77;
        byArray[224] = 66;
        byArray[225] = 67;
        byArray[226] = 64;
        byArray[227] = 65;
        byArray[228] = 70;
        byArray[229] = 71;
        byArray[230] = 68;
        byArray[231] = 69;
        byArray[232] = 90;
        byArray[233] = 91;
        byArray[234] = 88;
        byArray[235] = 89;
        byArray[236] = 94;
        byArray[237] = 95;
        byArray[238] = 92;
        byArray[239] = 93;
        byArray[240] = 82;
        byArray[241] = 82;
        byArray[242] = 83;
        byArray[243] = 83;
        byArray[244] = 80;
        byArray[245] = 80;
        byArray[246] = 81;
        byArray[247] = 81;
        byArray[248] = 86;
        byArray[249] = 86;
        byArray[250] = 87;
        byArray[251] = 87;
        byArray[252] = 84;
        byArray[253] = 84;
        byArray[254] = 85;
        byArray[255] = 85;
        u2a = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = -86;
        byArray2[1] = -85;
        byArray2[2] = -88;
        byArray2[3] = -87;
        byArray2[4] = -82;
        byArray2[5] = -81;
        byArray2[6] = -84;
        byArray2[7] = -83;
        byArray2[8] = -94;
        byArray2[9] = -93;
        byArray2[10] = -96;
        byArray2[11] = -95;
        byArray2[12] = -90;
        byArray2[13] = -89;
        byArray2[14] = -92;
        byArray2[15] = -91;
        byArray2[16] = -71;
        byArray2[17] = -70;
        byArray2[18] = -73;
        byArray2[19] = -72;
        byArray2[20] = -67;
        byArray2[21] = -66;
        byArray2[22] = -69;
        byArray2[23] = -68;
        byArray2[24] = -79;
        byArray2[25] = -78;
        byArray2[26] = -80;
        byArray2[27] = -80;
        byArray2[28] = -75;
        byArray2[29] = -74;
        byArray2[30] = -77;
        byArray2[31] = -76;
        byArray2[32] = -118;
        byArray2[33] = -117;
        byArray2[34] = -120;
        byArray2[35] = -119;
        byArray2[36] = -114;
        byArray2[37] = -113;
        byArray2[38] = -116;
        byArray2[39] = -115;
        byArray2[40] = -126;
        byArray2[41] = -125;
        byArray2[42] = -128;
        byArray2[43] = -127;
        byArray2[44] = -122;
        byArray2[45] = -121;
        byArray2[46] = -124;
        byArray2[47] = -123;
        byArray2[48] = -102;
        byArray2[49] = -101;
        byArray2[50] = -104;
        byArray2[51] = -103;
        byArray2[52] = -98;
        byArray2[53] = -97;
        byArray2[54] = -100;
        byArray2[55] = -99;
        byArray2[56] = -110;
        byArray2[57] = -109;
        byArray2[58] = -112;
        byArray2[59] = -111;
        byArray2[60] = -106;
        byArray2[61] = -105;
        byArray2[62] = -108;
        byArray2[63] = -107;
        byArray2[64] = -30;
        byArray2[65] = -29;
        byArray2[66] = -32;
        byArray2[67] = -31;
        byArray2[68] = -26;
        byArray2[69] = -25;
        byArray2[70] = -28;
        byArray2[71] = -27;
        byArray2[72] = -35;
        byArray2[73] = -35;
        byArray2[74] = -36;
        byArray2[75] = -36;
        byArray2[76] = -33;
        byArray2[77] = -33;
        byArray2[78] = -34;
        byArray2[79] = -34;
        byArray2[80] = -12;
        byArray2[81] = -10;
        byArray2[82] = -16;
        byArray2[83] = -14;
        byArray2[84] = -4;
        byArray2[85] = -2;
        byArray2[86] = -8;
        byArray2[87] = -6;
        byArray2[88] = -22;
        byArray2[89] = -21;
        byArray2[90] = -24;
        byArray2[91] = -23;
        byArray2[92] = -18;
        byArray2[93] = -17;
        byArray2[94] = -20;
        byArray2[95] = -19;
        byArray2[96] = -56;
        byArray2[97] = -55;
        byArray2[98] = -58;
        byArray2[99] = -57;
        byArray2[100] = -52;
        byArray2[101] = -51;
        byArray2[102] = -54;
        byArray2[103] = -53;
        byArray2[104] = -64;
        byArray2[105] = -63;
        byArray2[106] = -65;
        byArray2[107] = -65;
        byArray2[108] = -60;
        byArray2[109] = -59;
        byArray2[110] = -62;
        byArray2[111] = -61;
        byArray2[112] = -42;
        byArray2[113] = -41;
        byArray2[114] = -44;
        byArray2[115] = -43;
        byArray2[116] = -38;
        byArray2[117] = -37;
        byArray2[118] = -40;
        byArray2[119] = -39;
        byArray2[120] = -49;
        byArray2[121] = -49;
        byArray2[122] = -50;
        byArray2[123] = -50;
        byArray2[124] = -46;
        byArray2[125] = -45;
        byArray2[126] = -48;
        byArray2[127] = -47;
        byArray2[128] = 42;
        byArray2[129] = 43;
        byArray2[130] = 40;
        byArray2[131] = 41;
        byArray2[132] = 46;
        byArray2[133] = 47;
        byArray2[134] = 44;
        byArray2[135] = 45;
        byArray2[136] = 34;
        byArray2[137] = 35;
        byArray2[138] = 32;
        byArray2[139] = 33;
        byArray2[140] = 38;
        byArray2[141] = 39;
        byArray2[142] = 36;
        byArray2[143] = 37;
        byArray2[144] = 57;
        byArray2[145] = 58;
        byArray2[146] = 55;
        byArray2[147] = 56;
        byArray2[148] = 61;
        byArray2[149] = 62;
        byArray2[150] = 59;
        byArray2[151] = 60;
        byArray2[152] = 49;
        byArray2[153] = 50;
        byArray2[154] = 48;
        byArray2[155] = 48;
        byArray2[156] = 53;
        byArray2[157] = 54;
        byArray2[158] = 51;
        byArray2[159] = 52;
        byArray2[160] = 10;
        byArray2[161] = 11;
        byArray2[162] = 8;
        byArray2[163] = 9;
        byArray2[164] = 14;
        byArray2[165] = 15;
        byArray2[166] = 12;
        byArray2[167] = 13;
        byArray2[168] = 2;
        byArray2[169] = 3;
        byArray2[171] = 1;
        byArray2[172] = 6;
        byArray2[173] = 7;
        byArray2[174] = 4;
        byArray2[175] = 5;
        byArray2[176] = 26;
        byArray2[177] = 27;
        byArray2[178] = 24;
        byArray2[179] = 25;
        byArray2[180] = 30;
        byArray2[181] = 31;
        byArray2[182] = 28;
        byArray2[183] = 29;
        byArray2[184] = 18;
        byArray2[185] = 19;
        byArray2[186] = 16;
        byArray2[187] = 17;
        byArray2[188] = 22;
        byArray2[189] = 23;
        byArray2[190] = 20;
        byArray2[191] = 21;
        byArray2[192] = 98;
        byArray2[193] = 99;
        byArray2[194] = 96;
        byArray2[195] = 97;
        byArray2[196] = 102;
        byArray2[197] = 103;
        byArray2[198] = 100;
        byArray2[199] = 101;
        byArray2[200] = 93;
        byArray2[201] = 93;
        byArray2[202] = 92;
        byArray2[203] = 92;
        byArray2[204] = 95;
        byArray2[205] = 95;
        byArray2[206] = 94;
        byArray2[207] = 94;
        byArray2[208] = 116;
        byArray2[209] = 118;
        byArray2[210] = 112;
        byArray2[211] = 114;
        byArray2[212] = 124;
        byArray2[213] = 126;
        byArray2[214] = 120;
        byArray2[215] = 122;
        byArray2[216] = 106;
        byArray2[217] = 107;
        byArray2[218] = 104;
        byArray2[219] = 105;
        byArray2[220] = 110;
        byArray2[221] = 111;
        byArray2[222] = 108;
        byArray2[223] = 109;
        byArray2[224] = 72;
        byArray2[225] = 73;
        byArray2[226] = 70;
        byArray2[227] = 71;
        byArray2[228] = 76;
        byArray2[229] = 77;
        byArray2[230] = 74;
        byArray2[231] = 75;
        byArray2[232] = 64;
        byArray2[233] = 65;
        byArray2[234] = 63;
        byArray2[235] = 63;
        byArray2[236] = 68;
        byArray2[237] = 69;
        byArray2[238] = 66;
        byArray2[239] = 67;
        byArray2[240] = 86;
        byArray2[241] = 87;
        byArray2[242] = 84;
        byArray2[243] = 85;
        byArray2[244] = 90;
        byArray2[245] = 91;
        byArray2[246] = 88;
        byArray2[247] = 89;
        byArray2[248] = 79;
        byArray2[249] = 79;
        byArray2[250] = 78;
        byArray2[251] = 78;
        byArray2[252] = 82;
        byArray2[253] = 83;
        byArray2[254] = 80;
        byArray2[255] = 81;
        a2u = byArray2;
    }
}

